<?php
// $Id: weblinks_page_frame.php,v 1.1 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//=========================================================
// WebLinks Module
// 2006-05-15 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_page_frame') ) 
{

//=========================================================
// class page_frame
//=========================================================
class weblinks_page_frame
{
// class instance
	var $_handler;
	var $_pagenavi;
	var $_form;

// constant
	var $_PERPAGE        = 50;
	var $_MAX_SORTID     = 1;
	var $_SCRIPT         = '';
	var $_FORM_NAME      = 'weblinks';
	var $_HEAD_CLASS     = '';
	var $_HEAD_ALIGN     = 'center';
	var $_ITEM_CLASS     = '';
	var $_ITEM_ALIGN     = '';
	var $_SUBMIT_CLASS   = 'foot';
	var $_SUBMIT_ALIGN   = 'center';
	var $_SUBMIT_NAME    = 'submit';
	var $_NO_ITEM_COLOR  = '#0000ff';	// blue
	var $_NO_ITEM_WEIGHT = 'bold';

// language
	var $_LANG_TITLE        = 'Title';
	var $_LANG_THERE_ARE    = 'There are <b>%s</b> datas in databese';
	var $_LANG_NO_ITEM      = 'There are no item';
	var $_LANG_ID_ASC       = 'ID Ascent';
	var $_LANG_ID_DESC      = 'ID Descent';
	var $_LANG_SUBMIT_VALUE = _EDIT;

// input param
	var $_flag_sortid    = 1;
	var $_flag_alternate = 0;
	var $_flag_form      = 0;
	var $_id_name        = '';
	var $_action         = '';
	var $_op             = '';

// variable
	var $_item_count = 0; 
	var $_sortid;
	var $_total;
	var $_start;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_page_frame()
{
// class instance
	$this->_pagenavi =& weblinks_pagenavi::getInstance();
	$this->_form     =& weblinks_form::getInstance();

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_page_frame();
	}
	return $instance;
}

//---------------------------------------------------------
// main
//---------------------------------------------------------
function show()
{
	$total = $this->pre_proc();

	if ($total > 0)
	{
		$this->main_proc();
	}
	else
	{
		$this->no_item_proc();
	}

	$this->post_proc();
}

//---------------------------------------------------------
// Pre processing
//---------------------------------------------------------
function pre_proc()
{
	$this->init();

	$this->_pagenavi->setPerpage( $this->_PERPAGE );
	$this->_pagenavi->set_max_sortid( $this->_MAX_SORTID );
	$this->_pagenavi->set_flag_sortid( $this->_flag_sortid );
	$this->_sortid = $this->_pagenavi->getGetSortid();

	$total = $this->get_total();
	$this->_total = $total;

	$this->_pagenavi->setTotal($total);
	$this->_pagenavi->getGetPage();

	$this->print_top();

	return $total;
}

function init()
{
	// dummy
}

function print_top()
{
	$total_all = $this->get_total_all();

	echo "<h4>".$this->_LANG_TITLE."</h4>\n";
	printf( $this->_LANG_THERE_ARE, $total_all);
	echo "<br /><br />\n";

	echo "<ul>\n";
	echo "<li><a href='?sortid=0'>".$this->_LANG_ID_ASC."</a><br /></li>\n";
	echo "<li><a href='?sortid=1'>".$this->_LANG_ID_DESC."</a><br /></li>\n";
	echo "</ul>\n";
	echo "<br />\n";

	$this->print_top_extra();
}

function print_top_extra()
{
	// dummy
}

function get_total_all()
{
	$count = 0;

	if ( is_object($this->_handler) )
	{
		$count = $this->_handler->getCount();
	}

	return $count;
}

function get_total()
{
	$total = $this->get_total_all();
	return $total;
}

//---------------------------------------------------------
// No item processing
//---------------------------------------------------------
function no_item_proc()
{
	echo "<br />\n";
	$this->print_no_item();
}

function print_no_item()
{
	echo $this->_form->highlight($this->_LANG_NO_ITEM, $this->_NO_ITEM_COLOR, $this->_NO_ITEM_WEIGHT);
	echo "<br />\n";
}

//---------------------------------------------------------
// Post processing
//---------------------------------------------------------
function post_proc()
{
	// dummy
}

//---------------------------------------------------------
// Main processing
//---------------------------------------------------------
function main_proc()
{
	$item_arr =& $this->pre_main_proc();

	foreach ($item_arr as $item) 
	{
		$this->item_proc($item);
	}

	$this->post_main_proc();
}

function &pre_main_proc()
{
	$start = $this->_pagenavi->calcStart();
	$end   = $this->_pagenavi->calcEnd();
	$this->_start = $start;
	$this->_end   = $end;

	$this->main_proc_extra();
	$this->print_form_begin();
	$this->print_table_begin();

	$item_arr =& $this->get_items($this->_PERPAGE, $start);
	return $item_arr;
}

function main_proc_extra()
{
	// dummy
}

function item_proc( &$item )
{
	$this->print_table_item($item);
}

function post_main_proc()
{
	$navi = $this->_pagenavi->build($this->_SCRIPT);

	$this->print_table_submit();
	$this->print_table_end();
	$this->print_form_end();

	echo "<div align='center'>$navi</div>\n";
}

//---------------------------------------------------------
// form
//---------------------------------------------------------
function print_form_begin()
{
	if ($this->_flag_form)
	{
		echo $this->build_form_begin();
	}
}

function build_form_begin()
{
	$form  = $this->_form->make_form_start($this->_FORM_NAME, $this->_action);
	$form .= $this->_form->make_form_token();
	$form .= $this->_form->make_form_hidden('op', $this->_op);
	return $form;
}

function print_form_end()
{
	if ($this->_flag_form)
	{
		echo $this->build_form_end();
	}
}

function build_form_end()
{
	$text = $this->_form->make_form_end();
	return $text;
}

//---------------------------------------------------------
// table
//---------------------------------------------------------
function print_table_begin()
{
	$head_arr =& $this->get_table_header();

	echo "<table border='1'><tr>";

	foreach ($head_arr as $head)
	{
		echo $this->_form->make_table_col_head($head, $this->_HEAD_CLASS, $this->_HEAD_ALIGN);
	}

	echo "</tr>\n";

}

function print_table_end()
{
	echo "</table><br />\n";
}

function print_table_item( &$item )
{
	$col_arr =& $this->get_cols($item);

	if ($this->_flag_alternate)
	{
		$class = $this->build_table_class_alternate();
		echo "<tr class='$class'>";
	}
	else
	{
		echo "<tr>";
	}

	foreach ($col_arr as $col)
	{
		echo $this->build_table_col($col, $this->_ITEM_CLASS, $this->_ITEM_ALIGN);
	}

	echo "</tr>\n";
}

function build_table_class_alternate()
{
	if ($this->_item_count % 2 == 0) 
	{
		$class = 'even';
	}
	else 
	{
		$class = 'odd';
	}

	$this->_item_count ++;

	return $class;
}

function print_table_submit()
{
	if ($this->_flag_form)
	{
		echo $this->build_table_submit();
	}
}

function build_table_submit($colspan=2)
{
	$form  = "<tr>";
	$form  = $this->build_table_col_submit($colspan);
	$form .= "</tr>\n";
	return $form;
}

function build_table_col_submit($colspan=0)
{
	$submit = $this->_form->make_form_submit($this->_SUBMIT_NAME, $this->_LANG_SUBMIT_VALUE);
	$text   = $this->_form->make_table_col($submit, $this->_SUBMIT_CLASS, $this->_SUBMIT_ALIGN, $colspan);
	return $text;
}

function build_table_col_null($class, $colspan=0)
{
	$text = $this->_form->make_table_col('', $class, '', $colspan);
	return $text;
}

function build_table_col($value, $class='', $align='', $colspan=0)
{
	$text = $this->_form->make_table_col($value, $class, $align, $colspan);
	return $text;
}

//---------------------------------------------------------
// sample of handler
//---------------------------------------------------------
function &get_table_header()
{
	$arr = array(
		'id',
		'title',
	);

	return $arr;
}

function &get_items($limit=0, $start=0)
{
	$criteria = new CriteriaCompo();
	$criteria->setStart($start);
	$criteria->setLimit($limit);

	if ($this->_sortid == 1)
	{
		$sort = $this->_id_name.' DESC';
		$criteria->setSort($sort);
	}

	$objs =& $this->_handler->getObjects($criteria);
	return $objs;
}

function &get_cols( &$obj )
{
	$id    = $this->build_text_by_obj($obj, $this->_id_name);
	$id    = $this->build_formated_id($id);
	$title = $this->build_text_by_obj($obj, 'title');

	$arr = array(
		$id,
		$title,
	);

	return $arr;
}

//---------------------------------------------------------
// utility
//---------------------------------------------------------
function build_html_id_link_by_obj(&$obj, $key, $jump, $title='', $target='')
{
	if ( !is_object($obj) )  { return false; }

	$id = $obj->getVar($key);
	$jump_id = $jump.$id;

	if ( empty($title) )
	{
		$title = $this->build_formated_id($id);
	}

	$text = $this->_form->make_html_url_link($jump_id, $title, $target);
	return $text;
}

function build_html_name_link_by_obj(&$obj, $key1, $key2='', $target='')
{
	if ( !is_object($obj) )  { return false; }

	$url = $obj->getVar($key1, 's');

	if ($key2)
	{
		$name = $obj->getVar($key2, 's');
	}
	else
	{
		$name = $url;
	}

	if ($url)
	{
		$text = $this->_form->make_html_url_link($url, $name, $target);
		return $text;
	}

	return '&nbsp;';
}

function build_text_by_obj(&$obj, $key)
{
	if ( !is_object($obj) )  { return false; }

	$text = $obj->getVar($key, 's');

	if ($text)
	{
		return $text;
	}

	return '&nbsp;';
}

function build_formated_id($id, $format="%03d")
{
	$text = sprintf($format, $id);
	return $text;
}

//---------------------------------------------------------
// form class
//---------------------------------------------------------
function build_html_url_link($url, $name='', $target='', $flag_name_sanitize=true )
{
	$text = $this->_form->make_html_url_link($url, $name, $target, $flag_name_sanitize );
	return $text;
}

function build_html_img($url, $width=0, $height=0, $border=0, $alt='image')
{
	$text = $this->_form->make_html_img($url, $width, $height, $border, $alt);
	return $text;
}

function build_html_input_text($name, $value, $size=50, $maxlength=255)
{
	$text = $this->_form->make_form_text($name, $value, $size, $maxlength);
	return $text;
}


//---------------------------------------------------------
// set param
//---------------------------------------------------------
function set_handler($table_name, $dirname)
{
	$this->_handler =& weblinks_get_handler($table_name, $dirname);
}

function set_id_name($value)
{
	$this->_id_name = $value;
}

function set_flag_sortid($value)
{
	$this->_flag_sortid = intval($value);
}

function set_flag_alternate($value)
{
	$this->_flag_alternate = intval($value);
}

function set_flag_form($value)
{
	$this->_flag_form = intval($value);
}

function set_action($value)
{
	$this->_action = $value;
}

function set_operation($value)
{
	$this->_op = $value;
}

function set_perpage($value)
{
	$this->_PERPAGE = intval($value);
}

function set_max_sortid($value)
{
	$this->_MAX_SORTID = intval($value);
}

function set_script($value)
{
	$this->_SCRIPT = $value;
}

function set_head_align($value)
{
	$this->_HEAD_ALIGN = $value;
}

function set_head_class($value)
{
	$this->_HEAD_CLASS = $value;
}

function set_item_align($value)
{
	$this->_ITEM_ALIGN = $value;
}

function set_item_class($value)
{
	$this->_ITEM_CLASS = $value;
}

function set_submit_name($value)
{
	$this->_SUBMIT_NAME = $value;
}

function set_submit_align($value)
{
	$this->_SUBMIT_ALIGN = $value;
}

function set_submit_class($value)
{
	$this->_SUBMIT_CLASS = $value;
}

function set_form_name($value)
{
	$this->_FORM_NAME = $value;
}

function set_no_item_color($value)
{
	$this->_NO_ITEM_COLOR = $value;
}

function set_no_item_weight($value)
{
	$this->_NO_ITEM_WEIGHT = $value;
}

function set_lang_title($value)
{
	$this->_LANG_TITLE = $value;
}

function set_lang_there_are($value)
{
	$this->_LANG_THERE_ARE = $value;
}

function set_lang_no_item($value)
{
	$this->_LANG_NO_ITEM = $value;
}

function set_lang_id_asc($value)
{
	$this->_LANG_ID_ASC = $value;
}

function set_lang_id_desc($value)
{
	$this->_LANG_ID_DESC = $value;
}

function set_lang_submit_value($value)
{
	$this->_LANG_SUBMIT_VALUE = $value;
}


// --- class end ---
}

// === class end ===
}

?>