<?php
// $Id: weblinks_remote_file.php,v 1.3 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// suppress notice : Only variable references should be returned by reference

// 2006-04-13 K.OHWADA
// BUG 3858: Fatal error when allow_url_fopen = off

//=========================================================
// WebLinks Module
// same as rssc_remote_file of Rss Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_remote_file') ) 
{

//---------------------------------------------------------
// define constant
//---------------------------------------------------------
define('WEBLINKS_REMOTE_E_EMPTY_URL',  100);
define('WEBLINKS_REMOTE_E_NOT_FOPEN',  101);
define('WEBLINKS_REMOTE_E_NOT_FCLOSE', 102);
define('WEBLINKS_REMOTE_E_NOT_FWRITE', 104);
define('WEBLINKS_REMOTE_E_NO_RESULT',  105);

define('WEBLINKS_SNOPPY_E_NOT_FETCH', 110);
define('WEBLINKS_SNOPPY_E_NO_RESULT', 111);

//=========================================================
// class weblinks_remote_file
// use class snoopy
//=========================================================
class weblinks_remote_file
{
// class instance
	var $_snoopy;

// file pointer
	var $_fp;

// variable
	var $_flag_allow_url_fopen;
	var $_error_code = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_remote_file()
{

// class instance
	$this->_snoopy = new Snoopy();

// allow_url_fopen
	$this->_flag_allow_url_fopen = ini_get('allow_url_fopen');

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_remote_file();
	}

	return $instance;
}


//---------------------------------------------------------
// check_url
//---------------------------------------------------------
function check_url($url)
{
	$this->_error_code = 0;

	if ( empty($url) )
	{
		$this->_error_code = WEBLINKS_REMOTE_E_EMPTY_URL;
		return false;
	}

// allow_url_fopen
	if ( $this->_flag_allow_url_fopen )
	{
		$ret = $this->_check_url_local( $url );
		return $ret;
	}
// not allow_url_fopen
	else
	{
		$ret = $this->_check_url_remote( $url );
		return $ret;
	}
	
}

function _check_url_local($url)
{
	if ( $this->_fopen($url, "r") )
	{
		$this->_fclose();
		return true;
	}
	else
	{
		return false;
	}
}


//=========================================================
// read_file
//=========================================================
function read_file($url)
{
	$this->_error_code = 0;

	if ( empty($url) )
	{
		$this->_error_code = WEBLINKS_REMOTE_E_EMPTY_URL;
		return false;
	}

// allow_url_fopen
	if ( $this->_flag_allow_url_fopen )
	{
		$ret = $this->_read_file_local( $url );
		return $ret;
	}
// not allow_url_fopen
	else
	{
		$ret = $this->_read_file_remote( $url );
		return $ret;
	}

}

//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function getErrorCode()
{
	return $this->_error_code;
}

//=========================================================
// private function
//=========================================================
//---------------------------------------------------------
// open & close file
//---------------------------------------------------------
function _fopen( $filename, $mode )
{
	$this->_fp = false;

	$fp = fopen($filename, $mode);

	if ( !$fp )
	{
		$this->_error_code = WEBLINKS_REMOTE_E_NOT_FOPEN;
		return false;
	}

	$this->_fp = $fp;
	return $fp;
}

function _fclose()
{
	if ( !$this->_fp )  return false;

	if ( fclose($this->_fp) )
	{
		return true;
	}
	else
	{
		$this->_error_code = WEBLINKS_REMOTE_E_NOT_FCLOSE;
		return false;
	}
}

//---------------------------------------------------------
// read file
//---------------------------------------------------------
function _read_file_local( $filename )
{
	$fp = $this->_fopen( $filename, "r" );
	if ( !$fp )
	{
		return false;
	}

	$content = $this->_fread();
	$this->_fclose();

	return $content;
}

function _fread()
{
	if ( !$this->_fp )  return false;

	$content = '';

	do 
	{
		$data = fread($this->_fp, 8192);
		if ( strlen($data) == 0 )  break;
		$content .= $data;
	} while(true);

	if ($content)
	{
		return $content;
	}
	else
	{
		$this->_error_code = WEBLINKS_REMOTE_E_NO_RESULT;
		return false;
	}
}

//---------------------------------------------------------
// write file
//---------------------------------------------------------
// BUG 3858: Fatal error when allow_url_fopen = off
// change _write to _fwrite
function _fwrite_file( $filename, $data )
{
	$fp = $this->_fopen( $filename, "w" );
	if ( !$fp )
	{
		return false;
	}

	$ret = $this->_fwrite($data);
	$this->_fclose();

	return $ret;
}

function _fwrite($data)
{
	if ( fwrite($this->_fp, $data) )
	{
		return true;
	}
	else
	{
		$this->_error_code = WEBLINKS_REMOTE_E_NOT_FWRITE;
		return false;
	}
}

//=========================================================
// use class spoopy
//=========================================================
function _check_url_remote( $url )
{
	$ret = $this->_snoppy_fetch( $url );
	return $ret;
}

function _read_file_remote( $url )
{
	$ret = $this->_snoppy_fetch( $url );
	return $ret;
}

function _snoppy_fetch( $url )
{
	if ( $this->_snoopy->fetch( $url ) )
	{
		$res = $this->_snoopy->results;

		if ($res)
		{
			return $res;
		}
		else
		{
			$this->_error_code = WEBLINKS_SNOPPY_E_NO_RESULT;
			return false;
		}
	}
	else
	{
		$this->_error_code = WEBLINKS_SNOPPY_E_NOT_FETCH;
		return false;
	}
}

//----- class end -----
}

// === class end ===
}

?>