<?php
// $Id: weblinks_strings.php,v 1.1 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// this is new file
// NOT use system class
// NOT use MyTextSanitizer

//=========================================================
// WebLinks Module
// porting from RSSC
// 2006-05-15 K.OHWADA
//=========================================================

//---------------------------------------------------------
// TODO
// global $xoopsConfig
// in convert_space_zen_to_han(), processing special when Japanese
//---------------------------------------------------------

// === class begin ===
if( !class_exists('weblinks_strings') ) 
{

//=========================================================
// class weblinks_strings
//=========================================================
class weblinks_strings
{

// local variable
	var $_max_summary = 100;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_strings()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_strings();
	}

	return $instance;
}

// --------------------------------------------------------
// summary
// --------------------------------------------------------
function make_summary($text, $max, $format='n')
{
	$text = $this->strip_tags_for_text($text);
	$text = $this->shorten_text($text, $max);
	$text = $this->make_format($text, $format);
	return $text;
}

function strip_tags_for_text($text)
{
	$text = $this->strip_control_code($text);
	$text = $this->strip_crlf($text);
	$text = $this->strip_style_tag($text);
	$text = $this->add_space_after_tag($text);
	$text = strip_tags($text);
	$text = $this->strip_space($text);
	return $text;
}

// --------------------------------------------------------
// onvert_array_key_to_string
// array($key => $value)  ==> $key:$value
// --------------------------------------------------------
function convert_array_key_to_string($arr)
{
	if ( (count($arr) == 0) || !is_array($arr) )
	{
		return '';
	}

	$str = '';

	foreach ($arr as $key => $value)
	{
// replace return code
		$value = preg_replace("/\n/", '\\n', $value);

		$str .= $key.":".$value."\n";
	}

	return $str;
}

function convert_string_to_array_key($str, $format='n')
{
	$array = array();

	$line_arr = $this->convert_string_to_array($str, "\n");

	if ( count($line_arr) == 0 )  return $array;

	foreach ($line_arr as $line)
	{
		list($key, $value) = split(":", $line, 2);

// replace return code
		$value = preg_replace('/\\n/', "\n", $value);

		$array[$key] = $this->make_format($value, $format);
	}

	return $array;
}


//---------------------------------------------------------
// convert array to string
// array($a, $b, $c)  ==> $a & $b & $c
//---------------------------------------------------------
function convert_array_to_string($arr, $pattern='&')
{
	if ( is_array($arr) )
	{
		$str = $pattern;

		foreach ($arr as $value)
		{
			$str .= intval($value).$pattern;
		}
	}
	elseif ( is_int($arr) )
	{
		$str = $pattern.intval($arr).$pattern;
	}
	else
	{
		$str = $arr;
	}

	return $str;
}

function convert_string_to_array($str, $pattern='&')
{
	$str_arr = split($pattern, $str);

	$i = 0;	
	$arr = array();
	foreach ($str_arr as $value)
	{
		$value = trim($value);

		if ($value == '')  continue;

		$arr[$i++] = $value;
	}

	return $arr;
}

// --------------------------------------------------------
// sanitize and convert htmlspecialchars for textarea
//   <  -> &lt;
//   >  -> &gt;
//   "  -> &quot;
//   '  -> &#039;
// --------------------------------------------------------
function sanitize_html_text($text)
{
	$text = $this->strip_control_code($text);
	$text = $this->strip_crlf($text);
	$text = $this->conv_js($text);
	$text = htmlspecialchars($text, ENT_QUOTES);
	$text = preg_replace("/&amp;/i", '&', $text);
	return $text;
}

// --------------------------------------------------------
// sanitize and convert htmlspecialchars for textarea
//   <  -> &lt;
//   >  -> &gt;
//   "  -> &quot;
//   '  -> &#039;
// --------------------------------------------------------
function sanitize_html_textarea($text)
{
	$text = $this->strip_control_code($text);
	$text = $this->conv_js($text);
	$text = htmlspecialchars($text, ENT_QUOTES);
	$text = preg_replace("/&amp;/i", '&', $text);
	return $text;
}

//---------------------------------------------------------
// sanitize and convert htmlspecialchars for url
//   <     -> &lt;
//   >     -> &gt;
//   "     -> &quot;
//   '     -> &#039;
//   &     -> &amp;
//   &amp; -> &amp;
//---------------------------------------------------------
function sanitize_html_url($text)
{
	$text = $this->strip_control_code($text);
	$text = $this->strip_crlf($text);
	$text = $this->conv_js($text);
	$text = preg_replace('/&amp;/i', '&', $text);
	$text = htmlspecialchars($text, ENT_QUOTES);
	return $text;
}

// --------------------------------------------------------
// replace_control_code
// --------------------------------------------------------
function replace_crlf($str)
{
	$str = str_replace('\r\n', "\r\n", $str);
	$str = str_replace('\r',   "\r",   $str);
	$str = str_replace('\n',   "\n",   $str);
	return $str;
}

// --------------------------------------------------------
// strip_control_code
// --------------------------------------------------------
function strip_control_code($text)
{
	$text = preg_replace('/[\x00-\x09]/',' ',$text);
	$text = preg_replace('/[\x0B-\x0C]/',' ',$text);
	$text = preg_replace('/[\x0E-\x1F]/',' ',$text);
	$text = preg_replace('/[\x7F]/',     ' ',$text);
	return $text;
}

function strip_crlf($text)
{
	$text = preg_replace("/\r/",' ',$text);
	$text = preg_replace("/\n/",' ',$text);
	return $text;
}

function strip_style_tag($text)
{
	$text = preg_replace('|<\s*style\s?.*?>(.*)<\s*/\s*style\s*>|is', '', $text);
	return $text;
}

function add_space_after_tag($text)
{
	$text = str_replace(">",   "> ", $text);
	return $text;
}

//--------------------------------------------------------
// strip_space
//--------------------------------------------------------
function strip_space($text)
{
	$text = $this->convert_space_zen_to_han($text);
	$text = preg_replace("/&nbsp;/i", ' ', $text);
	$text = preg_replace("/[\x20]+/", ' ', $text);
	return $text;
}

//--------------------------------------------------------
// sanitaize text
//--------------------------------------------------------
function conv_js($text)
{
	$text = preg_replace('/javascript:/si', 'java script:', $text);
	$text = preg_replace('/about:/si', 'about :', $text);
	return $text;
}

//--------------------------------------------------------
// sanitize text for HTML
//--------------------------------------------------------
function make_format($text, $format='n')
{
	switch (strtolower($format)) 
	{
		case 's':
		case 'show':
		case 'e':
		case 'edit':
			$text = $this->sanitize_html_text($text);
			break;

		case 'p':
		case 'preview':
		case 'f':
		case 'formpreview':
			$text = $this->strip_slashes_gpc($text);
			$text = $this->sanitize_html_text($text);
			break;

		case 'n':
		case 'none':
		default:
			break;
	}
	return $text;
}

function strip_slashes_gpc($text)
{
	if (get_magic_quotes_gpc()) 
	{
		$text = stripslashes($text);
	}
	return $text;
}

//-------------------------------------------------------------------
// highlight
//-------------------------------------------------------------------
function highlight($str, $color='#ff0000', $weight='bold')
{
	$span_1 = '';
	$span_2 = '';

	if ( $color && $weight )
	{
		$span_1 = "<span style='color: $color; font-weight: $weight; '>";
		$span_2 = "</span>";
	}
	elseif ( $color )
	{
		$span_1 = "<span style='color: $color; '>";
		$span_2 = "</span>";
	}
	elseif ( $weight )
	{
		$span_1 = "<span style='font-weight: $weight; '>";
		$span_2 = "</span>";
	}

	$str = $span_1.$str.$span_2;

	return $str;
}

function highlight_number($num, $limit_under=0, $color='#ff0000', $weight='bold')
{

	if ($num > $limit_under)
	{
		$num = $this->highlight($num, $color, $weight);
	}

	return $num;
}

//--------------------------------------------------------
// format time
//--------------------------------------------------------
function format_time($time, $format='mysql')
{
	$text = formatTimestamp( $time, $format );
	return $text;
}

//--------------------------------------------------------
// make_url_null
//--------------------------------------------------------
function make_url_null($url, $default='http://')
{
	if ($url)
	{
		return $url;
	}
	else
	{
		return $default;
	}
}

//--------------------------------------------------------
// split_nl
//--------------------------------------------------------
function split_nl($text)
{
	$text = $this->convert_nl($text);
	$text = split("\n", $text);
	return $text;
}

//--------------------------------------------------------
// convert_nl
//--------------------------------------------------------
function convert_nl($text)
{
	$text = str_replace( "\r\n", "\n", $text ); 
	$text = str_replace( "\n\r", "\n", $text ); 
	$text = str_replace( "\r",   "\n", $text ); 
	return $text;
}

//--------------------------------------------------------
// set parameter
//--------------------------------------------------------
function set_max_summary($value)
{
	$this->_max_summary = intval($value);
}

//--------------------------------------------------------
// build html format
//--------------------------------------------------------
function build_html_image_link($url, $alt='', $width=0, $height=0, $border=0)
{
	if ( empty($url) || ($url == "http://") || ($url == "https://")  )
	{
		return false;
	}

	$width  = intval($width);
	$height = intval($height);
	$border = intval($border);
	$url    = $this->sanitize_html_text($url);
	$alt    = $this->sanitize_html_text($alt);

	$link  = "<img ";
	$link .= "src='$url' ";

	if ($width)
	{
		$link .= "width='$width' ";
	}

	if ($height)
	{
		$link .= "height='$height' ";
	}

	$link .= "border='$border' ";
	$link .= "alt='$alt' ";
	$link .= "/>";

	return $link;
}

function build_html_link_name($url, $name='', $target='', $flag_name_sanitize=true )
{
	$url    = $this->sanitize_html_url( $url );
	$target = $this->sanitize_html_text($target);

	if ($flag_name_sanitize)
	{
		$name = $this->sanitize_html_text($name);
	}

	if ( $url && $name && $target )
	{
		$link = "<a href='".$url."' target='".$target."'>".$name."</a>";
	}
	elseif ( $url && $name )
	{
		$link = "<a href='".$url."'>".$name."</a>";
	}
	elseif ( $url && $target )
	{
		$link = "<a href='".$url."' target='".$target."'>".$url."</a>";
	}
	elseif ( $url )
	{
		$link = "<a href='".$url."'>".$url."</a>";
	}
	elseif ( $name )
	{
		$link = $name;
	}
	else
	{
		$link = '';
	}

	return $link;
}

function build_html_link_email($url, $name='', $target='', $flag_name_sanitize=true  )
{
	$url    = $this->sanitize_html_url($url);
	$target = $this->sanitize_html_text($target);

	if ($flag_name_sanitize)
	{
		$name = $this->sanitize_html_text($name);
	}

	if ( $url && $name &&  $target )
	{
		$link = "<a href='mailto:".$url."' target='".$target."'>".$name."</a>";
	}
	elseif ( $url && $name )
	{
		$link = "<a href='mailto:".$url."'>".$name."</a>";
	}
	elseif ( $url &&  $target )
	{
		$link = "<a href='mailto:".$url."' target='".$target."'>".$url."</a>";
	}
	elseif ( $url )
	{
		$link = "<a href='mailto:".$url."'>".$url."</a>";
	}
	elseif ( $name )
	{
		$link = $name;
	}
	else
	{
		$link = '';
	}

	return $link;
}

//========================================================
// multibyte function
//========================================================
//--------------------------------------------------------
// shorten_text
//--------------------------------------------------------
function shorten_text($text, $max)
{
// nothing, if zero
	if ($max == 0)
	{
		return '';
	}

// unlimited, if minus
	if ($max < 0)
	{
		return $text;
	}

// less than
	if ( strlen($text) <= $max)
	{
		return $text;
	}

	if (function_exists('mb_strcut'))
	{
// cut strings for multibayte byte length
		$text = mb_strcut( $text, 0, $max )." ...";
	}
	else
	{
		$text = substr( $text, 0, $max )." ...";
	}

	return $text;
}

//--------------------------------------------------------
// convert_space_zen_to_han
//--------------------------------------------------------
function convert_space_zen_to_han($text)
{
	if ( $this->is_japanese() && function_exists('mb_convert_kana') )
	{
		$val = mb_convert_kana($text, "s");
		return $val;
	}

	return $text;
}

function is_japanese()
{
	global $xoopsConfig;

	$LANG = 'japanese';

	if ( $xoopsConfig['language'] == $LANG )
	{
		return true;
	}

	return false;
}

// --- class end ---
}

// === class end ===
}

?>