<?php
// $Id: weblinks_votedata_handler.php,v 1.2 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// new handler
// not use weblinks_module_base

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// this file contain 2 class
//   weblinks_votedata 
//   weblinks_votedata_handler
// 2004/01/14 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_votedata_handler') ) 
{

//=========================================================
// class weblinks_votedata
//=========================================================
class weblinks_votedata extends weblinks_object
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_votedata()
{
	$this->weblinks_object();

	$this->initVar('ratingid',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('lid',        XOBJ_DTYPE_INT, 0, false);
	$this->initVar('ratinguser', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('rating',     XOBJ_DTYPE_INT, 0, false);
	$this->initVar('ratinghostname',  XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('ratingtimestamp', XOBJ_DTYPE_INT,   0);
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function get_uname( $usereal=0 )
{
	$uname = '';

	$uid = $this->get('ratinguser');
	$user_handler =& xoops_gethandler('user');

	$obj = $user_handler->get($uid);
	if ( is_object($obj) )
	{
		$uname = $obj->getUnameFromId( $uid, $usereal );
	}

	return $uname;
}

function get_formatted_timestamp()
{
	$timestamp = $this->get('ratingtimestamp');
	$formatted = formatTimestamp($timestamp);
	return $formatted;
}

// --- class end ---
}

//=========================================================
// class weblinks_votedata_handler
//=========================================================
class weblinks_votedata_handler extends weblinks_object_handler
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_votedata_handler( $dirname )
{
	$this->weblinks_object_handler( $dirname, 'votedata', 'ratingid' );

	$this->set_debug_sql(   WEBLINKS_DEBUG_VOTEDATA_SQL );
	$this->set_debug_error( WEBLINKS_DEBUG_ERROR );

}

//---------------------------------------------------------
// delete
//---------------------------------------------------------
function delete_by_lid($lid)
{
	$sql = 'DELETE FROM '.$this->mTable.' WHERE lid='.intval($lid);

	if ( !$this->query($sql) )
	{	return false;	}

	return true;
}

//---------------------------------------------------------
// get count
//---------------------------------------------------------
function get_count_by_lid($lid)
{
	$lid = intval($lid);
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('lid', $lid, '=') );
	$count = $this->getCount($criteria);
	return $count;
}

function get_count_by_lid_ip_time($lid, $ip, $time)
{
	$lid  = intval($lid);
	$time = intval($time);
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('lid', $lid, '=') );
	$criteria->add( new weblinks_criteria('ratinghostname',  $ip, '=') );
	$criteria->add( new weblinks_criteria('ratingtimestamp', $time, '>') );
	$criteria->add( new weblinks_criteria('ratinguser', 0, '=') );
	$count = $this->getCount($criteria);
	return $count;
}

//---------------------------------------------------------
// get objects
//---------------------------------------------------------
function &get_objects_by_lid($lid)
{
	$lid = intval($lid);
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('lid', $lid, '=') );
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_user_by_lid($lid)
{
	$lid = intval($lid);
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('lid', $lid, '=') );
	$criteria->add( new weblinks_criteria('ratinguser', 0, '>') );
	$criteria->setSort( 'ratingtimestamp', 'DESC' );
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_by_uid($uid)
{
	$uid = intval($uid);
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('ratinguser', $uid, '=') );
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_by_lid_uid($lid, $uid)
{
	$lid = intval($lid);
	$uid = intval($uid);
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('lid', $lid, '=') );
	$criteria->add( new weblinks_criteria('ratinguser', $uid, '=') );
	$criteria->setSort( 'ratingtimestamp', 'DESC' );
	$objs =& $this->getObjects($criteria);
	return $objs;
}

//---------------------------------------------------------
// check
//---------------------------------------------------------
function check_by_lid_uid($lid, $uid)
{
	$lid = intval($lid);
	$uid = intval($uid);

	$objs =& $this->get_objects_by_lid($lid);

	if ( count($objs) == 0 )  { return false; }

	foreach ($objs as $obj)
	{
		if ( is_object($obj) )
		{
			$user = $obj->getVar('ratinguser');

			if ($user == $uid) 
			{
				return true;
			}
		}
	}

	return false;
}

//---------------------------------------------------------
// calculation
//---------------------------------------------------------
function calc_rating(&$objs)
{
	$total = 0;

	$count = count($objs);
	if ( $count == 0 )
	{
		return array(0, 0); 
	}

	foreach ($objs as $obj)
	{
		if ( is_object($obj) )
		{
			$total += $obj->get('rating');
		}
	}

	return array($count, $total);
}

function calc_rating_by_lid($lid, $decimals=4)
{
	$lid      = intval($lid);
	$decimals = intval($decimals);

	$objs =& $this->get_objects_by_lid($lid);

	list($count, $total) = $this->calc_rating($objs);
	if ($count == 0)
	{
		return array(0, 0); 
	}

	$rating = $total / $count;
	$rating = number_format($rating, $decimals);

	return array($count, $rating);
}

function calc_rating_by_uid($uid, $decimals=1)
{
	$uid      = intval($uid);
	$decimals = intval($decimals);

	$objs =& $this->get_objects_by_uid($uid);

	list($count, $total) = $this->calc_rating($objs);
	if ($count == 0)
	{
		return array(0, 0); 
	}

	$rating = $total / $count;
	$rating = number_format($rating, $decimals);

	return array($count, $rating);
}

// --- class end ---
}

// === class end ===
}

?>