<?php
// $Id: search.php,v 1.7 2006/07/23 08:19:46 ohwada Exp $

// 2006-07-23 K.OHWADA
// BUG 4153: not show catpath in search

// 2006-05-15 K.OHWADA
// add class weblinks_search()
// use class weblinks_pagenavi
// use new handler

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//================================================================
// WebLinks Module
// search
// porting from system
// 2004/01/14 K.OHWADA
//================================================================

include "header.php";
include_once WEBLINKS_ROOT_PATH."/class/weblinks_pagenavi.php";

$weblinks_template =& weblinks_template::getInstance( WEBLINKS_DIRNAME );
$weblinks_search   =& new weblinks_search();

// config
$conf_search_min = $weblinks_search->get_conf_search_min();

// not use extract
$action = $weblinks_search->get_post_get_action();
$query  = $weblinks_search->get_post_get_query();
$andor  = $weblinks_search->get_post_get_andor();

// --- template start ---
include XOOPS_ROOT_PATH."/header.php";
$xoopsOption['template_main'] = WEBLINKS_DIRNAME."_search.html";

$weblinks_template->set_search($query, $andor);
$weblinks_template->assignIndex();
$weblinks_template->assignHeader();
$weblinks_template->assignDisplayLink();

$xoopsTpl->assign('lang_result',  _SR_SEARCHRESULTS);
$xoopsTpl->assign('lang_showall', _SR_SHOWALLR);
$xoopsTpl->assign('lang_prev',    _SR_PREVIOUS);
$xoopsTpl->assign('lang_next',    _SR_NEXT);
$xoopsTpl->assign('lang_keyword', _SR_KEYWORDS.':');
$xoopsTpl->assign('lang_ignore',  sprintf(_SR_IGNOREDWORDS, $conf_search_min) );

// search form
if ($action == 'search')
{
	$xoopsTpl->assign('search_show', 0);
	$xoopsTpl->assign('search_not_show_result', '');

	include XOOPS_ROOT_PATH."/footer.php";
	exit();
}

// if no query
// REQ 2933: easy to understand error message
if ( $query == '' ) 
{
	$xoopsTpl->assign('search_show', 0);
	$xoopsTpl->assign('search_not_show_result', _SR_PLZENTER);

	include XOOPS_ROOT_PATH."/footer.php";
	exit();
}

list ($ret, $keyword, $ignore)
	= $weblinks_search->parse_query();

$xoopsTpl->assign('search_keyword', $keyword);
$xoopsTpl->assign('search_ignore',  $ignore);

// if no queriy
// REQ 2933: easy to understand error message
if ( !$ret ) 
{
	$xoopsTpl->assign('search_show', 0);
	$xoopsTpl->assign('search_not_show_result', sprintf(_SR_KEYTOOSHORT, $conf_search_min));

	include XOOPS_ROOT_PATH."/footer.php";
	exit();
}

$xoopsTpl->assign('search_show', 1);

$total = $weblinks_search->get_link_total();

if ($total > 0)
{
	list($links, $navi) = $weblinks_search->get_link_list();
	$links_list = $weblinks_template->fetch_links_list( $links );

	$xoopsTpl->assign('search_found_show', 1);
	$xoopsTpl->assign('search_found', sprintf(_SR_FOUND, $total));
	$xoopsTpl->assign('weblinks_links_list', $links_list);
	$xoopsTpl->assign('page_navi', $navi);
}
else
{
// no match data
	$xoopsTpl->assign('search_found_show', 0);
	$xoopsTpl->assign('search_not_found_result', _SR_NOMATCH);	
}

include XOOPS_ROOT_PATH."/footer.php";
exit();
// --- main end ---


//=========================================================
// class weblinks_search
//=========================================================
class weblinks_search
{

	var $_link_view_handler;
	var $_post;
	var $_strings;
	var $_pagenavi;

// config
	var $_conf_search_min;
	var $_conf_search_links;

// post
	var $_post_action;
	var $_post_andor;
	var $_post_query;

// parse
	var $_queries_arr = array();
	var $_ignored_arr = array();
	var $_andor;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_search()
{
	$this->_link_view_handler =& weblinks_get_handler( 'link_view',     WEBLINKS_DIRNAME );
	$config_handler           =& weblinks_get_handler( 'config2_basic', WEBLINKS_DIRNAME );
	$this->_post     =& weblinks_post::getInstance();
	$this->_strings  =& weblinks_strings::getInstance();
	$this->_pagenavi =& weblinks_pagenavi::getInstance();

	$conf = $config_handler->get_cached();
	$this->_conf_search_min   = $conf['search_min'];
	$this->_conf_search_links = $conf['search_links'];
}

//---------------------------------------------------------
// get POST
//---------------------------------------------------------
function get_post_get_action()
{
	$action = $this->_post->get_post_get_text('action');

	switch ( $action )
	{
		case 'results';
		case 'showall';
			$ret = 'results';
			break;

		case 'search';
		default:
			$ret = 'search';
			break;
	}

	$this->_post_action = $ret;
	return $ret;
}

function get_post_get_andor()
{
	$andor = $this->_post->get_post_get_text('andor');

	switch ( $andor )
	{
		case 'OR';
		case 'exact';
			$ret = $andor;
			break;

		case 'AND';
		default:
			$ret = 'AND';
			break;
	}

	$this->_post_andor = $ret;
	return $ret;
}

function get_post_get_query()
{
	$this->_post_query = $this->_post->get_post_get_text('query');
	return $this->_post_query;
}

function get_conf_search_min()
{
	return $this->_conf_search_min;
}

//---------------------------------------------------------
// parse_query
//---------------------------------------------------------
function parse_query()
{
	$keyword = '';
	$ignore  = '';

	$queries_arr = array();
	$ignored_arr = array();

	$andor = $this->_post_andor;
	$query = $this->_post_query;

	if ($andor == 'exact')
	{
		$queries_arr = array( $query );

		$keyword .= ' &quot;';
		$keyword .= $this->_bold( $query );
		$keyword .= '&quot;';
	}
	else 
	{
		$query_han = $this->_strings->convert_space_zen_to_han($query);
		$temp_queries = preg_split('/[\s,]+/', $query_han);

		foreach ($temp_queries as $q) 
		{
			$q = trim($q);

			if ( strlen($q) >= $this->_conf_search_min ) 
			{
				$queries_arr[] = $q;
			} 
			else 
			{
				$ignored_arr[] = $q;
			}
		}

		foreach ($queries_arr as $q) 
		{
			$keyword .= $this->_bold($q);
		}

		if (!empty($ignored_arr)) 
		{
			foreach ($ignored_arr as $q) 
			{
				$ignore .= $this->_bold($q);
			}
		}
	}

	$ret = false;
	if (count($queries_arr) > 0)
	{
		$ret = true;
	}

	$this->_queries_arr = $queries_arr;
	$this->_ignored_arr = $ignored_arr;
	$this->_andor       = $andor;

	return array($ret, $keyword, $ignore);
}

function _bold($str)
{
	$text  = ' <span class="weblinks_bold">';
	$text .= htmlspecialchars( $str );
	$text .= '</span>';
	return $text;
}

//---------------------------------------------------------
// link handler
//---------------------------------------------------------
function get_link_total()
{
	list ($sql_total, $sql_links) = $this->_link_view_handler->build_sql_search($this->_queries_arr, $this->_andor);
	$total = $this->_link_view_handler->getCountBySql($sql_total);

	$this->_sql_links = $sql_links;
	$this->_total     = $total;

	return $total;
}

function get_link_list()
{
	$navi = '';

	$this->_pagenavi->setPerpage( $this->_conf_search_links );
	$this->_pagenavi->setTotal(   $this->_total );

	$this->_pagenavi->getGetPage();
	$start = $this->_pagenavi->calcStart();

// BUG: not show catpath in search
	$this->_link_view_handler->init();

	$link_list = $this->_link_view_handler->get_link_list_by_sql($this->_sql_links, $this->_conf_search_links, $start);

// next page
	if ($this->_total > $this->_conf_search_links)
	{
		$script = $this->_build_script();
		$navi   = $this->_pagenavi->build($script);
	}

	return array($link_list, $navi);
}

function _build_script()
{
	$script  = WEBLINKS_URL.'/search.php?query=';
	$script .= urlencode( stripslashes( implode( ' ', $this->_queries_arr )));
	$script .= '&amp;action=results&amp;andor=';
	$script .= $this->_andor;
	return $script;
}

// --- class end ---
}

?>