<?php
// $Id: viewmark.php,v 1.8 2006/07/30 11:44:21 ohwada Exp $

// 2006-07-30 K.OHWADA
// BUG 4168: not show catpath in viewmark

// 2006-05-15 K.OHWADA
// add weblinks_viewmark_main()
// use new handler

// 2006-03-15 K.OHWADA
// use weblinks_pagenavi::getInstance()

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//================================================================
// WebLinks Module
// view link by mark ( mutual site, recommend site )
// 2004-10-20 K.OHWADA
//================================================================

include "header.php";

include_once WEBLINKS_ROOT_PATH."/class/weblinks_pagenavi.php";
include_once WEBLINKS_ROOT_PATH."/class/weblinks_pagenavi_menu.php";

$weblinks_view_handler =& weblinks_get_handler( 'link_view',  WEBLINKS_DIRNAME );
$weblinks_template =& weblinks_template::getInstance( WEBLINKS_DIRNAME );

// BUG: not show catpath in viewmark
$weblinks_view_handler->init();

$xoopsOption['template_main'] = WEBLINKS_DIRNAME."_viewmark.html";

include XOOPS_ROOT_PATH."/header.php";
$weblinks_template->assignIndex();
$header = $weblinks_template->fetch_header();
$xoopsTpl->assign('weblinks_header', $header);

$mark = $weblinks_view_handler->get_get_mark();

if ($mark == 'rss')
{
	$title = _WLS_SITE_RSS;
}
elseif ($mark == 'mutual')
{
	$title = _WLS_SITE_MUTUAL;
}
else
{
	$mark = 'recommend';
	$title = _WLS_SITE_RECOMMEND;
}

$xoopsTpl->assign('lang_mark_title', $title);
$xoopsTpl->assign('mark',            $mark);

// --- link list ---
$total = $weblinks_view_handler->get_count_by_mark($mark);
$xoopsTpl->assign('mark_total', $total);

if ($total > 0)
{
	weblinks_viewmark_main($total, $mark);
}

include XOOPS_ROOT_PATH.'/footer.php';
exit();
// --- main end ---


//---------------------------------------------------------
// function
//---------------------------------------------------------
function weblinks_viewmark_main($total, $mark)
{
	global $xoopsTpl;

	$link_view_handler =& weblinks_get_handler( 'link_view',      WEBLINKS_DIRNAME );
	$template =& weblinks_template::getInstance( WEBLINKS_DIRNAME );
	$pagenavi =& weblinks_pagenavi_menu::getInstance();

	$conf = $link_view_handler->get_config();
	$conf_perpage = $conf['perpage'];
	$conf_orderby = $conf['orderby'];

	$pagenavi->setPerpage( $conf_perpage );
	$pagenavi->set_sortid_default( $conf_orderby );
	$pagenavi->setTotal($total);

	$pagenavi->getGetPage();
	$pagenavi->getGetSortid();
	$start = $pagenavi->calcStart();
	$sort  = $pagenavi->get_sort();

	$xoopsTpl->assign('show_links', true);
	$template->assignDisplayLink();

// link list
	$links =& $link_view_handler->get_link_by_mark_sort($mark, $sort, $conf_perpage, $start);
	$links_full = $template->fetch_links_full( $links );
	$xoopsTpl->assign('weblinks_links_full', $links_full);

	$script = WEBLINKS_URL.'/viewmark.php?mark='.$mark;
	$pagenavi->assign_navi($xoopsTpl, $script);

}

?>