<?php
// $Id: admin_config_class.php,v 1.9 2006/09/29 12:48:54 ohwada Exp $

// 2006-09-20 K.OHWADA
// use XoopsGTicket
// add check_version_config_040()
// add main_search_title_html
// use build_lib_box_button_style()
// show blog

// 2006-07-10 K.OHWADA
// use happy_linux_config_form happy_linux_config_store_handler etc
// change make_xxx to build_xxx
// add check_version() for v0.30

// 2006-06-04 K.OHWADA
// change to contant RSSC_DIRNAME

// 2006-04-17 K.OHWADA
// suppress notice : Only variable references should be returned by reference

//=========================================================
// RSS Center Module
// this file contain 2 class
//   admin_config_form 
//   admin_config_store
// 2006-01-01 K.OHWADA
//=========================================================

class admin_config_form extends happy_linux_config_form
{

// local
	var $_line_count = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_config_form()
{
	$this->happy_linux_config_form();

	$define =& rssc_config_define::getInstance();
	$this->set_config_handler('config', RSSC_DIRNAME, 'rssc');
	$this->set_config_define( $define );

// init
	$this->load();

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_config_form();
	}

	return $instance;
}

//=========================================================
// main function
//=========================================================
function init_form()
{
	// dummy
}

function show_main()
{
	$this->print_top3('rssc_config_main', _RSSC_SEARCH, _RSSC_HEADLINE, _RSSC_SINGLE);

	$this->print_three( 'main_search_min');
	$this->print_three( '',                         'main_headline_links_perpage');
	$this->print_three( 'main_search_perpage',      'main_headline_feeds_perpage');
	$this->print_yesno3('main_search_title_html',   'main_headline_title_html',    'main_single_title_html');
	$this->print_yesno3('main_search_content_html', 'main_headline_content_html',  'main_single_content_html');
	$this->print_three( 'main_search_max_title',    'main_headline_max_title',     'main_single_max_title');
	$this->print_three( 'main_search_max_content',  'main_headline_max_content',   'main_single_max_content');
	$this->print_three( 'main_search_max_summary',  'main_headline_max_summary',   'main_single_max_summary');
	$this->print_sel3 ( 'main_search_order',        'main_headline_order');

	$this->print_form_bottom();
}

function show_block()
{
	$this->print_top3('rssc_config_block', _MI_RSSC_BNAME_LATEST, _MI_RSSC_BNAME_BLOG, _MI_RSSC_BNAME_HEADLINE);

	$this->print_three('',                         'block_blog_lid',         '');
	$this->print_three('',                         '',                       'block_headline_links_perpage');
	$this->print_three('block_latest_perpage',     'block_blog_perpage',     'block_headline_feeds_perlink');
	$this->print_three('block_latest_max_title',   'block_blog_max_title',   'block_headline_max_title');
	$this->print_three('block_latest_max_summary', 'block_blog_max_summary', 'block_headline_max_summary');
	$this->print_three('block_latest_max_content', 'block_blog_max_content', 'block_headline_max_content');
	$this->print_three('block_latest_num_content', 'block_blog_num_content', 'block_headline_num_content');
	$this->print_sel3 ('block_latest_order',       'block_blog_order',       'block_headline_order');

	$this->print_form_bottom();
}

//---------------------------------------------------------
// print html
//---------------------------------------------------------
function print_top2($form_name, $name1, $name2)
{
	echo $this->build_form_begin($form_name);
	echo $this->build_token();
	echo $this->build_html_input_hidden('op', 'save');

	echo "<table class='outer' width='100%' ><tr>";
	echo "<th align='center'>"._AM_RSSC_CONF_NAME."</th>";
	echo "<th align='center'>".$name1."</th>";
	echo "<th align='center'>".$name2."</th>";
	echo "</tr>\n";
}

function print_top3($form_name, $name1, $name2, $name3)
{
	echo $this->build_form_begin($form_name);
	echo $this->build_token();
	echo $this->build_html_input_hidden('op', 'save');

	echo "<table class='outer' width='100%' ><tr>";
	echo "<th align='center'>"._AM_RSSC_CONF_NAME."</th>";
	echo "<th align='center'>".$name1."</th>";
	echo "<th align='center'>".$name2."</th>";
	echo "<th align='center'>".$name3."</th>";
	echo "</tr>\n";
}

function print_form_even_odd()
{
	if ($this->_line_count % 2 == 0) 
	{
		$class = 'even';
	}
	else 
	{
		$class = 'odd';
	}

	$this->_line_count ++;

	echo "<tr class='$class'>";
}

function print_two($name1, $name2='')
{
	if ( $name1 )
	{
		$title_show = $this->build_conf_caption_by_name($name1);
	}
	else
	{
		$title_show = $this->build_conf_caption_by_name($name2);
	}

	$name1_show = $this->build_conf_textbox_by_name($name1);
	$name2_show = $this->build_conf_textbox_by_name($name2);

	$this->print_form_even_odd();
	echo "<td>$title_show</td>";
	echo "<td align='right'>$name1_show</td>";
	echo "<td align='right'>$name2_show</td></tr>\n";

}

function print_three($name1, $name2='', $name3='')
{
	if ( $name1 )
	{
		$title_show = $this->build_conf_caption_by_name($name1);
	}
	elseif ( $name2 )
	{
		$title_show = $this->build_conf_caption_by_name($name2);
	}
	else
	{
		$title_show = $this->build_conf_caption_by_name($name3);
	}

	$name1_show = $this->build_conf_textbox_by_name($name1);
	$name2_show = $this->build_conf_textbox_by_name($name2);
	$name3_show = $this->build_conf_textbox_by_name($name3);

	$this->print_form_even_odd();
	echo "<td>$title_show</td>";
	echo "<td align='right'>$name1_show</td>";
	echo "<td align='right'>$name2_show</td>";
	echo "<td align='right'>$name3_show</td></tr>\n";

}

function print_sel2($name1, $name2='')
{
	$title_show = $this->build_conf_caption_by_name($name1);
	$name1_show = $this->build_conf_radio_select_by_name($name1);
	$name2_show = $this->build_conf_radio_select_by_name($name2);

	$this->print_form_even_odd();
	echo "<td>$title_show</td>";
	echo "<td align='left'>$name1_show</td>";
	echo "<td align='left'>$name2_show</td></tr>\n";

}

function print_sel3($name1, $name2='', $name3='')
{
	$title_show = $this->build_conf_caption_by_name($name1);
	$name1_show = $this->build_conf_radio_select_by_name($name1);
	$name2_show = $this->build_conf_radio_select_by_name($name2);
	$name3_show = $this->build_conf_radio_select_by_name($name3);

	$this->print_form_even_odd();
	echo "<td>$title_show</td>";
	echo "<td align='left'>$name1_show</td>";
	echo "<td align='left'>$name2_show</td>";
	echo "<td align='left'>$name3_show</td></tr>\n";

}

function print_yesno3($name1, $name2='', $name3='')
{
	$title_show = $this->build_conf_caption_by_name($name1);
	$name1_show = $this->build_conf_radio_yesno_by_name($name1);
	$name2_show = $this->build_conf_radio_yesno_by_name($name2);
	$name3_show = $this->build_conf_radio_yesno_by_name($name3);

	$this->print_form_even_odd();
	echo "<td>$title_show</td>";
	echo "<td align='left'>$name1_show</td>";
	echo "<td align='left'>$name2_show</td>";
	echo "<td align='left'>$name3_show</td></tr>\n";

}

function print_form_conf_checkbox($name)
{
	$this->print_form_even_odd();

	$name_show = $this->build_conf_yseno_checkbox_by_name($name);
	$this->print_conf_line($name, $name_show);
}

function print_form_conf_radio($name)
{
	$this->print_form_even_odd();

	$title_show = $this->build_conf_caption_by_name($name);
	$name_show  = $this->build_conf_radio_select_by_name($name);

	echo "<td></td><td>$title_show</td><td></td><td></td>";
	echo "<td align='left' colspan='2'>$name_show</td>";
	echo "<td></td></tr>\n";
}

function print_conf_line($name, $name1_show, $name2_show='')
{
	$title_show = $this->build_conf_caption_by_name($name);

	echo "<td></td><td>$title_show</td><td></td><td></td>";
	echo "<td align='right'>$name1_show</td><td></td>";
	echo "<td align='right'>$name2_show</td></tr>\n";
}

function print_form_bottom()
{
	echo "<tr class='foot' ><td></td><td colspan='3'>";
	echo $this->build_html_input_submit( 'submit', _SAVE );
	echo "</tr></table>\n";
	echo $this->build_form_end();
	echo "<br />\n";
}

function print_msg($title)
{
	echo "<h4>$title</h4>\n";
}

function print_error($title, $msg)
{
	echo "<h3><font color='red'>$title</font></h3>\n";
	echo "$msg<br /><br />\n";
}

//---------------------------------------------------------
// print form init
//---------------------------------------------------------
function print_form_init()
{
	echo "<br />\n";
	echo $this->build_lib_box_button_style( _AM_RSSC_INIT_EXEC, '', 'init', _SAVE );
	echo "<br />\n";
}

//---------------------------------------------------------
// print form upgrade
//---------------------------------------------------------
function print_form_upgrade()
{
	echo "<br />\n";
	echo $this->build_lib_box_button_style( _AM_RSSC_UPGRADE_EXEC, '', 'upgrade', _SAVE );
	echo "<br />\n";
}

// --- class end ---
}

//================================================================
// class admin_config
//================================================================
class admin_config_store extends happy_linux_error
{

// handler
	var $_store_handler;
	var $_feed_handler;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_config_store()
{
	$this->happy_linux_error();

// config_store_handler
	$define =& rssc_config_define::getInstance();
	$this->_store_handler =& happy_linux_config_store_handler::getInstance();
	$this->_store_handler->set_handler('config', RSSC_DIRNAME, 'rssc');
	$this->_store_handler->set_define( $define );

// feed handler
	$this->_feed_handler =& rssc_get_handler('feed', RSSC_DIRNAME);

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_config_store();
	}

	return $instance;
}

//---------------------------------------------------------
// init config
//---------------------------------------------------------
function check_init()
{
	if ( !$this->_check_version_config_040() )
	{	return false;	}

	if ( !$this->_check_init_config() )
	{	return false;	}

	return true;
}

function init()
{
	$this->_clear_errors();

	if ( !$this->_check_version_config_040() )
	{
		$ret = $this->_store_handler->_handler->add_column_table_040();
		if ( !$ret )
		{
			$this->_set_errors( $this->_store_handler->_handler->getErrors() );
		}
	}

	if ( !$this->_check_init_config() )
	{
		$ret = $this->_store_handler->init();
		if ( !$ret )
		{
			$this->_set_errors( $this->_store_handler->getErrors() );
		}
	}

	return $this->returnExistError();
}

//---------------------------------------------------------
// upgrade config
//---------------------------------------------------------
function check_version()
{
	if ( !$this->_check_version_config() )
	{	return false;	}

	if ( !$this->_check_version_feed_030() )
	{	return false;	}

	return true;
}

function upgrade()
{
	$this->_clear_errors();

	if ( !$this->_check_version_config() )
	{
		$ret = $this->_store_handler->upgrade();
		if ( !$ret )
		{
			$this->_set_errors( $this->_store_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_feed_030() )
	{
		$ret = $this->_feed_handler->add_column_table_030();
		if ( !$ret )
		{
			$this->_set_errors( $this->_feed_handler->getErrors() );
		}
	}

	return $this->returnExistError();
}

//---------------------------------------------------------
// save config
//---------------------------------------------------------
function save()
{
	$ret = $this->_store_handler->save();
	if ( !$ret )
	{
		$this->_set_errors( $this->_store_handler->getErrors() );
	}
	return $ret;
}

//---------------------------------------------------------
// check config
//---------------------------------------------------------
function _check_init_config()
{
	$num = $this->_store_handler->getCount();
	if ( $num == 0 )
	{	return false;	}

	return true;
}

function _check_version_config()
{
	$this->_store_handler->load();

	if ( !$this->_store_handler->check_exist_by_name( 'basic_rss_atom' ) )
	{	return false;	}

	if ( !$this->_store_handler->check_exist_by_name( 'index_desc' ) )
	{	return false;	}

// v0.40
	if ( !$this->_store_handler->check_exist_by_name( 'block_blog_lid' ) )
	{	return false;	}

	return true;
}

function _check_version_feed_030()
{
	$ret = $this->_feed_handler->check_version_030();
	return $ret;
}

function _check_version_config_040()
{
	$ret = $this->_store_handler->_handler->check_version_040();
	return $ret;
}

// --- class end ---
}

?>