<?php
// $Id: parse_rss.php,v 1.3 2006/07/15 13:37:47 ohwada Exp $

// 2006-07-10 K.OHWADA
// move class admin_form_rss from admin_form_class.php
// use happy_linux_error happy_linux_form
// change make_xxx to build_xxx
// support podcast

// 2006-06-04 K.OHWADA
// change file name from view_rss.php to parse_rss.php
// change to contant RSSC_DIRNAME
// use new handler

//=========================================================
// RSS Center Module
// 2006-01-01 K.OHWADA
//=========================================================

include 'admin_header.php';
include_once XOOPS_ROOT_PATH.'/class/template.php';

include_once RSSC_ROOT_PATH.'/class/magpie/rssc_magpie_parse.php';
include_once RSSC_ROOT_PATH.'/class/magpie/rssc_magpie_cache.php';
include_once RSSC_ROOT_PATH."/class/rssc_link_basic_handler.php";
include_once RSSC_ROOT_PATH."/class/rssc_feed_basic_handler.php";
include_once RSSC_ROOT_PATH."/class/rssc_black_basic_handler.php";
include_once RSSC_ROOT_PATH."/class/rssc_white_basic_handler.php";
include_once RSSC_ROOT_PATH."/class/rssc_parse_handler.php";
include_once RSSC_ROOT_PATH."/class/rssc_refresh_handler.php";

//=========================================================
// class admin_parse_rss
//=========================================================
class admin_parse_rss extends happy_linux_error
{
// handler
	var $_config_handler;
	var $_refresh_handler;
	var $_view_handler;
	var $_parse_handler;

	var $_post;

	var $TEMPLATE_RDF;
	var $TEMPLATE_RSS;
	var $TEMPLATE_ATOM;

	var $_template;
	var $_result;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_parse_rss()
{
	$this->happy_linux_error();

	$this->_conf_handler    =& rssc_get_handler('config_basic', RSSC_DIRNAME);
	$this->_refresh_handler =& rssc_get_handler('refresh', RSSC_DIRNAME);
	$this->_view_handler    =& rssc_get_handler('view',    RSSC_DIRNAME);
	$this->_parse_handler   =& rssc_parse_handler::getInstance();

	$this->TEMPLATE_RDF  = RSSC_ROOT_PATH.'/templates/xml/rssc_view_rdf.html';
	$this->TEMPLATE_RSS  = RSSC_ROOT_PATH.'/templates/xml/rssc_view_rss.html';
	$this->TEMPLATE_ATOM = RSSC_ROOT_PATH.'/templates/xml/rssc_view_atom.html';

	$this->_post =& happy_linux_post::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_parse_rss();
	}

	return $instance;
}

//---------------------------------------------------------
// get link
//---------------------------------------------------------
function exists_link($lid)
{
	$link_obj =& $this->get($lid);
	if ( is_object($link_obj) )
	{
		return true;
	}
	return false;
}

function &get($lid)
{
	$ret =& $this->_view_handler->get($lid);
	if ( !$ret )
	{
		$this->_set_errors( $this->_view_handler->getErrors() );
	}
	return $ret;
}

//---------------------------------------------------------
// get param
//---------------------------------------------------------
function get_param($lid='')
{
	$conf_data =& $this->_conf_handler->get_conf();

	$title    = '';
	$rdf_url  = '';
	$rss_url  = '';
	$atom_url = '';
	$rss_mode = '';

	if ($lid)
	{
		$link_obj =& $this->get($lid);
		if ( !is_object($link_obj) )
		{
			return false;
		}

		$title    = $link_obj->getVar('title',    's');
		$rdf_url  = $link_obj->getVar('rdf_url',  's');
		$rss_url  = $link_obj->getVar('rss_url',  's');
		$atom_url = $link_obj->getVar('atom_url', 's');
		$rss_mode = $link_obj->getVar('mode',     's');
	}

	$data = array(
		'lid'      => $lid,
		'title'    => $title,
		'rdf_url'  => $rdf_url,
		'rss_url'  => $rss_url,
		'atom_url' => $atom_url,
		'rss_mode' => $rss_mode,
		'rss_atom'      => $conf_data['basic_rss_atom'],
//		'parser_rss'    => $conf_data['basic_parser_rss'],
		'xml_save'      => $conf_data['basic_xml_save'],
		'mode_view'     => 0,
		'feed_perpage'  => 10,
		'sanitize'      => 1,
		'title_html'    => 1,
		'content_html'  => 1,
		'max_title'     => -1,
		'max_content'   => -1,
		'max_summary'   => -1,
		'link_update'   => 1,
		'feed_update'   => 1,
		'force_discover'  => 0,
		'force_update'    => 0,
		'force_overwrite' => 0,
		'print_log'   => 0,
		'print_error' => 1,
	);

	return $data;
}

function get_result($lid, $param)
{
	$link_obj =& $this->get($lid);
	if ( !is_object($link_obj) )
	{
		return false;
	}

	$link_encoding = $link_obj->getVar('encoding');
	$link_xml      = $link_obj->getVar('xml');

	$mode     = $param['mode_view'];
	$rss_mode = $param['rss_mode'];

	$xml_url  = $link_obj->get_rssurl_select_by_mode( $rss_mode );
	$this->_template = $this->get_template( $rss_mode );

	$this->_refresh_handler->set_debug_parse( 1, $xml_url, $link_encoding, $rss_mode );
//	$this->_refresh_handler->setRssParser(          $param['parser_rss'] );
	$this->_refresh_handler->set_link_update(       $param['link_update'] );
	$this->_refresh_handler->set_feed_update(       $param['feed_update'] );
	$this->_refresh_handler->set_link_xml_save(     $param['xml_save'] );
	$this->_refresh_handler->set_force_discover(    $param['force_discover'] );
	$this->_refresh_handler->set_force_refresh(     $param['force_update'] );
	$this->_refresh_handler->set_force_overwrite(   $param['force_overwrite'] );
	$this->_refresh_handler->set_debug_print_log(   $param['print_log'] );
	$this->_refresh_handler->set_debug_print_error( $param['print_error'] );

	$this->_view_handler->setFlagSanitize(  $param['sanitize'] );
	$this->_view_handler->setFeedStart( 0 );
	$this->_view_handler->setFeedLimit(     $param['feed_perpage'] );
	$this->_view_handler->set_title_html(   $param['title_html'] );
	$this->_view_handler->set_content_html( $param['content_html'] );
	$this->_view_handler->set_max_title(    $param['max_title'] );
	$this->_view_handler->set_max_content(  $param['max_content'] );
	$this->_view_handler->set_max_summary(  $param['max_summary'] );

	if ($mode == 1)
	{
		$result =& $this->get_sanitized_parse_by_lid($lid);
	}
	elseif ($mode == 2)
	{
		if ( !$this->_refresh_handler->refresh($lid) )
		{
			$this->_set_errors( $this->_refresh_handler->getErrors() );
		}

		$result =& $this->_view_handler->get_sanitized_store_by_lid($lid);
	}
	else
	{
		$this->_refresh_handler->set_link_update(   0 );
		$this->_refresh_handler->set_feed_update(   0 );
		$this->_refresh_handler->set_force_refresh( 1 );

		if ( !$this->_refresh_handler->refresh($lid) )
		{
			$this->_set_errors( $this->_refresh_handler->getErrors() );
		}

		$data =& $this->_refresh_handler->getData();
		$result =& $this->_view_handler->view_format_sanitize( $data );
	}

	if ( $this->_error_flag )
	{
		echo "<font color='red'>";
		echo "error <br />\n";
		echo $this->getErrors(1);
		echo "</font>";
	}

	$this->_result = $result;
}

function &get_sanitized_parse_by_lid($lid)
{
	$link_obj =& $this->get($lid);
	if ( !is_object($link_obj) )
	{
		return false;
	}

	$xml      = $link_obj->getVar('xml', 'n');
	$encoding = $link_obj->getVar('encoding', 'n');

	$parse_obj =& $this->_parse_handler->parse_by_xml($xml, $encoding);
	if ( !is_object($parse_obj) )
	{
		$this->_set_errors( $this->_parse_handler->getErrors() );
		return false;
	}

	$data1 =& $parse_obj->get_vars();

// sanitize
	$data2 =& $this->_view_handler->view_sanitize( $data1 );
	return $data2;
}

function get_template($mode)
{
	switch ($mode)
	{
		case RSSC_C_MODE_RDF:
			$template = $this->TEMPLATE_RDF;
			break;

		case RSSC_C_MODE_ATOM:
			$template = $this->TEMPLATE_ATOM;
			break;

		case RSSC_C_MODE_RSS:
		default:
			$template = $this->TEMPLATE_RSS;
			break;
	}

	return $template;
}

function display_tpl()
{
	$template = $this->_template;
	$result   = $this->_result;

	$tpl = new XoopsTpl();
	$tpl->clear_compiled_tpl( $template );
	$tpl->clear_cache( $template );
	$tpl->assign('xoops_url', XOOPS_URL);
	$tpl->assign_by_ref('channel',   $result['channel'] );
	$tpl->assign_by_ref('image',     $result['image'] );
	$tpl->assign_by_ref('textinput', $result['textinput'] );

	foreach ($result['items'] as $item) 
	{
		$tpl->append('items', $item);
	}

	$tpl->assign( array(
		'lang_site_desc'        => _RSSC_SITE_DESCRIPTION,
		'lang_site_updated'     => _RSSC_SITE_UPDATED,
		'lang_site_date'        => _RSSC_SITE_DATE, 
		'lang_site_webmaster'   => _RSSC_SITE_WEBMASTER, 
		'lang_site_language'    => _RSSC_SITE_LANGUAGE, 
		'lang_site_generator'   => _RSSC_SITE_GENERATOR, 
		'lang_site_category'    => _RSSC_SITE_CATEGORY, 
		'lang_site_description' => _RSSC_SITE_DESCRIPTION, 
		'lang_site_docs'        => _RSSC_RSS_SITE_DOCS, 
		'lang_site_copyright'   => _RSSC_RSS_SITE_COPYRIGHT, 
		'lang_site_cloud'       => _RSSC_RSS_SITE_CLOUD, 
		'lang_site_ttl'         => _RSSC_RSS_SITE_TTL, 
		'lang_site_rating'      => _RSSC_RSS_SITE_RATING, 
		'lang_site_textinput'   => _RSSC_RSS_SITE_TEXTINPUT, 
		'lang_site_skiphours'   => _RSSC_RSS_SITE_SKIPHOURS, 
		'lang_site_skipdays'    => _RSSC_RSS_SITE_SKIPDAYS, 
		'lang_site_rights'      => _RSSC_ATOM_SITE_RIGHTS, 
		'lang_site_source'      => _RSSC_ATOM_SITE_SOURCE,
		'lang_site_subtitle'    => _RSSC_ATOM_SITE_SUBTITLE,
		'lang_site_id'          => _RSSC_ATOM_SITE_ID,
		'lang_site_icon'        => _RSSC_ATOM_SITE_ICON,
		'lang_site_logo'        => _RSSC_ATOM_SITE_LOGO,
		'lang_site_lastbuilddate'  => _RSSC_RSS_SITE_LASTBUILDDATE, 
		'lang_site_pubdate'        => _RSSC_RSS_SITE_PUBDATE, 
		'lang_site_managingeditor' => _RSSC_RSS_SITE_MANAGINGEDITOR, 
		'lang_site_link_self'      => _RSSC_ATOM_SITE_LINK_SELF, 
		'lang_site_author_name'       => _RSSC_ATOM_SITE_AUTHOR_NAME, 
		'lang_site_author_email'      => _RSSC_ATOM_SITE_AUTHOR_EMAIL, 
		'lang_site_author_uri'        => _RSSC_ATOM_SITE_AUTHOR_URI, 
		'lang_site_contributor_name'  => _RSSC_ATOM_CONTRIBUTOR_NAME, 
		'lang_site_contributor_email' => _RSSC_ATOM_CONTRIBUTOR_EMAIL, 
		'lang_site_contributor_uri'   => _RSSC_ATOM_CONTRIBUTOR_URI, 
		'lang_site_creator' => _RSSC_DC_CREATOR, 
		'lang_title'     => _RSSC_TITLE, 
		'lang_published' => _RSSC_PUBLISHED, 
		'lang_updated'   => _RSSC_UPDATED, 
		'lang_created'   => _RSSC_CREATED, 
		'lang_summary'   => _RSSC_SUMMARY, 
		'lang_category'  => _RSSC_CATEGORY, 
		'lang_rights'    => _RSSC_RIGHTS, 
		'lang_source'    => _RSSC_SOURCE,
		'lang_guid'      => _RSSC_RSS_GUID,
		'lang_pubdate'   => _RSSC_RSS_PUBDATE,
		'lang_author'    => _RSSC_RSS_AUTHOR,
		'lang_comments'  => _RSSC_RSS_COMMENTS,
		'lang_enclosure' => _RSSC_RSS_ENCLOSURE,

// enclosure
		'lang_enclosure_url'    => _RSSC_ENCLOSURE_URL,
		'lang_enclosure_type'   => _RSSC_ENCLOSURE_TYPE,
		'lang_enclosure_length' => _RSSC_ENCLOSURE_LENGTH,

		'lang_entry_id'  => _RSSC_ATOM_ID,
		'lang_description'  => _RSSC_DESCRIPTION, 
		'lang_author_name'       => _RSSC_AUTHOR_NAME, 
		'lang_author_email'      => _RSSC_AUTHOR_EMAIL, 
		'lang_author_uri'        => _RSSC_AUTHOR_URI, 
		'lang_contributor_name'  => _RSSC_ATOM_CONTRIBUTOR_NAME, 
		'lang_contributor_email' => _RSSC_ATOM_CONTRIBUTOR_EMAIL, 
		'lang_contributor_uri'   => _RSSC_ATOM_CONTRIBUTOR_URI, 
		'lang_subject'    => _RSSC_DC_SUBJECT,
		'lang_publisher'  => _RSSC_DC_PUBLISHER,
		'lang_creator'    => _RSSC_DC_CREATOR,
		'lang_date'       => _RSSC_DC_DATE,
		'lang_format'     => _RSSC_DC_FORMAT,
		'lang_relation'   => _RSSC_DC_RELATION,
		'lang_identifier' => _RSSC_DC_IDENTIFIER,
		'lang_coverage'   => _RSSC_DC_COVERAGE,
		'lang_audience'   => _RSSC_DC_AUDIENCE,
		'lang_encoded'    => _RSSC_CONTENT_ENCODED,
		'lang_more'       => _MORE
		)
	);

	$tpl->display( $template );

}

//---------------------------------------------------------
// class post
//---------------------------------------------------------
function get_post_op()
{
	return $this->_post->get_post('op');
}

function get_post_get_lid()
{
	return $this->_post->get_post_get_int('lid');
}

// --- class end ---
}

//=========================================================
// class admin_form_rss
//=========================================================
class admin_form_rss extends happy_linux_form
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_form_rss()
{
	$this->happy_linux_form();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_form_rss();
	}

	return $instance;
}

//---------------------------------------------------------
// show form
//---------------------------------------------------------
function show_rss($data)
{
	$this->set_datas($data);

// form start
	echo $this->build_form_begin('rss');
	echo $this->build_xoops_token();
	echo $this->build_html_input_hidden('op', 'param');
	echo $this->build_form_table_begin();
	echo $this->build_form_table_title(_AM_RSSC_VIEW_RSS);

	echo $this->build_data_table_text( _RSSC_LINK_ID, 'lid');
	echo $this->build_data_table_label_hidden( _RSSC_SITE_TITLE, 'title' );
	$this->_print_sel_mode();
	$this->_print_text('feed_perpage');
	$this->_print_yesno('sanitize');
	$this->_print_yesno('title_html');
	$this->_print_yesno('content_html');
	$this->_print_text('max_title');
	$this->_print_text('max_content');
	$this->_print_text('max_summary');

	echo $this->build_form_table_title( _AM_RSSC_VIEW_PARSER );
	echo $this->build_data_table_label_hidden( _RSSC_RDF_URL,  'rdf_url' );
	echo $this->build_data_table_label_hidden( _RSSC_RSS_URL,  'rss_url' );
	echo $this->build_data_table_label_hidden( _RSSC_ATOM_URL, 'atom_url' );
	$this->_print_sel_rss_mode();
//	$this->_print_sel_parser_rss();
//	$this->_print_sel_parser_atom();
	$this->_print_yesno('force_discover');

	echo $this->build_form_table_title( _AM_RSSC_VIEW_SAVE_ETC );
	$this->_print_yesno('link_update');
	$this->_print_yesno('xml_save');
	$this->_print_yesno('feed_update');
	$this->_print_yesno('force_update');
	$this->_print_yesno('force_overwrite');
	$this->_print_yesno('print_log');
	$this->_print_yesno('print_error');

	$ele_submit = $this->build_html_input_submit('submit', _EXECUTE);
	echo $this->build_form_table_line('', $ele_submit, 'foot', 'foot');

	echo $this->build_form_table_end();
	echo $this->build_form_end();

}

//---------------------------------------------------------
// private
//---------------------------------------------------------
function _print_label_hidden($name)
{
	$cap = $this->_make_admin_caption($name);
	echo $this->build_data_table_label_hidden($cap, $name);
}

function _print_text($name)
{
	$cap = $this->_make_admin_caption($name);
	echo $this->build_data_table_text($cap, $name);
}

function _print_yesno($name)
{
	$cap = $this->_make_admin_caption($name);
	echo $this->build_data_table_radio_yesno($cap, $name);
}

function _print_sel_mode()
{
	$options = array(
		_AM_RSSC_VIEW_MODE_CURRENT => RSSC_C_VIEW_CURRENT,
		_AM_RSSC_VIEW_MODE_LINK    => RSSC_C_VIEW_LINK,
		_AM_RSSC_VIEW_MODE_FEED    => RSSC_C_VIEW_FEED,
		);

	$cap = $this->build_form_caption(_AM_RSSC_VIEW_MODE, _AM_RSSC_VIEW_MODE_DESC);
	$ele = $this->build_html_input_radio_select('mode_view', $this->_datas['mode_view'], $options, '<br />');
	echo $this->build_form_table_line($cap, $ele);
}

function _print_sel_rss_atom()
{
	$options = array(
		_AM_RSSC_CONF_RSS_ATOM_SEL_RSS  => RSSC_C_SEL_RSS,
		_AM_RSSC_CONF_RSS_ATOM_SEL_ATOM => RSSC_C_SEL_ATOM,
		);

	$cap = $this->build_form_caption(_AM_RSSC_CONF_RSS_ATOM, _AM_RSSC_CONF_RSS_ATOM_DESC);
	$ele = $this->build_html_input_radio_select('rss_atom', $this->_datas['rss_atom'], $options, '<br />');
	echo $this->build_form_table_line($cap, $ele);
}

//function _print_sel_parser_rss()
//{
//	$options = array(
//		_AM_RSSC_CONF_RSS_PARSER_XOOPS => RSSC_C_PARSER_RSS_XOOPS,
//		_AM_RSSC_CONF_RSS_PARSER_SELF  => RSSC_C_PARSER_RSS_SELF
//		);
//	$cap = $this->build_form_caption(_AM_RSSC_CONF_RSS_PARSER);
//	$ele = $this->build_html_input_radio_select('parser_rss', $this->_datas['parser_rss'], $options, '<br />');
//	echo $this->build_form_table_line($cap, $ele);
//}

function _print_sel_rss_mode()
{
	$obj =& new rssc_link();
	$mode_opt = $obj->get_mode_option();

	$ele_mode = $this->build_html_input_radio_select('rss_mode', $this->_datas['rss_mode'], $mode_opt );
	echo $this->build_form_table_line(_RSSC_RSS_MODE, $ele_mode);
}

function _make_admin_caption($keyword)
{
	$const_title = '_AM_RSSC_VIEW_' . strtoupper($keyword);
	$const_desc  = $const_title.'_DESC';
	$title = '';
	$desc  = '';

	if ( defined( $const_title ) )
	{
		$title = constant( $const_title );
	}
	else
	{
		$title = $const_title;
	}

	if ( defined( $const_desc ) )
	{
		$desc = constant( $const_desc );
	}

	$ret = $this->build_form_caption($title, $desc);
	return $ret;
}

// --- class end ---
}

//=========================================================
// main
//=========================================================
$form  =& admin_form_rss::getInstance();
$parse =& admin_parse_rss::getInstance();

// === print ===
xoops_cp_header();

$op  = $parse->get_post_op();
$lid = $parse->get_post_get_lid();

rssc_admin_print_header();
rssc_admin_print_menu();

echo "<h3>"._AM_RSSC_PARSE_RSS."</h3>\n";
echo "<a href='#option'>"._AM_RSSC_VIEW_RSS_OPTION."</a><br /><br />\n";

$param = $parse->get_param();

if ( $lid > 0 )
{
	if ( $parse->exists_link($lid) )
	{
		if ($op == 'param')
		{
			$param = $_POST;
		}
		else
		{
			$param = $parse->get_param($lid);
		}

		$parse->get_result($lid, $param);
		$parse->display_tpl();
	}
	else
	{
		echo "<font color='red'>"._NO_RECORD."</font><br />\n";
	}

}
else
{
	echo "<font color='red'>"._AM_RSSC_NOT_SELECT_LINK."</font><br /><br />\n";
	echo _AM_RSSC_PLEASE_SELECT_LINK."<br />\n";
}

echo "<br />\n";
echo "<a name='option'><h4>"._AM_RSSC_VIEW_RSS_OPTION."</h4></a>\n";

$form->show_rss($param);

xoops_cp_footer();
// === print end ===

exit();
// === main end ===


?>