<?php
// $Id: rssc_link_basic_handler.php,v 1.4 2006/09/27 03:02:48 ohwada Exp $

// 2006-09-20 K.OHWADA
// small change

// 2006-07-10 K.OHWADA
// use happy_linux_basic happy_linux_basic_handler

// 2006-06-04 K.OHWADA
// this is new file
// move from link_handler

//=========================================================
// Rss Center Module
// 2006-06-04 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_link_basic_handler') ) 
{

//=========================================================
// class rssc_link_basic
//=========================================================
class rssc_link_basic extends happy_linux_basic
{
	var $_flag_xml_save = true;	// for debug

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_link_basic()
{
	$this->happy_linux_basic();
}

//---------------------------------------------------------
// element
//---------------------------------------------------------
function get_rssurl_by_mode()
{
	$mode = $this->get('mode');

	switch ($mode)
	{
		case RSSC_C_MODE_RDF:
			$val = $this->get('rdf_url');
			break;

		case RSSC_C_MODE_RSS:
			$val = $this->get('rss_url');
			break;

		case RSSC_C_MODE_ATOM:
			$val = $this->get('atom_url');
			break;

		default:
			$val = false;
			break;
	}

	return $val;
}

function refresh_expired()
{
	if ( time() > ( $this->get('refresh') + $this->get('updated_unix') ) )
	{
		return true;
	}

	return false;
}

// --- class end ---
}

//=========================================================
// class rssc_link_basic_handler
// this class is used by command line
// this class handle MySQL table directly
// this class does not use another class
//=========================================================
class rssc_link_basic_handler extends happy_linux_basic_handler
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_link_basic_handler( $dirname )
{
	$this->happy_linux_basic_handler( $dirname );

	$this->set_table_name('link');
	$this->set_id_name('lid');
	$this->set_class_name('rssc_link_basic');

	$this->set_debug_db_sql(   RSSC_DEBUG_LINK_BASIC_SQL );
	$this->set_debug_db_error( RSSC_DEBUG_ERROR );

}

//---------------------------------------------------------
// update
//---------------------------------------------------------
function update_xml_url($lid, $mode, $rdf_url, $rss_url, $atom_url)
{
	$sql  = 'UPDATE '.$this->_table.' SET ';
	$sql .= 'mode='. intval($mode).', ';
	$sql .= 'rdf_url='.  $this->quote($rdf_url).', ';
	$sql .= 'rss_url='.  $this->quote($rss_url).', ';
	$sql .= 'atom_url='. $this->quote($atom_url).' ';
	$sql .= 'WHERE lid='.intval($lid);

	$ret = $this->query($sql);
	return $ret;
}

function update_encoding($lid, $encoding)
{
	$sql  = 'UPDATE '.$this->_table.' SET ';
	$sql .= 'encoding='. $this->quote($encoding).' ';
	$sql .= 'WHERE lid='.intval($lid);

	$ret = $this->query($sql);
	return $ret;
}

function update_xml($lid, $channel, $xml, $updated_unix='' )
{
// refresh channel to link table
	if ( empty($updated_unix) )
	{
		$updated_unix = $time();
	}

	$sql  = 'UPDATE '.$this->_table.' SET ';

// refresh XML cache
	if ( $this->_flag_xml_save )
	{
		$sql .= 'xml='. $this->quote($xml).', ';
	}

	$sql .= 'updated_unix='. intval($updated_unix).', ';
	$sql .= 'channel='. $this->quote( serialize($channel) ).' ';
	$sql .= ' WHERE lid='.intval($lid);

	$ret = $this->query($sql);
	return $ret;
}

//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function set_xml_save($value)
{
	$this->_flag_xml_save = intval($value);
}

// --- class end ---
}

// === class end ===
}

?>