<?php 
// $Id: block_search.php,v 1.2 2006/12/01 15:05:57 ohwada Exp $ 

//=========================================================
// Happy Search
// 2006-11-11 K.OHWADA
//=========================================================

//---------------------------------------------------------
// TODO
// set contstant in admin
//---------------------------------------------------------

function b_happy_search_form()
{
	global $xoopsConfig;
	$XOOPS_LANGUAGE = $xoopsConfig['language'];

// search.php
	if ( file_exists(XOOPS_ROOT_PATH.'/language/'.$XOOPS_LANGUAGE.'/search.php') ) 
	{
		include_once XOOPS_ROOT_PATH.'/language/'.$XOOPS_LANGUAGE.'/search.php';
	}
	else
	{
		include_once XOOPS_ROOT_PATH.'/language/english/search.php';
	}

	$block = array(
		'lang_search'         => _SR_SEARCH,
		'lang_search_results' => _SR_SEARCHRESULTS,
		'lang_keyword'        => _SR_KEYWORDS,
	);

	return $block;
}

function b_happy_search_redirect()
{
	$HAPPY_SEARCH_DIRNAME = basename( dirname( dirname( __FILE__ ) ) );

	$request_url = 'http://'. $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
	if( preg_match("|".XOOPS_URL."/search.php|", $request_url ) )
	{
		$redirect_url = XOOPS_URL .'/modules/'. $HAPPY_SEARCH_DIRNAME .'/index.php?'. $_SERVER['QUERY_STRING'];
		header( 'Location: '. $redirect_url );
		exit();
	}
	return false;
}

function b_happy_search_result()
{
	$HAPPY_SEARCH_DIRNAME = basename( dirname( dirname( __FILE__ ) ) );
	$HAPPY_SEARCH_ROOT_PATH = XOOPS_ROOT_PATH. '/modules/'. $HAPPY_SEARCH_DIRNAME;

	$SEARCH_DIRNAME = 'search';

	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/include/functions.php';
	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/include/multibyte.php';
	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/api/language.php';
	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/strings.php';
	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/error.php';
	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/post.php';
	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/system.php';
	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/convert_encoding.php';
	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/search.php';
	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/highlight.php';
	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/object.php';
	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/object_handler.php';
	include_once $HAPPY_SEARCH_ROOT_PATH.'/include/happy_search_constant.php';
	include_once $HAPPY_SEARCH_ROOT_PATH.'/class/happy_search_modules.php';
	include_once $HAPPY_SEARCH_ROOT_PATH.'/class/happy_search_google.php';
	include_once $HAPPY_SEARCH_ROOT_PATH.'/class/happy_search.php';

// search.php
	if ( file_exists(XOOPS_ROOT_PATH.'/language/'.$XOOPS_LANGUAGE.'/search.php') ) 
	{
		include_once XOOPS_ROOT_PATH.'/language/'.$XOOPS_LANGUAGE.'/search.php';
	}
	else
	{
		include_once XOOPS_ROOT_PATH.'/language/english/search.php';
	}

// search_make_context
	if( !function_exists( 'search_make_context' ) ) 
	{
		if ( file_exists(XOOPS_ROOT_PATH.'/modules/'.$SEARCH_DIRNAME.'/include/function.php') )
		{
			include_once XOOPS_ROOT_PATH.'/modules/'.$SEARCH_DIRNAME.'/include/function.php';
		}
		else
		{
			include_once $HAPPY_SEARCH_ROOT_PATH.'/include/search_function.php';
		}
	}

// constant
	$QUERY_DEFAULT = 'xoops';
	$TIME_LIMIT = 60*24*60*60;	// 2 month

	$MAX_MOD_SEARCH      = 2;
	$MAX_MOD_SHOW_ALL    = 5;
	$MIN_MOD_SHOW_MODULE = 1;

	$MAX_RSS_SEARCH      = 2;
	$MAX_RSS_SHOW_ALL    = 2;
	$MIN_RSS_SHOW_MODULE = 1;

	$MAX_XOOGLE = 0;

	$EXCLUDE_ARR = array('rssc', 'rssc0', 'xoogle' );
	$STRICT_ARR  = array('rssc', 'rssc0');

// get param
	$search_handler =& happy_search::getInstance();

	$search_handler->init( $QUERY_DEFAULT );
	$search_handler->check_input_param();

// search in modules
	$search_handler->clear_dirname_array();
	$search_handler->set_exclude_dirname_array( $EXCLUDE_ARR );
	$search_handler->search_in_modules( $MAX_MOD_SEARCH );

	$results = $search_handler->get_search_results();
	$search_handler->set_time_limit(      $TIME_LIMIT );
	$search_handler->set_max_show_all(    $MAX_MOD_SHOW_ALL );
	$search_handler->set_min_show_module( $MIN_MOD_SHOW_MODULE );
	$mod_results = $search_handler->sort_results_by_time( $results );

	$mod_show = 0;
	if ( is_array($mod_results) && count($mod_results) )
	{
		$mod_show = 1;
	}

// search in rssc
	$search_handler->clear_dirname_array();
	$search_handler->set_strict_dirname_array( $STRICT_ARR );
	$search_handler->search_in_modules( $MAX_RSS_SEARCH );

	$results = $search_handler->get_search_results();
	$search_handler->set_max_show_all(    $MAX_RSS_SHOW_ALL );
	$search_handler->set_min_show_module( $MIN_RSS_SHOW_MODULE );
	$rss_results = $search_handler->sort_results_by_time( $results );

	$rss_show = 0;
	if ( is_array($rss_results) && count($rss_results) )
	{
		$rss_show = 1;
	}

// search in xoogle
	$search_handler->search_in_modules( $MAX_XOOGLE );

	$block = array(
		'lang_search'         => _SR_SEARCH,
		'lang_search_results' => _SR_SEARCHRESULTS,
		'lang_keyword'        => _SR_KEYWORDS,
		'lang_this_site'      => _BL_HAPPY_SEARCH_THIS_SITE,
		'lang_rss_site'       => _BL_HAPPY_SEARCH_RSS_SITE,
		'lang_google_site'    => _BL_HAPPY_SEARCH_GOOGLE_SITE,
		'keywords'            => $search_handler->get_query_array(),
		'query'               => $search_handler->get_query(),
		'mod_show'            => $mod_show,
		'mod_results'         => $mod_results,
		'rss_show'            => $rss_show,
		'rss_results'         => $rss_results,
		'xoogle_show'         => 0,
		'xoogle_results'      => '',
	);

	return $block;
}

?>