<?php
// $Id: url_manage.php,v 1.1.1.1 2008/02/09 06:46:14 ohwada Exp $

//=========================================================
// Google PageRank Module
// 2008-02-06 K.OHWADA
//=========================================================

//---------------------------------------------------------
// system
//---------------------------------------------------------
include '../../../include/cp_header.php';

$XOOPS_LANGUAGE = $xoopsConfig['language'];

//---------------------------------------------------------
// gpagerank
//---------------------------------------------------------
if( !defined('GPAGERANK_DIRNAME') )
{
	define('GPAGERANK_DIRNAME', $xoopsModule->dirname() );
}

if( !defined('GPAGERANK_ROOT_PATH') )
{
	define('GPAGERANK_ROOT_PATH', XOOPS_ROOT_PATH.'/modules/'.GPAGERANK_DIRNAME );
}

if( !defined('GPAGERANK_URL') )
{
	define('GPAGERANK_URL', XOOPS_URL.'/modules/'.GPAGERANK_DIRNAME );
}

if( !defined('GPAGERANK_ADMIN_URL') )
{
	define('GPAGERANK_ADMIN_URL', XOOPS_URL.'/modules/'.GPAGERANK_DIRNAME. '/admin' );
}

if( !defined('GPAGERANK_TIME_START') )
{
	list($usec, $sec) = explode(" ",microtime()); 
	$time = floatval($sec) + floatval($usec); 
	define('GPAGERANK_TIME_START', $time );
}

include_once GPAGERANK_ROOT_PATH.'/include/constant.php';
include_once GPAGERANK_ROOT_PATH.'/include/multibyte.php';
include_once GPAGERANK_ROOT_PATH.'/include/gtickets.php';
include_once GPAGERANK_ROOT_PATH.'/class/pagenavi.php';
include_once GPAGERANK_ROOT_PATH.'/class/error.php';
include_once GPAGERANK_ROOT_PATH.'/class/post.php';
include_once GPAGERANK_ROOT_PATH.'/class/form.php';
include_once GPAGERANK_ROOT_PATH.'/class/handler.php';
include_once GPAGERANK_ROOT_PATH.'/class/url_handler.php';
include_once GPAGERANK_ROOT_PATH.'/class/manage.php';

if ( file_exists( GPAGERANK_ROOT_PATH.'/language/'.$XOOPS_LANGUAGE.'/modinfo.php') ) 
{
	include_once GPAGERANK_ROOT_PATH.'/language/'.$XOOPS_LANGUAGE.'/modinfo.php';
}
else
{
	include_once GPAGERANK_ROOT_PATH.'/language/english/modinfo.php';
}

if ( file_exists( GPAGERANK_ROOT_PATH.'/language/'.$XOOPS_LANGUAGE.'/main.php') ) 
{
	include_once GPAGERANK_ROOT_PATH.'/language/'.$XOOPS_LANGUAGE.'/main.php';
}
else
{
	include_once GPAGERANK_ROOT_PATH.'/language/english/main.php';
}

//=========================================================
// class gpagerank_url_manage
//=========================================================
class gpagerank_url_manage extends gpagerank_manage
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function gpagerank_url_manage()
{
	$this->gpagerank_manage();
	$this->set_manage_handler( gpagerank_url_handler::getInstance() );
	$this->set_manage_title( 'URL Table Management' );
	$this->set_max_sortid( 3 );

}

//---------------------------------------------------------
// main
//---------------------------------------------------------
function main()
{
	switch ( $this->_get_op() )
	{
		case 'add':
		case 'edit':
		case 'delete':
		case 'edit_all':
		case 'delete_all':
			if ( !$this->check_token() )
			{
				$this->print_form_with_error( 'Token Error' );
				exit();
			}
			$this->_execute();
			break;

		case 'form':
			xoops_cp_header();
			$this->_print_form();
			break;

		case 'list':
		default:
			xoops_cp_header();
			$this->_print_list();
			break;
	}

	echo $this->build_admin_footer();
	xoops_cp_footer();
	exit();

}

function _execute()
{
	switch ( $this->_get_op() )
	{
		case 'add':
			$this->manage_add();
			break;

		case 'edit':
			$this->manage_edit();
			break;

		case 'delete':
			$this->manage_delete();
			break;

		case 'delete_all':
			$this->manage_delete_all();
			break;
	}
}

function _get_op()
{
	if ( $this->_gpagerank_post->get_post( 'add' ) )
	{	return 'add';	}
	if ( $this->_gpagerank_post->get_post( 'edit' ) )
	{	return 'edit';	}
	if ( $this->_gpagerank_post->get_post( 'delete' ) )
	{	return 'delete';	}
	if ( $this->_gpagerank_post->get_post( 'delete_all' ) )
	{	return 'delete_all';	}

	return $this->_gpagerank_post->get_post_get( 'op' );
}

//---------------------------------------------------------
// post
//---------------------------------------------------------
function &_build_row_by_post()
{
	$row = array(
		'id'          => $this->_gpagerank_post->get_post_get( 'id' ),
		'url'         => $this->_gpagerank_post->get_post_get( 'url' ),
		'pr'          => $this->_gpagerank_post->get_post_get( 'pr' ),
		'update_unix' => $this->_gpagerank_post->get_post_get( 'update_unix' ),
	);
	return $row;
}

//---------------------------------------------------------
// list
//---------------------------------------------------------
function _print_list()
{
	$sub0 = 'ID ascent';
	$sub1 = 'ID descent';
	$sub2 = 'in This Site PageRank Highest to Lowest';
	$sub3 = 'in This Site PageRank Lowest to Highest';

	$this->set_sortid_by_post();
	$this->set_limit_by_post();

	switch ( $this->_sortid )
	{
		case 2:
		case 3:
			$total = $this->_manage_handler->get_count_this_site();

			break;

		case 0:
		case 1:
		default:
			$total = $this->_manage_handler->get_count_all();
			break;
	}

	if ( $total == 0 )
	{
		echo $this->build_manage_bread_crumb();
		echo $this->highlight( 'there are no record' );
		return false;
	}

	echo $this->build_manage_bread_crumb();
	echo $this->build_show_title();

	echo '<ul>'."\n";
	echo '<li><a href="'. $this->_THIS_URL .'?sortid=0">'. $sub0 .'</a></li>'."\n";
	echo '<li><a href="'. $this->_THIS_URL .'?sortid=1">'. $sub1 .'</a></li>'."\n";
	echo '<li><a href="'. $this->_THIS_URL .'?sortid=2">'. $sub2 .'</a></li>'."\n";
	echo '<li><a href="'. $this->_THIS_URL .'?sortid=3">'. $sub3 .'</a></li>'."\n";
	echo '</ul>'."\n";
	echo "<br />\n";

	$this->_manage_total = $total;
	$start = $this->get_pagenavi_start( $total );

	switch ( $this->_sortid )
	{
		case 1:
			$sub  = $sub1;
			$rows =& $this->_manage_handler->get_rows_all_desc( $this->_LIMIT, $start );
			break;

		case 2:
			$sub  = $sub2;
			$rows  =& $this->_manage_handler->get_rows_this_site_desc( $this->_LIMIT, $start );
			break;

		case 3:
			$sub  = $sub3;
			$rows  =& $this->_manage_handler->get_rows_this_site_asc( $this->_LIMIT, $start );
			break;

		case 0:
		default:
			$sub  = $sub0;
			$rows =& $this->_manage_handler->get_rows_all_asc( $this->_LIMIT, $start );
			break;
	}

	echo "<h4>". $sub ."</h4>\n";

	$this->_print_url_list( $total, $rows );
}

function _print_url_list( $total, &$rows )
{
	echo sprintf( 'there are %s records', $total ) ."<br /><br />\n";

	echo $this->build_form_begin( 'edit_all' );

	echo $this->build_table_begin();

	echo '<tr align="center">';
	echo '<th>'. $this->build_js_checkall() .'</th>';
	echo '<th>'. 'ID' .'</th>';
	echo '<th>'. 'URL' .'</th>';
	echo '<th>'. 'PageRank' .'</th>';
	echo '<th>'. 'update' .'</th>';
	echo '</tr>'."\n";

	foreach ( $rows as $row )
	{
		$id    =  intval( $row['id'] );
		$class = $this->get_alternate_class();

		echo '<tr>';
		echo $this->build_manage_line_js_checkbox( $id );
		echo $this->build_manage_line_id( $id );
		echo $this->build_manage_line_value( $row['url'] );
		echo $this->build_manage_line_value( $row['pr'] );
		echo $this->build_manage_line_value( formatTimestamp( $row['update_unix'] ) );
		echo "</tr>\n";
	}

	echo '<tr>';
	echo '<td class="head">';
	echo '<input type="submit" name="delete_all" value="'. _DELETE .'" />';
	echo '</td>';
	echo '<td class="head" colspan="6"></td>';
	echo "</tr>\n";
	echo "</table></form>\n";
	echo "<br />\n";

	echo $this->build_form_pagenavi_limit();
	echo $this->build_pagenavi();

}

//---------------------------------------------------------
// form
//---------------------------------------------------------
function _print_form( $id=null )
{
	$row =& $this->get_manage_row_by_id( $id );
	if ( !is_array($row) )
	{	return false;	}

	echo $this->build_manage_bread_crumb();
	echo $this->build_show_title();
	echo $this->build_show_list();

	echo $this->build_manage_form_begin( $row );

	echo $this->build_table_begin();
	echo $this->build_line_title( 'url manage' );

	echo $this->build_manage_id( $row,                'ID' );
	echo $this->build_line_text( $row, 'url',         'URL' );
	echo $this->build_line_text( $row, 'pr',          'PageRank' );
	echo $this->build_line_text( $row, 'update_unix', 'update' );
	echo $this->build_line_value( '', formatTimestamp( $row['update_unix'] ) );
	echo $this->build_manage_submit( $row );



	echo "</table></form>\n";
}

// --- class end ---
}

//=========================================================
// main
//=========================================================
$manage = new gpagerank_url_manage();
$manage->main();

exit();
// --- main end ---

?>