<?php
// $Id: manage.php,v 1.1.1.1 2008/02/09 06:46:14 ohwada Exp $

//=========================================================
// Google PageRank Module
// 2008-02-06 K.OHWADA
//=========================================================

//=========================================================
// class gpagerank_manage
//=========================================================
class gpagerank_manage extends gpagerank_form
{
	var $_manage_handler;

	var $_manage_title;
	var $_manage_total = 0;

	var $_post_id;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function gpagerank_manage()
{
	$this->gpagerank_form();
	$this->_post_id = intval( $this->_gpagerank_post->get_post_get( 'id' ) );
}

function set_manage_handler( &$handler)
{
	$this->_manage_handler =& $handler;
}

function set_manage_title( $title )
{
	$this->_manage_title = $title;
}

//---------------------------------------------------------
// add
//---------------------------------------------------------
function manage_add()
{
	$row =& $this->_build_row_by_post();

	$newid = $this->_manage_handler->insert( $row );
	if ( !$newid )
	{
		$msg  = 'DB error <br />';
		$msg .= $this->_manage_handler->get_format_error();
		redirect_header( $this->build_form_url(), 3, $msg );
		exit();
	}

	redirect_header( $this->build_form_url( $newid ), 1, 'Added' );
	exit();
}

function build_form_url( $id=0 )
{
	if ( empty($id) )
	{
		$id = $this->_post_id;
	}
	$url = $this->_THIS_URL .'?op=form&amp;id='. intval($id);
	return $url;
}

//---------------------------------------------------------
// edit
//---------------------------------------------------------
function manage_edit()
{
	$row =& $this->_build_row_by_post();

	$ret = $this->_manage_handler->update( $row );
	if ( !$ret )
	{
		$msg  = 'DB error <br />';
		$msg .= $this->_manage_handler->get_format_error();
		redirect_header( $this->build_form_url(), 3, $msg );
		exit();
	}

	redirect_header( $this->build_form_url(), 1, 'Updated' );
	exit();
}

//---------------------------------------------------------
// delete
//---------------------------------------------------------
function manage_delete()
{
	$row =& $this->_manage_handler->get_row_by_id( $this->_post_id );
	if ( !$row )
	{
		echo $this->build_link_index_admin(). "<br /><br />\n";
		echo $this->highlight( 'there are no record' );
		return false;
	}

	$ret = $this->_manage_handler->delete( $row );
	if ( !$ret )
	{
		$msg  = 'DB error <br />';
		$msg .= $this->_manage_handler->get_format_error();
		redirect_header( $this->build_form_url(), 3, $msg );
		exit();
	}

	redirect_header( $this->_THIS_URL, 1, 'Deleted' );
	exit();
}

function manage_delete_all()
{
	$id_arr   =& $this->_gpagerank_post->get_post( $this->_CHECK_ALL_ID );

	$flag_error = false;
	$url = $this->_THIS_URL;

	foreach ( $id_arr as $id )
	{
		$row =& $this->_manage_handler->get_row_by_id( $id );
		if ( !$row )
		{	continue;	}

		$ret = $this->_manage_handler->delete( $row );
		if ( !$ret )
		{
			$this->_set_error( $this->_manage_handler->get_errors() );
			$flag_error = true;
		}
	}

	if ( $flag_error )
	{
		$msg  = 'DB error <br />';
		$msg .= $this->get_format_error();
		redirect_header( $url, 3, $msg );
		exit();
	}

	redirect_header( $url, 1, 'Deleted' );
	exit();
}

//---------------------------------------------------------
// manage title
//---------------------------------------------------------
function build_manage_title()
{
	$text  = $this->build_manage_bread_crumb();
	$text .= $this->build_show_title();
	$text .= $this->build_show_list();
	$text .= $this->build_show_add_record();
	return $text;
}

function build_show_title()
{
	$text = "<h3>". $this->_manage_title ."</h3>\n";
	return $text;
}

function build_manage_bread_crumb()
{
	$text  = '<a href="index.php">';
	$text .= $this->sanitize( $this->_MODULE_NAME );
	$text .= '</a>';
	$text .= ' &gt;&gt; ';
	$text .= '<a href="'. $this->_THIS_URL .'">';
	$text .= $this->sanitize( $this->_manage_title );
	$text .= '</a>';
	$text .= "<br /><br />\n";
	return $text;
}

//---------------------------------------------------------
// manage list
//---------------------------------------------------------
function get_manage_total_print_error()
{
	$total = $this->get_manage_total();
	if ( $total == 0 )
	{
		echo $this->build_manage_bread_crumb();
		echo $this->highlight( 'there are no record' );
		return 0;
	}

	return $total;
}

function build_show_list()
{
	$text  = '<a href="'. $this->_THIS_URL .'">';
	$text .= 'show list';
	$text .= '</a>';
	$text .= "<br /><br >\n";
	return $text;
}

function build_show_add_record()
{
	$text  = '<a href="'. $this->_THIS_URL .'?op=form">';
	$text .= 'add record';
	$text .= '</a>';
	$text .= "<br /><br />\n";
	return $text;
}

function get_manage_total()
{
	$total = $this->_manage_handler->get_count_all();
	$this->_manage_total = $total;
	return $total;
}

function &get_manage_rows_asc()
{
	$start = $this->get_pagenavi_start( $this->_manage_total );
	return $this->_manage_handler->get_rows_all_asc( $this->_LIMIT, $start );
}

function &get_manage_rows_desc()
{
	$start = $this->get_pagenavi_start( $this->_manage_total );
	return $this->_manage_handler->get_rows_all_desc( $this->_LIMIT, $start );
}

function build_manage_line_js_checkbox( $id )
{
	$text  = '<td class="'. $this->_alternate_class .'">';
	$text .= $this->build_js_checkbox( $id );
	$text .= '</td>';
	return $text;
}

function build_manage_line_id( $id )
{
	$id = intval($id);
	$text  = '<td class="'. $this->_alternate_class .'">';
	$text .= '<a href="'. $this->_THIS_URL .'?op=form&amp;id='. $id . '">';
	$text .= sprintf( '%04d', $id ) .'</a>';
	$text .= '</td>';
	return $text;
}

function build_manage_line_value( $value, $flag=true )
{
	if ( $flag )
	{
		$value = $this->sanitize( $value );
	}
	$text  = '<td class="'. $this->_alternate_class .'">';
	$text .= $value;
	$text .= '</td>';
	return $text;
}

//---------------------------------------------------------
// manage form
//---------------------------------------------------------
function &get_manage_row_by_id( $id=null )
{
	$false = false;

	if ( empty($id) )
	{
		$id = $this->_gpagerank_post->get_post_get( 'id' );
	}
	$id = intval( $id );

	$row =& $this->_build_row_by_post();
	$op  = 'add';

	if ( $id )
	{
		$row =& $this->_manage_handler->get_row_by_id( $id );
		if ( !is_array($row) )
		{
			echo $this->build_manage_bread_crumb();
			echo $this->highlight( 'there are no record' );
			return $false;
		}

		$op = 'edit';
	}

	$row['id'] = $id;
	$row['op'] = $op;

	return $row;
}

function build_manage_form_begin( &$row )
{
	$op = isset($row['op']) ? $row['op'] : null;
	$id = isset($row['id']) ? $row['id'] : null;

	$text  = $this->build_form_begin( $op, $id );
	return $text;
}

function build_manage_id( &$row, $title )
{
	if ( isset( $row['id'] )  ) 
	{
	 	$id = intval( $row['id'] );
	 	if ( $id )
	 	{
			return $this->build_line_label( $row, 'id', $title );
		}
	}
	return null;
}

function build_manage_submit( &$row )
{
	if ( isset( $row['id'] )  ) 
	{
	 	$id = intval( $row['id'] );
	 	if ( $id )
	 	{
			return $this->build_line_edit();
		}
	}
	return $this->build_line_add();
}

//---------------------------------------------------------
// error
//---------------------------------------------------------
function print_form_with_error( $msg=null )
{
	xoops_cp_header();
	if ( $msg )
	{
		xoops_error( $msg );
	}
	$this->_print_form();
	xoops_cp_footer();
	exit();
}

// --- class end ---
}

?>