<?php
// $Id: url_handler.php,v 1.1.1.1 2008/02/09 06:46:14 ohwada Exp $

//=========================================================
// Google PageRank Module
// 2008-02-06 K.OHWADA
//=========================================================

//=========================================================
// class gpagerank_url_handler
//=========================================================
class gpagerank_url_handler extends gpagerank_handler
{
	var $_CACHE_TIME_LONG  = _GPAGERANK_C_CACHE_TIME_LONG;
	var $_CACHE_TIME_SHORT = _GPAGERANK_C_CACHE_TIME_SHORT;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function gpagerank_url_handler()
{
	$this->gpagerank_handler();
	$this->set_table( 'gpagerank_url' );
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new gpagerank_url_handler();
	}
	return $instance;
}

//---------------------------------------------------------
// insert
//---------------------------------------------------------
function insert( &$row )
{
	foreach ($row as $k => $v) 
	{	${$k} = $v;	}

	$sql  = 'INSERT INTO '.$this->_table.' (';
	$sql .= 'url, ';
	$sql .= 'pr, ';
	$sql .= 'update_unix ';
	$sql .= ') VALUES ( ';
	$sql .= $this->quote($url).', ';
	$sql .= intval($pr).', ';
	$sql .= intval($update_unix).' ';
	$sql .= ')';

// allow when get method
	$ret = $this->queryF( $sql );
	if ( !$ret )
	{	return false;	}

	return $this->_db->getInsertId();
}

//---------------------------------------------------------
// update
//---------------------------------------------------------
function update( &$row )
{
	foreach ($row as $k => $v) 
	{	${$k} = $v;	}

	$sql = 'UPDATE '.$this->_table.' SET ';
	$sql .= 'url='.$this->quote($url).', ';
	$sql .= 'pr='.intval($pr).', ';
	$sql .= 'update_unix='.intval($update_unix).' ';
	$sql .= 'WHERE id='.intval($id);

// allow when get method
	return $this->queryF( $sql );
}

//---------------------------------------------------------
// get count
//---------------------------------------------------------
function get_count_this_site()
{
	$sql  = 'SELECT count(*) FROM '.$this->_table.' WHERE ';
	$sql .= $this->_get_where_this_site();
	$row  = $this->get_count_by_sql( $sql );
	return $row;
}

function _get_where_this_site()
{
	$sql = 'url LIKE '. $this->quote( XOOPS_URL .'%' );
	return $sql;
}

//---------------------------------------------------------
// get row
//---------------------------------------------------------
function &get_row_by_url($url)
{
	$sql  = 'SELECT * FROM '.$this->_table.' WHERE ';
	$sql .= 'url='. $this->quote($url);
	$sql .= ' ORDER BY id ASC';
	$row  =& $this->get_row_by_sql( $sql );
	return $row;
}

//---------------------------------------------------------
// get rows
//---------------------------------------------------------
function &get_rows_this_site_asc($limit=0, $offset=0)
{
	$sql  = 'SELECT * FROM '.$this->_table.' WHERE ';
	$sql .= $this->_get_where_this_site();
	$sql .= ' ORDER BY pr ASC, id ASC';
	$row  =& $this->get_rows_by_sql( $sql, $limit, $offset );
	return $row;
}

function &get_rows_this_site_desc($limit=0, $offset=0)
{
	$sql  = 'SELECT * FROM '.$this->_table.' WHERE ';
	$sql .= $this->_get_where_this_site();
	$sql .= ' ORDER BY pr DESC, id ASC';
	$row  =& $this->get_rows_by_sql( $sql, $limit, $offset );
	return $row;
}

//---------------------------------------------------------
// get_id array
//---------------------------------------------------------
function &get_id_array_older($limit=0, $offset=0)
{
	$sql = 'SELECT id FROM '.$this->_table.' ORDER BY update_unix ASC';
	$arr =& $this->get_first_rows_by_sql($sql, $limit, $offset);
	return $arr;
}

//---------------------------------------------------------
// clear record
//---------------------------------------------------------
function clear_over_num($num)
{
	if ($num <= 0)
	{	return 0;	}	// no action

	$total = $this->get_count_all();
	$limit = $total - $num;

	if ($limit <= 0)
	{	return 0;	}	// no action

	$id_arr = $this->get_id_array_older($limit);

// exec
	foreach( $id_arr as $id )
	{
		$this->delete_by_id($id);
	}

	return $limit;
}

//---------------------------------------------------------
// check
//---------------------------------------------------------
function check_time( &$row )
{
	$cache_time = $this->_CACHE_TIME_LONG;
	if ( $row['update_unix'] == -3 )
	{
		$cache_time = $this->_CACHE_TIME_SHORT;
	}

	if ( time() < ( intval( $row['update_unix'] ) + $cache_time ) )
	{	return true;	}
	return false;
}

// --- class end ---
}

?>