<?php
//=========================================================
// OpenID
// 2010-07-07 K.OHWADA
//=========================================================

class openid_auth
{
	var $_consumer =  null;
    var $_store    = null;

	var $_BASE_URL     = null;
	var $_OPENID_DIR   = null;
	var $_FILTERS_DIR  = null;
	var $_CALLBACK_URL = null;

	var	$_oid_get_fullname = 0;
	var	$_oid_get_email    = 0;

	var	$_email    = null;
	var $_nickname = null;
	var	$_fullname = null;

	var $_error_code = 0 ;
	var $_error_msg  = null ;

	var $_PAPE_POLICY_URIS = array(
			PAPE_AUTH_MULTI_FACTOR_PHYSICAL,
			PAPE_AUTH_MULTI_FACTOR,
			PAPE_AUTH_PHISHING_RESISTANT
	);

	var $_OP_GOOGLE      = 'https://www.google.com/accounts/o8/id';
	var	$_OP_GOOGLE_APPS = 'https://www.google.com/accounts/o8/site-xrds?hd=';

//---------------------------------------------------------
// Constructor
//---------------------------------------------------------
function openid_auth()
{
//    dummy
}

//---------------------------------------------------------
// public
// set file store & init consumer class
//---------------------------------------------------------
function set_file_store( $s )
{
	$store    =& new Auth_OpenID_FileStore( $s );
	$session  =& new openid_php_session();

	$consumer_class = null;
	if ( class_exists('openid_generic_consumer') ) {
		$consumer_class = 'openid_generic_consumer';
	}

	$this->_consumer =& new Auth_OpenID_Consumer( $store, $session, $consumer_class );
}

function set_base_url( $s )
{
	$this->_BASE_URL = $s;
}

function set_openid_dir( $s )
{
	$this->_OPENID_DIR = $s;
}

function set_filters_dir( $s )
{
	$this->_FILTERS_DIR = $s;
}

function set_callback_url( $s ) 
{
	$this->_CALLBACK_URL = $s;
}

function set_oid_get_fullname( $s )
{
	$this->_oid_get_fullname = intval($s);
}

function set_oid_get_email( $s )
{
	$this->_oid_get_email = intval($s);
}

function get_email()
{
	return $this->_email ;
}

function get_fullname()
{
	return $this->_fullname ;
}

function get_nickname()
{
	return $this->_nickname ;
}

function get_error_code()
{
	return $this->_error_code ;
}

function get_error_msg()
{
	return $this->_error_msg ;
}

//---------------------------------------------------------
// public
// get OpenID server url
//---------------------------------------------------------
function get_redirect_server( $op )
{
	if ( empty($op) ) {
		$this->_error_code = 11;
    	return false;
	}

	if ( $op == 'google' ) {
		$op = $this->_OP_GOOGLE ;
	}

// google apps
	new GApps_OpenID_Discovery( $this->_consumer );

	// Begin the OpenID authentication process.
	$auth_request = $this->_consumer->begin( $op );

	// No auth request means we can't begin OpenID.
	if ( !$auth_request ) {
		$this->_error_code = 12;
       	return false;
	}

	$sreg = array();
	if ( $this->_oid_get_fullname == 1 ) {
		$sreg[] = 'fullname';
	}
	if ( $this->_oid_get_email == 1 ) {
		$sreg[] = 'email';
	}

	$sreg_request = Auth_OpenID_SRegRequest::build(
		array('nickname'),	// Required
		$sreg	// Optional
	);
	if ( $sreg_request ) {
		$auth_request->addExtension( $sreg_request );
	}

	$pape_request = new Auth_OpenID_PAPE_Request( $this->_PAPE_POLICY_URIS );
	if ( $pape_request ) {
		$auth_request->addExtension( $pape_request );
	}

	if ( $auth_request->shouldSendRedirect() ) {
		$redirect_url = $auth_request->redirectURL(	$this->_BASE_URL, $this->_CALLBACK_URL );

	// If the redirect URL can't be built, display an error
	// message.
		if ( Auth_OpenID::isFailure( $redirect_url ) ) {
			$this->_error_msg  = $redirect_url->message;
			$this->_error_code = 13;
			return false;
		} else {
			// Send redirect.
			return array( 
				'method' => 'get',
				'url'    => $redirect_url, 
			);

		}

	} else {
		// Generate form markup and render it.
		$message = $auth_request->getMessage( $this->_BASE_URL, $this->_CALLBACK_URL );

		// Display an error if the form markup couldn't be generated;
		// otherwise, render the HTML.
		if ( Auth_OpenID::isFailure( $message ) ) {
			$this->_error_msg  = $message->message;
			$this->_error_code = 14;
			return false;

		} else {
			return array(
				'method' => 'post',
				'url'    => $auth_request->endpoint->server_url , 
				'args'   => $message->toPostArgs(),
			);
		}
	}
}

//---------------------------------------------------------
// public
// get OpenID
//---------------------------------------------------------
function get_openid()
{
	$response  = $this->_consumer->complete( $this->_CALLBACK_URL );

	// Check the response status.
	switch ( $response->status ) 
	{
	case Auth_OpenID_CANCEL:
		// This means the authentication was cancelled.
		$this->_error_code = 21;
		return false;

	case Auth_OpenID_FAILURE:
		// Authentication failed; display the error message.
		$this->_error_msg  = $response->message ;
		$this->_error_code = 22;
		return false;

	case Auth_OpenID_SUCCESS:
		// This means the authentication succeeded; extract the
		// identity URL and Simple Registration data (if it was
		// returned).
		return $this->get_openid_success( $response );

	default:
		$this->_error_code = 23;
		return false;
	}
}

//---------------------------------------------------------
// private
//---------------------------------------------------------
function get_openid_success( $response )
{
	$openid = $response->getDisplayIdentifier();
	$sreg_resp = Auth_OpenID_SRegResponse::fromSuccessResponse( $response );

	$sreg = $sreg_resp->contents();
	if ( !empty( $sreg['email'] ) ) {
		$this->_email = $sreg['email'];
	}

	if ( !empty( $sreg['nickname'] ) ) {
		$this->_nickname = $sreg['nickname'];
	}

	if ( !empty( $sreg['fullname'] ) ) {
		$this->_fullname = $sreg['fullname'];
	}

	// apply filters
	$filter = new openid_filter();
	$filter->set_filters_dir( $this->_FILTERS_DIR );
	$filter->set_plugin_name( 'openid' );
	$filter->set_option( $response );
	$filter->set_id( $openid );
	$filter->apply();
	$openid = $filter->get_id();

	return $openid;
}

function isActive()
{
	if ($this->store->tableExists('exauth_openid_assoc') && $this->store->tableExists('exauth_openid_nonce')) {
		return true;
	}
	return false;
}

// === class end ===
}
