<?php
//=========================================================
// OpenID
// 2010-07-07 K.OHWADA
//=========================================================

/**
 * @package exauth_plugin_openid
 * @version $Id: mixi.php 234 2009-01-05 12:37:54Z kisara $
 */

// 2010-07-07 K.OHWADA
// require_once XOOPS_ROOT_PATH . '/modules/exauth/class/AbstractIDFilter.class.php';

/**
 * Filter class
 */
class MixiIDFilter extends AbstractIDFilter
{
    /**
     * @var array
     */
    var $_set_groups = null;

    /**
     * Set your Mixi ID.
     * @var string
     */
    var $_my_mixi_id = null;

    /**
     * Set your Mixi community ID.
     * @var string
     */
    var $_my_mixi_community_id = null;

    /**
     * Apply filter
     */
    function apply()
    {
        if (preg_match('|^https?://id\.mixi\.jp/(\w+)/friends/(\w+)$|', $this->_id, $match)) {
            $this->_filterd_id = $this->_option->endpoint->getLocalID();
            if ($this->_my_mixi_id !== null && $this->_my_mixi_id == $match[1] && $this->_set_groups !== null) {
                $this->_filterd_group = $this->_set_groups;
            }
            else {
                $this->_filterd_group = $this->_group;
            }
        }
        else if (preg_match('|^(https?://id\.mixi\.jp/)community/(\w+)/(\w+)$|', $this->_id, $match)) {
            $this->_filterd_id = $this->_option->endpoint->getLocalID();
            if ($this->_my_mixi_community_id !== null && $this->_my_mixi_community_id == $match[1] && $this->_set_groups !== null) {
                $this->_filterd_group = $this->_set_groups;
            }
            else {
                $this->_filterd_group = $this->_group;
            }
        }
        else {
            $this->_filterd_id = $this->_id;
            $this->_filterd_group = $this->_group;
        } 
    }
}

