<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * 新着の表示
 *
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Whatsnew_View_Mobile_Init extends Action
{
    // リクエストパラメータを受け取るため
	var $module_id = null;
	var $result_only = null;
	var $limit = null;
	var $offset = null;

    // 使用コンポーネントを受け取るため
	var $whatsnewView = null;
	var $session = null;
	var $getdata = null;

	// Filterによりセット
	var $room_arr_flat =null; 

    // 値をセットするため
	var $whatsnew_obj = null;
	var $whatsnew_data = null;
	var $prev_offset = null;
	var $next_offset = null;

    /**
     * execute実行
     *
     * @access  public
     */
    function execute()
    {
		$this->limit = WHATSNEW_MOBILE_LIMIT;
		$this->offset = intval($this->offset);
		$this->session->setParameter(array("whatsnew", "offset"), $this->offset);
		
		$this->whatsnew_obj = $this->whatsnewView->getDefaultBlock($this->module_id);
		$this->whatsnew_obj["display_type"] = WHATSNEW_DEF_FLAT;
		$mobile_modules = $this->getdata->getParameter("mobile_modules");
		$display_modules = "";
		foreach ($mobile_modules as $display_position=>$modules) {
			foreach ($modules as $dir_name=>$module) {
				$display_modules .= ",".$module["module_id"];
			}
		}
		$this->whatsnew_obj["display_modules"] = substr($display_modules, 1);
		$this->whatsnew_obj["display_days"] = WHATSNEW_MOBILE_DAYS;
		$this->prev_offset = ($this->offset-$this->limit < 0 ? 0 : $this->offset-$this->limit);
		$this->next_offset = $this->offset + $this->limit;

    	$this->whatsnew_data = $this->whatsnewView->getResults($this->whatsnew_obj, $this->room_arr_flat, $this->limit, $this->offset);
    	$user_id = $this->session->getParameter("_user_id");
    	if (!empty($user_id)) {
    		$this->room_arr_flat["0"] = array("page_name" => WHATSNEW_NO_PAGE);
    	}
    	if ($this->whatsnew_data === false) {
    		return 'error';
    	}
   		return 'success';
    }
}
?>
