<?php
// $Id: Post.class.php,v 1.1.1.1 2011/03/19 16:57:56 ohwada Exp $

//=========================================================
// Facebook Netcommons
// K.OHWADA 2011-03-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Action
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

include_once BASE_DIR."/webapp/modules/facebook/components/Service.class.php";

class Facebook_Action_Main_Post extends Action
{
	// コンポーネントを受け取るため
	var $facebookView   = null;
	var $request        = null;

    /**
     * opneid モジュール
     *
     * @access  public
     */
//---------------------------------------------------------
// 投稿を行う
//---------------------------------------------------------
    function execute()
    {

// user_id を取得する。
// 取得できないときは、リダイレクトする。
		$user_id = $this->facebookView->get_session_userid_or_redirect_location();

		$code = 0;
		$msg  = null;

// 本文を取得する
		$facebook_message = $this->request->getParameter('facebook_message');

// 空ならば
		if ( empty($facebook_message) ) {
			$this->facebookView->redirect_location_post(
				11, FACEBOOK_ERR_POST_EMPTY );
			exit();
		}

// サービスの初期化
		$facebookService =& new Facebook_Components_Service();
		$ret = $facebookService->init();
		if ( !$ret ) {
			$this->facebookView->redirect_location_post(
				12, FACEBOOK_ERR_CONSUMER_KEY );
			exit();
		}

// ユーザ・トークンの設定
		$ret = $facebookService->set_token();
		if ( !$ret ) {
			$this->facebookView->redirect_location_post( 13 );
			exit();
		}

		$ret = $facebookService->post( $facebook_message );
		if ( !$ret ) {
			$msg  = FACEBOOK_ERR_POST_FAIL ;
			$msg .= '<br />';
			$msg .= $facebookService->get_error_msg();
			$this->facebookView->redirect_location_post( 11, $msg );
		}

		$this->facebookView->redirect_location_post( 1 );
		exit();
	}

// ===class end ===
}
?>