<?php
// $Id: Service.class.php,v 1.2 2011/03/29 09:30:58 ohwada Exp $

//=========================================================
// Facebook Netcommons
// K.OHWADA 2011-03-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

if ( !defined('_FACEBOOK_LOADED') ) {

	define('_FACEBOOK_LOADED', '1' );
	define('FACEBOOK_DIR', BASE_DIR. '/webapp/modules/facebook/includes' );

	$pear_dir = FACEBOOK_DIR.'/PEAR';
	set_include_path( get_include_path() . PATH_SEPARATOR . $pear_dir );

	require_once 'HTTP/Request2.php';
	require_once 'Cache/Lite.php';
	require_once FACEBOOK_DIR.'/class/service.class.php';
}

/**
 * Facebook module auth class
 *
 */
class Facebook_Components_Service 
{
	var	$_container   = null ;
	var	$_modulesView = null ;
	var	$_configView  = null ;
 	var	$_usersView   = null;

	var	$_service = null;

	var $_url_callback = null;

	var $_error_msg  = null;
	var $_error_code = 0;

	var $_CACHE_PATH = null;

/**
 * コンストラクター
 *
 * @access	public
 */
	function Facebook_Components_Service() 
	{
		$this->_container   =& DIContainerFactory::getContainer();
		$this->_modulesView =& $this->_container->getComponent("modulesView");
		$this->_configView  =& $this->_container->getComponent("configView");
 		$this->_usersView   =& $this->_container->getComponent("usersView");

		$this->_service =& new facebook_service();

		$this->_CACHE_PATH = BASE_DIR. '/webapp/uploads/facebook/cache/';
	}

	function get_error_code() 
	{
		return $this->_error_code ;
	}

	function get_error_msg() 
	{
		return $this->_error_msg ;
	}

//---------------------------------------------------------
// 初期化
//---------------------------------------------------------
	function init() 
	{
		list( $id, $secret ) = $this->get_config_consumer_key();

		if( empty($id) || empty($secret) ) {
			$this->_error_msg = FACEBOOK_ERR_CONSUMER_KEY;
			return false;
		}

		$this->_service->set_app_id(     $id );
		$this->_service->set_app_secret( $secret );

		$this->_service->set_scope_publish_stream( true );
		$this->_service->set_scope_offline_access( true );

		$this->_service->set_cache_use( true );
		$this->_service->set_cache_dir( $this->_CACHE_PATH );

		$this->_service->set_convert_space_use( true );

		return true;
	}

//---------------------------------------------------------
// Twiiter サーバへのリダイレクト
//---------------------------------------------------------
	function set_base_url( $base_url )
	{
		$this->_url_callback = $base_url.'/facebook_callback.php';
	}

	function login( )
	{
		$this->_service->set_url_callback( $this->_url_callback );

		$ret = $this->_service->login();
		if ( !$ret ) {
			$this->_error_code = $this->_service->get_error_code();
			$this->_error_msg  = $this->_service->get_error_msg();
			return false;
		}
		return true;
	}

//---------------------------------------------------------
// Facebook ID を取得する
//---------------------------------------------------------
	function callback()
	{
		$this->_service->set_url_callback( $this->_url_callback );

		$param_callback = $this->_service->callback();
		if ( !is_array($param_callback) ) {
			$this->_error_code = $this->_service->get_error_code();
			$this->_error_msg  = $this->_service->get_error_msg();
			return false;
		}

		$access_token = $param_callback['access_token'];
		$this->_service->set_session_token( $access_token );

		$ret = $this->set_token();
		if ( !$ret ) {
			return false;
		}

		$user = $this->get_user_me();
		if ( !is_array($user) ) {
	       	return false;
		}

		$param_auth = array(
			FACEBOOK_ITEM_NAME_ID    => $user['id'] ,
			FACEBOOK_ITEM_NAME_TOKEN => $access_token ,
		);
		return $param_auth;
	}

	function set_token()
	{
		$token = $this->_service->get_session_token();
		if ( empty($token) ) {
			$this->_error_msg  = FACEBOOK_ERR_TOKEN;
			return false;
		}

		$this->_service->set_token( $token ) ;
		return true;
	}

	function clear_session_token()
	{
		$this->_service->clear_session_token();
	}

//---------------------------------------------------------
// ユーザのパラメータを設定する
//---------------------------------------------------------
	function set_user_param( $user_id ) 
	{
		$token = $this->get_user_token( $user_id );

		if( empty($token) ) {
			$this->_error_msg = FACEBOOK_ERR_FACEBOOK_ID;
			return false;
		}

		$this->_service->set_token( $token );

		return true;
	}

//---------------------------------------------------------
// ユーザ情報を取得する
//---------------------------------------------------------
	function get_user_me()
	{
		$user = $this->_service->get_me();
		if ( !is_array($user) ) {
			$this->_error_code = $this->_service->get_error_code();
			$this->_error_msg  = $this->_service->get_error_msg();
        	return false;
		}
		return $user;
	}

//---------------------------------------------------------
// news feeds を取得する
//---------------------------------------------------------
	function set_elapse_words( $w1, $w2, $w3 ) 
	{
		$this->_service->set_elapse_full( $w1 );
		$this->_service->set_elapse_hour( $w2 );
		$this->_service->set_elapse_min(  $w3 );
	}

	function get_me_feeds( $flag_convert=true, $flag_picture=false )
	{
		$feeds = $this->_service->get_me_feeds( $flag_convert, $flag_picture );
		if ( !$feeds ) {
			$this->_error_code = $this->_service->get_error_code();
			$this->_error_msg  = $this->_service->get_error_msg();
        	return false;
		}

		$feeds = $this->_service->feeds_to_array( $feeds );
		$feeds = $this->_service->convert_feeds(  $feeds );
		return $feeds;
	}

//---------------------------------------------------------
// 投稿 する
//---------------------------------------------------------
	function post( $msg )
	{
		$ret = $this->_service->post_me_feed( $msg );
		if ( !$ret ) {
			$this->_error_code = $this->_service->get_error_code();
			$this->_error_msg  = $this->_service->get_error_msg();
        	return false;
		}
		return true;
	}

//---------------------------------------------------------
// consumer_key を取得する
//---------------------------------------------------------
	function get_config_consumer_key()
	{
		$module_id = $this->get_module_id_by_dirname( 'facebook' );
        $config    = $this->get_module_config( $module_id );

		$consumer_key    = $this->get_config_by_key( $config, 'consumer_key' );
		$consumer_secret = $this->get_config_by_key( $config, 'consumer_secret' );

		return array( $consumer_key, $consumer_secret );
	}

	function get_config_by_key( $config, $key )
	{
		$val = isset($config[ $key ]['conf_value']) ? $config[ $key ]['conf_value'] : null;
		return $val;
	}

	function get_module_config( $module_id )
	{
       $config = $this->_configView->getConfig( $module_id, false );
		return $config;
	}

	function get_module_id_by_dirname( $dirname )
	{
	    $module = $this->_modulesView->getModuleByDirname( $dirname );
    	if ( isset($module['module_id']) ) {
			return $module['module_id'];	
		}
		return false;
	}

//---------------------------------------------------------
// user_token を取得する
//---------------------------------------------------------
	function get_user_token( $user_id )
	{
		$token  = $this->get_users_item_link( $user_id, FACEBOOK_ITEM_NAME_TOKEN );
		return $token;
	}

	function get_users_item_link( $user_id, $name )
	{
		$item_id = $this->get_item_id_by_name( $name );
		if ( !$item_id ) {
			return false;
		}

		return $this->get_users_item_link_by_id( $user_id, $item_id );
	}

	function get_users_item_link_by_id( $user_id, $item_id )
	{
		$item = $this->_usersView->getUserItemLinkById( $user_id, $item_id );
		if ( isset($item['content']) ) {
			return $item['content'];
		}
		return false;
	}

	function get_item_id_by_name( $name )
	{
		$item_params = array(
			'item_name' => $name
		);

		$items = $this->_usersView->getItems( $item_params );

		$item_id = 0;
		if ( isset($items[0]['item_id']) ) {
			$item_id = $items[0]['item_id'];
		}

		if ( empty($item_id) ) {
			$this->set_error_code( 241 );
			return false;
		}

		return $item_id;
	}

// === class end ===
}
?>