<?php
// $Id: Auth.class.php,v 1.1.1.1 2011/03/19 16:57:56 ohwada Exp $

//=========================================================
// Facebook Netcommons
// K.OHWADA 2011-03-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons View
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

include_once BASE_DIR."/webapp/modules/facebook/components/Service.class.php";

class Facebook_View_Main_Auth extends Action
{
	// コンポーネントを使用するため
	var $facebookView = null;

    /**
     * Facebook モジュール
     *
     * @access  public
     */
//---------------------------------------------------------
// Facebook サーバーにリダイレクイトする
//---------------------------------------------------------
    function execute()
    {

// ログインしているか
// ログイン中のとき関連付けでなければ、リダイレクト
		$flag_login = $this->facebookView->auth_is_login_or_redirect_location();

// サービスの初期化
		$facebookService =& new Facebook_Components_Service();
		$ret = $facebookService->init();
		if ( !$ret ) {
			$this->facebookView->redirect_error_msg( 
				$twitterService->get_error_msg(),
				$flag_login );
			exit();
		}

// サービスへのログイン
		$facebookService->set_base_url( 
			$this->facebookView->get_base_url() );
		$facebookService->login();

// login から戻るときは 常にエラー
		$this->twitterView->redirect_error_msg( 
			$twitterService->get_error_msg(),
			$flag_login );
		exit();
	}

// === class end ===
}
?>