<?php
// $Id: Init.class.php,v 1.3 2011/03/29 09:30:58 ohwada Exp $

//=========================================================
// Facebook Netcommons
// K.OHWADA 2011-03-01
//=========================================================

include_once BASE_DIR."/webapp/modules/facebook/components/Service.class.php";

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons View
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

class Facebook_View_Main_Init extends Action
{
	// コンポーネントを使用するため
	var $facebookView = null;

	// 値をセットするため
	var $user    = null;
	var $message = null;
	var $error   = null;
	var $feeds   = null;
	var $feeds_error = null;
	var $show_feeds  = false;
	var $base_url            = null;
	var	$show_login_nc       = true;
	var	$show_login_facebook = true;
	var	$show_goto_control   = false;

    /**
     * Facebook モジュール
     *
     * @access  public
     */
//---------------------------------------------------------
// OpneID サーバーの入力画面を表示する
//---------------------------------------------------------
    function execute()
    {

// ユーザID を取得する
// 取得できなければ、exauthentry を表示する
		$user_id = $this->facebookView->get_init_userid_or_exauthentry();

// ログインしてなければ
       	if ( empty($user_id) ) {
			$this->base_url = $this->facebookView->get_base_url_ssl();

// オプションがあれば、上書きする
			$show = $this->facebookView->get_show_login_nc();
			if ( $show !== false ) {
				$this->show_login_nc = $show;
			}

        	return 'success_login';	
		}

		$facebookService =& new Facebook_Components_Service();
		$ret = $facebookService->init();

// Consumer Key が設定されてなければ
		if ( !$ret ) {
			$this->show_goto_control = true;
			$this->error = $facebookService->get_error_msg();
       		return 'success_error';	
		}

		$ret = $facebookService->set_user_param( $user_id );

// ユーザ・パラメータが設定されてなければ
		if ( !$ret ) {
       		return 'success_facebook';	
		}

		$user = $facebookService->get_user_me();

// ユーザ情報が取得できなければ
		if ( !$user ) {
			$this->error  = FACEBOOK_ERR_USER;
			$this->error .= '<br />';
			$this->error .= $facebookService->get_error_msg();
       		return 'success_error';	
		}

		$this->user  = $user;

		$facebookService->set_elapse_words( 
			FACEBOOK_ELAPSE_FULL, 
			FACEBOOK_ELAPSE_HOUR,
			FACEBOOK_ELAPSE_MIN );

		$feeds = $facebookService->get_me_feeds();

// ニュースフィードが取得できれば
		if ( is_array($feeds) ) {
			$this->show_feeds = true;
			$this->feeds      = $feeds;

// 取得できなければ
		} else {
			$this->feeds_error  = FACEBOOK_ERR_FEEDS;
			$this->feeds_error .= '<br />';
			$this->feeds_error .= $facebookService->get_error_msg();
		}

		$this->chech_return_code();

		return 'success';
	}

    function chech_return_code()
	{

		$code    = $this->facebookView->get_get_by_key('code');
		$msg     = $this->facebookView->get_session_post();
		$message = '';
		$error   = '';

		switch ($code)
		{
			case 1:
				$message = FACEBOOK_POST_SUCCESS;
				break;

			case 11:
				$error = $msg;
				break;

			case 12:
				$this->error = $msg;
				$this->show_goto_control = true;
       			return 'success_error';	

			case 13:
      			return 'success_facebook';
				break;

		}

		$this->message = $message;
		$this->error   = $error;
	}

// === class end ===
}
?>