using System;
using System.Collections.Generic;
using System.Text;
using System.Management;
using System.Net;
using System.Collections;

namespace xportip
{
    /// <summary>
    /// VXẽlbg[NA_v^ƑΉIPAhXƂ̃Tulbg}XNi[܂B
    /// </summary>
    struct IPinfo
    {
        public string Adapter;        //A_v^
        public byte[] IP;            //IPAhX̃oCgl
        public byte[] Subnet;        //Tulbg}XÑoCgl
        public string IPString        //IPAhX𕶎ƂăANZX
        {
            get
            {
                if (IP != null)
                {
                    //oCgz񂩂IPAhX擾ĕW\Lɕϊ
                    return (new IPAddress(IP).ToString());
                }
                else
                {
                    throw new ArgumentNullException();
                }
            }
            set
            {
                if (value != null)
                {
                    //z񂩂IPAhX擾ăoCgzɕϊ
                    this.IP = IPAddress.Parse(value).GetAddressBytes();
                }
                else
                {
                    throw new ArgumentNullException();
                }
            }
        }
        public string SubnetString        //Tulbg}XN𕶎ƂăANZX
        {
            get
            {
                if (Subnet != null)
                {
                    return (new IPAddress(Subnet).ToString());
                }
                else
                {
                    throw new ArgumentNullException();
                }
            }
            set
            {
                if (value != null)
                {
                    this.Subnet = IPAddress.Parse(value).GetAddressBytes();
                }
                else
                {
                    throw new ArgumentNullException();
                }
            }
        }
    }

    class getipad
    {
        public static IPinfo[] GetIP()
        {
            //񋓗pXg
            ArrayList adptIdx    = new ArrayList();    //A_v^ԍ(int)
            ArrayList adptName    = new ArrayList();    //A_v^(string)

            //l
            ArrayList ipinfo    = new ArrayList();    //IPinfo

            //lbg[NA_v^̗
            ManagementClass mc    = new ManagementClass("Win32_NetworkAdapter");
            ManagementObjectCollection mcol = mc.GetInstances();

            foreach(ManagementObject m in mcol)
            {
                adptIdx.Add(m["Index"]);    //A_v^ԍ擾AXgɓ
                adptName.Add(m["Name"]);    //A_v^擾AXgɓ
            }

            //IPAhX̗
            mc = new ManagementClass("Win32_NetworkAdapterConfiguration");
            mcol = mc.GetInstances();

            foreach(ManagementObject m in mcol)
            {
                string[] ad = (string[])m["IPAddress"];    //IPAhX̓z擾
                string[] sn = (string[])m["IPSubnet"];    //Tulbg}XN̓z擾

                if(
                    ad != null &&                    //IPAhX邩
                    adptIdx.Contains(m["Index"]) &&    //IPAhX̂A_v^Indexɗ񋓂̂Ȃɂ邩
                    sn[0] != string.Empty            //Tulbg}XNłȂ(null check͕sv)
                    )
                {
                    IPinfo tmp = new IPinfo();

                    tmp.Adapter    = (string)adptName[ adptIdx.IndexOf(m["Index"]) ];    //A_v^擾
                    tmp.IP        = IPAddress.Parse(ad[0]).GetAddressBytes();            //IPAhXBytezɕϊ
                    tmp.Subnet    = IPAddress.Parse(sn[0]).GetAddressBytes();            //Tulbg}XNBytezɕϊ
                    ipinfo.Add(tmp);
                }
            }

            if(ipinfo.Count == 0)
            {
                return null;
            }

            IPinfo[] info = new IPinfo[ipinfo.Count];
            int Index = 0;
            foreach (IPinfo i in ipinfo)
            {
                info[Index] = i;
                Index++;
            }
            return info;
        }
    }
}
