#include <qapplication.h>
#ifdef	QWS
#include <qpe/qpeapplication.h>
#endif
#include <qthread.h>
#include <qimage.h>
#include <qpainter.h>
#include <qcursor.h>
#include <qwidget.h>

#include <unistd.h>

#include "xqtcmn.h"
#include "qtscreen.h"
#include "qtkeytrans.h"

qtScreen *g_screen;

//
// Constructor
//
qtScreen::qtScreen(QWidget *parent, const char *name, WFlags f)
	: QWidget(parent, name, f)
{
	m_img = NULL;

	setCaption( tr("X/Qt Server") );

	setBackgroundMode( NoBackground );

	setFocusPolicy(QWidget::StrongFocus);

	setMouseTracking(true);
	setCursor(QCursor(BlankCursor));

	//QPEApplication::grabKeyboard();
}

void qtScreen::closeEvent(QCloseEvent *e)
{
	exit(0);
}


//
// Create shadow buffer
//
QImage *qtScreen::CreateShadowImage(DWORD *w, DWORD *h, int depth, void **bits, DWORD *stride)
{
	*w = width();
	*h = height();

	if (m_img == NULL) {	// Server reset ƤΤϰ
		m_img = new QImage(*w, *h, depth);
	}

	*bits = (void *)m_img->bits();

	*stride = m_img->bytesPerLine() * 8 / depth;
	
	return m_img;
}

extern "C" 
QImageP qtCreateShadowImage(DWORD *w, DWORD *h, int depth, void **bits, DWORD *stride)
{
	return (QImageP)g_screen->CreateShadowImage(w, h, depth, bits, stride);
}

//
// Handle paint event
//
void qtScreen::paintEvent(QPaintEvent *ev)
{
	if (!m_img) return;

	int x = ev->rect().left();
	int y = ev->rect().top();
	int w = ev->rect().width();
	int h = ev->rect().height();

	//printf("RedrawScreen:%d %d %d %d\n", x, y, w, h);

	QPainter p(this);
	p.drawImage(x, y, *m_img, x, y, w, h);
}

extern "C" void qtRedrawScreen(int x, int y, int w, int h)
{
	QPaintEvent *ev = new QPaintEvent(QRect(x, y, w, h));
	// called from X main thread
#ifdef	QT_THREAD_SUPPORT
	QThread::postEvent(g_screen, ev);
#else
	QApplication::postEvent(g_screen, ev);
#endif
}


//
// Handle mouse Events
//
void qtScreen::mouseButtonEvent(QMouseEvent *ev, int isPress)
{
	int button;

	setFocus();

	switch (ev->button()) {
	case LeftButton:
		button = 0;
		break;
	case RightButton:
		button = 1;
		break;
	case MidButton:
		button = 2;
		break;
	default:
		return;
	}

	qtMouseMotionSendEvent(ev->x(), ev->y());
	qtMouseButtonsSendEvent(isPress, button);

	qtPushMouseKeyEvent();
}

void qtScreen::mousePressEvent(QMouseEvent *ev)
{
	mouseButtonEvent(ev, 1);
}

void qtScreen::mouseReleaseEvent(QMouseEvent *ev)
{
	mouseButtonEvent(ev, 0);
}

void qtScreen::mouseMoveEvent(QMouseEvent *ev)
{
	qtMouseMotionSendEvent(ev->x(), ev->y());
	qtPushMouseKeyEvent();
}

//
// Handle keyboard Events
//
void qtScreen::keyPressEvent(QKeyEvent *ev)
{
	qtTranslateKey(ev, TRUE);
}

void qtScreen::keyReleaseEvent(QKeyEvent *ev)
{
	qtTranslateKey(ev, FALSE);
}
