/*
 * Qt Application/GUI thread
 *
 * Author: Takuya Murakami
 */

#include "qtapplication.h"
#include "qmessagebox.h"

#include "xqtcmn.h"
#include "qtscreen.h"

#include <stdio.h>

#ifdef	QWS
XqtApplication::XqtApplication(int &argc, char **argv)
	: QPEApplication(argc, argv)
{
}

bool XqtApplication::qwsEventFilter(QWSEvent *e)
{
	// dirty hack...
	if ( e->type == QWSEvent::Key) {
		QWSKeyEvent *ke = (QWSKeyEvent *)e;
		if (ke->simpleData.keycode == Qt::Key_Escape) {
			// avoid QPEApplication::qwsEventFilter
			return QApplication::qwsEventFilter(e);
		}
	}
	return QPEApplication::qwsEventFilter(e);
}
#endif

static XqtApplication	*g_ap;

extern "C"
void qtApInit(int argc, char *argv[])
{
	g_ap = new XqtApplication(argc, argv);

	g_screen = new qtScreen;
	g_screen->showMaximized();

	g_ap->setMainWidget(g_screen);
	g_ap->processEvents();
}

extern "C"
void qtApProcessEvents(void)
{
	g_ap->processEvents();
}

extern "C"
void qtShowFatalError(const char *msg)
{
	if (!g_ap) return;
	QMessageBox::critical(NULL, "X/Qt Server", QString(msg));
}
