#!/usr/bin/perl

#-------------------------------------
# XSI Compile Kit
# Copyright (C) 2004 Shingo Tokuoka
#-------------------------------------

if($ARGV[0] eq "-c"){
   source_generate();
}

$SRC = $ARGV[0];
$XSI_INC = "-I/usr/local/apache/include -I/home/tokuoka/mod_xsi/include";

if($SRC eq ""){
    errors("Too few auguments.");
}

if(!-f $SRC){
    errors("$SRC not found.");
}

execute("rm -f $SRC.so");
execute("gcc ".$XSI_INC." -O2 -c -o ".$SRC.".o ".$SRC);
execute("gcc -shared -fPIC -o ".$SRC.".so ".$SRC.".o");
execute("rm -f ".$SRC.".o");
exit;

sub source_generate {

$SRC = $ARGV[1];

$TMPL = <<_TMPL_;
#include "xsi.h"

/**
 * XSI load entry function
 */
XSI_ENTRY int xsi_entry(xsi_t *xsi)
{
    request_rec *r = xsi->r;
    pool *p        = xsi->r->pool;
    server_rec *s  = xsi->r->server;

    /* Sent http header  */
	xsi->r->content_type = "text/html";
	ap_send_http_header(xsi->r);

    /* Sent contens */
	ap_rprintf(xsi->r, "xsi sample page");

    /* Output Lock */
	xsi->output_lock = XSI_OUTPUT_LOCK;
	return XSI_OK;
}

_TMPL_
open(FP, "> ".$SRC) || errors("Can't create $SRC");
print FP $TMPL;
close(FP);

# open(FP, "> Makefile) || errors("Can't create Makefile);
# close(FP);

    exit;
}

sub errors {
	print shift;
	print "\n";
	exit;
}

sub execute {
	$command = shift;
	print $command."\n";
	system($command);
}

