module xsi.system;

private import std.stream;
private import std.string;
private import std.c.stdlib;


struct xsi_d
{
	char *document_root;
	char *remote_addr;
	char *request_method;
	char *remote_user;
	char *remote_passwd;
	char *request_uri;
	char *request_body;
	char *query_string;
	char *http_cookie;
	char *http_session;

	char *server_name;
	int server_port;
	char *contents;
}

template mixsi(T)
{
	extern(C)
	{
		extern void xsi_d_entry(xsi_d *Handle)
		{
			char[] contents;
			T Instance = new T();
			Instance.xsid = Handle;
			Instance.Main();
			Instance.Export();
		}
	}
}

class XSIException : Exception
{
	this(char[] msg)
	{
		super(msg);
	}
}

class XSI
{
	public:
	xsi_d *xsid;
	char[] contents;
	char[][char[]] Request;
	char[][char[]] Cookie;
	char[][char[]] Session;
	char[][char[]] Server;

	void SessionRegist(char[] Key, char[] Value)
	{
		// TODO: The processing which registers Sessions variable is created.
	}

	void CookieRegist(char[] Key, char[] Value)
	{
		// TODO: The processing which registers Cookies variable is created.
	}

	void SessionStart()
	{
		// TODO: Session start processing is created.
	}

	void CookirStart()
	{
		// TODO: Session start processing is created.
	}

	void Init()
	{
		Server["REQUEST_URI"]    = std.string.toString(xsid.request_uri);
		Server["REMOLTE_ADDR"]   = std.string.toString(xsid.remote_addr);
		Server["REQUEST_METHOD"] = std.string.toString(xsid.request_method);

		// TODO: It enables it to acquire more environment variables.

	}

	void Export()
	{
		xsid.contents = std.string.toStringz(this.contents[]);
	}

	void Main()
	{
		this.contents = "XSIBase Main OK\n";
	}

	void writeLine(char[] str)
	{
		this.contents ~= str;
	}
}
