/*
 * XgReiCu
 */

#ifndef XYZSH_LIST_H
#define XYZSH_LIST_H

#define BOOL int
#define TRUE 1
#define FALSE 0

///////////////////////////////////////////////////////////////////////
// ֐錾
///////////////////////////////////////////////////////////////////////
// 
#ifdef MDEBUG
sObject* list_new_debug_from_malloc(const char* fname, int line, const char* func_name);
#define LIST_NEW_MALLOC() list_new_debug_from_malloc(__FILE__, __LINE__, __FUNCTION__)
#else
sObject* list_new_from_malloc();
#define LIST_NEW_MALLOC() list_new_from_malloc()
#endif

sObject* list_new_from_gc(BOOL user_object);
#define LIST_NEW_GC(user_object) list_new_from_gc(user_object)

sObject* list_new_from_stack();
#define LIST_NEW_STACK() list_new_from_stack()

void list_delete_malloc(sObject* self);
void list_delete_stack(sObject* self);
void list_delete_gc(sObject* self);

int list_count(sObject* self);                      // TCY
BOOL list_empty(sObject* self);                    // 󂩂ǂ
int list_index_of(sObject* self, void* item);      // ACẽCfbNX
void list_push_front(sObject* self, void* item);   // ACeOǉ
void list_push_back(sObject* self, void* item);    // ACe납ǉ
void* list_pop_front(sObject* self);               // OACeo
void* list_pop_back(sObject* self);                // 납ACeo
void list_clear(sObject* self);                    // ACeNA

list_it* list_begin(sObject* self);                // 擪̃XgCe[^[o
list_it* list_last(sObject* self);                 // Ō̃XgCe[^[o
list_it* list_at(sObject* self, int index);        // Cӂ̏ꏊ̃XgCe[^[肾
list_it* list_find(sObject* self, void* item);     // ̃ACẽCe[^[o
void* list_item(list_it* self);                     // Ce[^[ACeo
list_it* list_next(list_it* self);                  // Ce[^[玟̃Ce[^[o
list_it* list_prev(list_it* self);                  // Ce[^[ÕCe[^[o
void list_replace(list_it* self, void* item);       // Ce[^[̃ACeu
list_it* list_erase(list_it* self, sObject* owner);    // Ce[^[̃ACe폜BITԂ
void list_insert_front(list_it* self, void* item, sObject* owner);     // Ce[^[̑OɃACeǉ
void list_insert_back(list_it* self, void* item, sObject* owner);      // Ce[^[̌ɃACeǉ

/*
    S
    
    for(list_it* i=list_begin(gList); i; i=list_next(i)) {
        sItem* item = (sItem*)list_item(i);
    }
*/

int list_gc_children_mark(sObject* self);
unsigned int list_size(sObject* self);

#endif
