<?php
//YANMAH2 - Yet ANother Mobile Accelerated HatenaHaiku
//(c) 2012 YANMAH2 project
//This program is freesoftware. you can redistribute it and/ormodify it under the terms of the [GNU Affero GPL v3](http://www.gnu.org/licenses/agpl.html).
?>
<?php defined("HELLO") or exit(); ?>
<?php
//NULL バイトの入力を弾く
function checkNull($array){
	if (is_array($array)){
		return array_map('checkNull', $array);
	}
	if (preg_match('/\0/', $array)){
		echo "NULL ぽ";
		exit();
	}
}
//正しいはてなID＝アルファベットで始まり、アルファベットか数字で終わる3文字以上､32文字以内の半角英数字
//2012-01-09: DSi の id にも対応。
function checkId($element){
	if (preg_match("/^[a-zA-Z1234567890]{1}[-_a-zA-Z1234567890@]{1,30}[a-zA-Z1234567890]{1} *$/u" ,$element) == 0){
		echo "なにそれこわい\n(YANMAH2: はてなIDの指定に関するエラー)";
		exit();
	}
}
function checkHttpUrl($element){
	if (preg_match("/^s?https?:\/\/[-_.!~*\'()a-zA-Z0-9;\/?:@&=+$,%#]+$/u", $element) == 0){
		echo ':return パラメータの値が不正の様な気がします。';
		exit();
	}
}
function checkKeyword($element){
	if (strlen(bin2hex($element)) > 511){
		echo "キーワードが長すぎて入らないです…\n(YANMAH2: キーワードの指定に関するエラー)";
		exit();
	}
}
//page=n は100までの数値であること。
function checkPagenum($element){
	if (preg_match("/^[1234567890]{1,3}$/u",$element) == 0){
		echo "数字以外入れちゃだめ\n(YANMAH2: ページ数に関するエラー)";
		exit();
	}
	if ($element > 100){
		echo "ページ数が大きすぎです…\n(YANMAH2: ページ数に関するエラー)";
		exit();
	}
}
function checkImagemode($element){
	if (!preg_match('/^(on|off)$/u', $element)){
		echo 'んっ！？　って思うパラメータは処理しないし。（YANMAH2: 画像モードに関するエラー）';
		exit();
	}
}
function checkAlbum($element){
	if (strlen(bin2hex($element)) > 514){
	echo "はうあ\n";
	exit();
}
}
function checkEntryid($element){
	if (preg_match("/^[1234567890]+$/u",$element) === FALSE){
		echo "エントリさーん、どこですかー\n(YANMAH2: Entry ID に関するエラー)";
		exit();
	}
}
function checkWord($element){
	if (strlen(bin2hex($element)) > 511){
		echo "キーワードが長すぎて入らないです…\n(YANMAH2: キーワードの指定に関するエラー)";
		exit();
	}
}
function echoHateBxml($object){
  $ret = '<dl>';
  $ret = $ret . '<dt><a href="';
  foreach ($object->link as $val){
	if ($val->attributes()->rel == 'related') $href = $val->attributes()->href;
  }
  $ret = $ret . $href;
  $ret = $ret . '" class="external-link">'.$object->title.'</a></dt>';
  $ret = $ret . '<dd>'. $object->author->name .'</dd>';
  $ret = $ret . '<dd>'. $object->summary .'</dd>';
  $ret = $ret . '<dd>'. $object->issued .'</dd>';
  $ret = $ret . '</dl>';
  return $ret;
}
function checkEntryData($data){
  $contents = simplexml_load_string($data);
  $error = libxml_get_last_error();
  if ($error !== FALSE){
	$ret['ercode'] = $error->code;
	$ret['ermes'] = $error->message;
	$ret['contents'] = $contents;
	$ret['stat'] = FALSE;
  } elseif (isset($contents->error)){
	$ret['ercode'] = 'x';
	$ret['ermes'] = $contents->error;
	$ret['contents'] = $contents;
	$ret['stat'] = FALSE;
  } else {
	$ret['contents'] = $contents;
	$ret['stat'] = TRUE;
  }
  return $ret;
}
function echoCommonHeader($bottom = '#navigation-menu', $return = ''){
  if (isset($_SESSION['auth']) && $_SESSION['auth'] === TRUE){
	$common_header = '<div id="com-hdr"><span class="header-log">　<a href="./login.php?log=out" class="navigation-link">ログアウト</a></span>　<span class="to-bottom"><a href="#navigation-menu" class="navigation-link" accesskey="#">[#]下へ</a></span></div>';
  } else {
	$common_header = '<div id="com-hdr"><span class="header-log"><a href="./login.php?return='.rawurlencode($return).'" class="navigation-link">ログイン</a></span>　<span class="to-bottom"><a href="'.$bottom.'" class="navigation-link" accesskey="#">[#]下へ</a></span></div>';
  }
  return $common_header;
}
function echoCommonFooter($top = '#page'){
  global $get_image;
  $common_footer = '<div id="com-ftr"><span class="ftr-cnf"><a href="./config.php?image='.$get_image.'" class="navigation-link">設定</a></span>　<span class="to-top"><a href="'.$top.'" class="navigation-link" accesskey="*">[*]上へ</a></span></div><hr />';
  return $common_footer;
}
function pullLot($ary = array(0, 1)){
  shuffle($ary);
  return $ary[0];
}
function echoPhotozou($photo_id, $mgw){
  $api = 'http://api.photozou.jp/rest/photo_info?photo_id='.$photo_id;
  $get_xml = getJson($api, FALSE);
  if ($get_xml['stat'] !== TRUE){
	$ret = '.';
	return $ret;
  }
  $xml = simplexml_load_string($get_xml['body']);
  $error = libxml_get_last_error();
  if ($error !== FALSE){
	$ret = '..';
  } elseif ($xml->attributes()->stat != 'ok'){
	$ret = '...';
  } else {
	$thumb = $xml->info->photo->thumbnail_image_url;
	$title = $xml->info->photo->photo_title;
	$desc = $xml->info->photo->description;
	$ret = "<img src=\"{$mgw}".rawurlencode($thumb)."\" alt=\"{$desc}\" />";
  }
  libxml_clear_errors();
  return $ret;
}
?>
<?php
function getRequest($init_url, $callback_url, $scope, $conkey, $conkey_sec){
  global $user_agent;
  try{
  require_once 'HTTP/OAuth/Consumer.php';
  $oauth_con = new HTTP_OAuth_Consumer($conkey, $conkey_sec);
  $req = new HTTP_Request2();
  $req->setConfig('ssl_verify_peer', false);
  $req->setHeader('User-Agent', $user_agent);
  $con_req = new HTTP_OAuth_Consumer_Request;
  $con_req->accept($req);
  $oauth_con->accept($con_req);
  $oauth_con->getRequestToken($init_url, $callback_url, array('scope' => $scope));
  $ret = array();
  $ret['token'] = $oauth_con->getToken();
  $ret['secret'] = $oauth_con->getTokenSecret();
  $ret['stat'] = TRUE;
  } catch(Exception $e){
  $ret['error'] = $e->getMessage();
  $ret['stat'] = $ret['error'];
  }
  return $ret;
}
function getAccess($token_url, $reqtoken, $req_sec, $verifier, $conkey, $conkey_sec){
  global $user_agent;
  try{
  require_once 'HTTP/OAuth/Consumer.php';
  $oauth_con = new HTTP_OAuth_Consumer($conkey, $conkey_sec, $reqtoken, $req_sec);
  $req = new HTTP_Request2();
  $req->setConfig('ssl_verify_peer', false);
  $req->setHeader('User-Agent', $user_agent);
  $con_req = new HTTP_OAuth_Consumer_Request;
  $con_req->accept($req);
  $oauth_con->accept($con_req);
  $oauth_con->getAccessToken($token_url, $verifier);
  $lastreq = $req->getLastEvent();
  $res = $lastreq['data'];
//   $ret['ob'] = $oauth_con;
  $ret['token'] = $oauth_con->getToken();
  $ret['secret'] = $oauth_con->getTokenSecret();
  $ret['body'] = $res->getBody();
  $ret['stat'] = TRUE;
  } catch(Exception $e){
  $ret['trace'] = $e->getTrace();
  $ret['error'] = $e->getMessage();
  $ret['stat'] = $ret['error'];
  }
  return $ret;
}
function getJson($get_url, $use_oauth, $conkey = '', $conkey_sec = '', $acskey = '', $acskey_sec = ''){
global $user_agent;
if ($use_oauth === TRUE){
  try {
	require_once 'HTTP/OAuth/Consumer.php';
	$oauth_con = new HTTP_OAuth_Consumer($conkey, $conkey_sec);
	$req = new HTTP_Request2();
	$req->setConfig('ssl_verify_peer', false);
	$req->setHeader('User-Agent', $user_agent);
	$con_req = new HTTP_OAuth_Consumer_Request;
	$con_req->accept($req);
	$oauth_con->accept($con_req);
	$oauth_con->setToken($acskey);
	$oauth_con->setTokenSecret($acskey_sec);
	$res = $oauth_con->sendRequest($get_url);
	$ret['http'] = $res->getStatus();
	$ret['body'] = $res->getBody();
	$ret['stat'] = TRUE;
  } catch (Exception $e){
	$ret['stat'] = $e->getMessage();
  }
  return $ret;
} else {
  try {
	require_once "HTTP/Request2.php";
	$req = new HTTP_Request2($get_url);
	$req->setHeader('User-Agent', $user_agent);
	$res = $req->send();
	$ret['http'] = $res->getStatus();
	$ret['body'] = $res->getBody();
	$ret['stat'] = TRUE;
  } catch (Exception $e){
	$ret['stat'] = $e->getMessage();
  }
  return $ret;
}
}
function postGeneric($api, $postdata = array(), $conkey, $conkey_sec, $acskey, $acskey_sec, $body = ''){
  global $user_agent;
  try {
	require_once 'HTTP/OAuth/Consumer.php';
	$oauth_con = new HTTP_OAuth_Consumer($conkey, $conkey_sec);
	$req = new HTTP_Request2();
	$req->setConfig('ssl_verify_peer', false);
	$req->setHeader('User-Agent', $user_agent);
	if ($body != '') $req->setBody($body);
	$con_req = new HTTP_OAuth_Consumer_Request;
	$con_req->accept($req);
	$oauth_con->accept($con_req);
// 	$oauth_con->setSignatureMethod("HMAC-SHA1");
	$oauth_con->setToken($acskey);
	$oauth_con->setTokenSecret($acskey_sec);
	$res = $oauth_con->sendRequest($api, $postdata, "POST");
	$ret['http'] = $res->getStatus();
// 	var_dump($http);
	$ret['body'] = $res->getBody();
// 	$ret['session'] = $_SESSION;
	$ret['stat'] = TRUE;
  } catch (Exception $e){
	$ret['error'] = $e->getMessage();
// 	$ret['session'] = $_SESSION;
	$ret['stat'] = FALSE;
  }
  return $ret;
}
?>
