public

# app/assets/images 以下のファイルの内容を得る
def asset_image_data(filename)
	filename = File.absolute_path(File.join("app/assets/images", filename), Rails.root)
	return File.binread(filename)
end

# 有効な仮想パスか(ファイルが存在するか)判定する
def valid_vpath?(vpath)
	return true  if vpath.root?		# rootならT

	return true  if vpath.v.is_any_of("*read", "*bookmark", "*tag") # TODO:*read, *bookmark, *tag の処理

	case Book.type(vpath)
	 when :images
		dir = File.dirname(vpath.r)
		return true  if File.directory?(dir)	# imagesの場合、ディレクトリが実在すればT
	 else
		return true  if File.exist?(vpath.r)	# 実在すればT (ファイルでもディレクトリでもT)
	end

	return false
end

# 有効なディレクトリのパスか判定する
def valid_directory_path?(vpath)
	return true  if vpath.root?
	return false  if !valid_vpath?(vpath)
	return true  if File.directory?(vpath.r)
	return false
end

# 有効な本のパスか判定する
def valid_book_path?(vpath)
	return false  if vpath.root?
	return false  if !valid_vpath?(vpath)
	case Book.type(vpath)
	 when nil
		return false
	 when :images
		dir = File.dirname(vpath.r)
		return true  if File.directory?(dir)
	 else
		return true  if File.file?(vpath.r)
	end

	return false
end

# 有効な頁のパス/locationか判定する
# 頁の実在チェックはしていない
def valid_page_path?(vpath, location)
	return false  if !valid_book_path?(vpath)
	return false  if location.blank?
	return true
end

########################################################################

# イメージファイルしかないディレクトリかどうか判定する
# イメージファイルがあり、他のファイル・ディレクトリがなければtrueを返す
# イメージファイル以外が存在するか、ディレクトリが空の場合はfalseを返す
def image_only_dir?(vpath)
	rpath = vpath.r
	return false  if rpath.blank?

	images_count = 0
	Dir.foreach(rpath) do |entry|
		if entry.start_with?(".")
			# NOP
		else
			path = File.join(rpath, entry)
			if File.directory?(path)
				return false
			elsif extname_match?(YOMEYA_ALL_EXT, entry)
				if extname_match?(YOMEYA_IMAGE_EXT, entry)
					images_count += 1
				else
					return false
				end
			end
		end
	end

	return (images_count > 0) ? true : false
end

########################################################################

# ある本のある頁までを読んだことを宣言する
def update_page_read(vpath, location)
	last_path = session[:last_path]
	if last_path != vpath.v # pathが変化した場合、last_path_fromも更新
		session[:last_path] = vpath.v
		session[:last_path_from] = last_path
	end
	session[:last_location] = location

	User.transaction do
		user = User.find(vpath.u)
		user.last_path = vpath.v
		user.last_location = location
		user.save!

		reading = Reading.yomeya_find_or_new(vpath)
		last_page = Book(vpath).pagelist.last
		now = Time.now
		reading.location = location
		reading.start_at = now  if reading.start_at.blank?
		reading.touch_at = now
		reading.end_at = now  if reading.end_at.blank? && location == last_page
		reading.save!

		Log.add(vpath.u, "Moveto: [#{vpath.v}] [#{location}]")
	end
end

# ファイルリストを表示したことを宣言する
def update_filelist_visit(vpath, location)
	last_path = session[:last_path]
	if last_path != vpath.v # 前回と異なるpathに移動した場合、last_path_fromも更新
		session[:last_path] = vpath.v
		session[:last_path_from] = last_path
	end
	session[:last_location] = location

	User.transaction do
		user = User.find(vpath.u)
		user.last_path = vpath.v
		user.last_location = location
		user.save!

		Cache.store_location(vpath, location)

		Log.add(vpath.u, "Moveto: [#{vpath.v}]")
	end
end

########################################################################

class ApplicationController < ActionController::Base
	protect_from_forgery with: :null_session

 protected
	# 認証済かをチェック
	def auth_check
		return  if params[:controller] == "auth"
		redirect_to(auth_path)  if session[:user_id].blank?
	end
	before_action :auth_check

end
