class PageController < ApplicationController

private
	# 画像データをサイズ調整して返す
	def treat_blob(data)
		return nil  if data.blank?

		# iOS端末は画像に最大サイズがあるので大きかったら縮小する
		if session[:ua_type].include?(:ios)
			# オブジェクトを生成し画像のサイズを得る
			imagelist = Magick::ImageList.new.from_blob(data)
			width = imagelist.columns
			height = imagelist.rows
			aspect_ratio = Rational(width, height)

			# 縮小せずに表示可能な最大サイズを得る
			max_pixels = 2000000
			max_width = Math.sqrt(max_pixels * aspect_ratio)
			max_height = max_width / aspect_ratio
			max_width = max_width.to_i
			max_height = max_height.to_i

			# 最大サイズより大きければ縮小
			if width > max_width || height > max_height
				imagelist.each do |image|
					image.resize_to_fit!(max_width, max_height)
				end
				data = imagelist.to_blob
			end
		end

		return data
	end

public
	def get
		vpath = Vpath(session[:user_id], params[:path] || "")
		location = Vpath.reg_location(params[:location] || "")

		# パラメータの検査
		if !valid_page_path?(vpath, location)
			return render(nothing:true, status:400)
		end

		r = treat_blob(Book(vpath).extract(location))
		if r.present?
			return send_data(r, type:"image", disposition:"inline")
		end

		redirect_to(view_context.image_path("icon_file_missing.png"))
	end
end
