class ViewerController < ApplicationController

 public
	def show
		vpath = Vpath(session[:user_id], params[:path] || "")
		location = Vpath.reg_location(params[:location] || "")

		# パラメータの検査
		if !valid_book_path?(vpath)
			return redirect_to(filelist_path)
		end
		@vpath = vpath

		# 頁一覧を得る
		pagelist = Book(vpath).pagelist
		if pagelist.empty?
			return redirect_to(last_path)
		end
		@pagelist = pagelist

		# 位置の指定がない場合、前回読んでいた場所を得る(初めてなら、先頭から)
		if location.blank?
			reading = Reading.yomeya_find(vpath)
			location = reading ? reading.location : pagelist.first
		end
		@location = location

		# 現在位置を更新
		update_page_read(vpath, location)
	end

	# 頁移動したことを宣言(ajax用)
	# locationだと内部で使われているシンボルと被る
	def loc
		vpath = Vpath(session[:user_id], params[:path] || "")
		location = Vpath.reg_location(params[:location] || "")

		# パラメータの検査
		if !valid_page_path?(vpath, location)
			return render(nothing:true, status:400)
		end

		update_page_read(vpath, location)
		render(nothing:true)
	end

end
