class Cache < ActiveRecord::Base

 private
	ICON = 0
	PAGELIST = 1
	LOCATION = 2

	# キャッシュを探す なければブロックを実行してキャッシュに保存(ブロック無ければnil)
	def self.fetch(itemtype, vpath, location=nil, &block)
		location = location.present? ? location.to_s : ""
		data = nil
		if true # trueでキャッシュ有効
			rs = find_by(user_id:vpath.u, itemtype:itemtype, path:vpath.v, location:location)
			if rs
				data = rs.data
				rs.access_at = Time.now
				rs.save!
			elsif block_given?
				data =  block.call
				create!(
					user_id: vpath.u,
					itemtype: itemtype,
					path: vpath.v,
					location: location,
					data: data,
					access_at: Time.now,
				)
			end
		else # キャッシュ無効
			data =  block.call  if block_given?
		end
		return data
	end

	# キャッシュを破棄
	def self.dirty(itemtype, vpath, location)
		transaction do
			rs = where(user_id:vpath.u, itemtype:itemtype, path:vpath.v, location:location)
			rs.each { |r| r.destroy! }
		end
	end

 public
 	# 当該ユーザのキャッシュを全クリア
	def self.do_clear(user_id, path=nil, location=nil)
		transaction do
			if path.blank? && location.blank?
				delete_all(user_id:user_id)
			elsif location.blank?
				delete_all(user_id:user_id, path:path)
			else
				delete_all(user_id:user_id, path:path, location:location)
			end
		end
	end

	# キャッシュの保存期限切れ処理
	def self.do_expire(user_id)
		transaction do
			where(user_id:user_id).delete_all(["access_at < ?", 20.day.ago])
		end
	end

	# アイコン用キャッシュ
	def self.fetch_icon(vpath, location=nil, &block)
		return fetch(ICON, vpath, location, &block)
	end

	# 頁リスト用キャッシュ
	def self.fetch_pagelist(vpath, &block)
		if block_given?
			r = fetch(PAGELIST, vpath) do
				YAML.dump(block.call)
			end
		else
			r = fetch(PAGELIST, vpath)
		end
		return r ? YAML.load(r) : nil
	end

	# 表示位置用キャッシュ
	def self.fetch_location(vpath)
		r = fetch(LOCATION, vpath)
		return r.nil? ? nil : r.to_i
	end

	# 表示位置用キャッシュ(格納)
	def self.store_location(vpath, location)
		location = location.present? ? location.to_s : ""

		rs = find_by(user_id:vpath.u, itemtype:LOCATION, path:vpath.v, location:"")
		if !rs
			rs = new(
				user_id: vpath.u,
				itemtype: LOCATION,
				path: vpath.v,
				location: "",
			)
		end
		rs.data = location
		rs.access_at = Time.now
		rs.save!
	end

end
