<?php
//
// $Id: chat.inc,v 1.1.1.2 2003/01/09 22:18:54 nanasess Exp $
//
// 椤äPostgreSQL + PHP4
// ɽӡ񤭹 Chat饹
// 
// PostgreSQL 7.2ʹߡPHP 4.2.0ʹ
// ʤΥСǤưԲ)
//
// Copyright (C) 2002-2003 Kentaro Ohkouchi
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
//    this list of conditions and the following disclaimer.
//    Redistributions  in  binary  form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
//
// WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
// EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
// OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
// OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
// OF THE POSSIBILITY OF SUCH DAMAGE.
//

/**
 * Chat饹
 *
 * @package Yuichat-p
 * @version $Revision: 1.1.1.2 $
 * @author Kentaro Ohkouchi <nanasess@fsm.ne.jp>
 */
class Chat 
{
 
    // {{{ propaties
    
    /**
     * Ƽꥯ饹
     * @var string $PrefClass
     */
    var $PrefClass = "myChatPref";
    
    /**
     * ³楯饹
     * @var string $db
     */
    var $db = "myDB_Sql";
    
    /**
     * include_path
     * @var string $include_path
     */
    var $include_path = "./include";
    
    /**
     * åȥΥơ֥̾
     * @var string $LogTableName
     */
    var $LogTableName = "chat_log";
    
    /**
     * üԥơ֥̾
     * @var string $SankaTableName
     */
    var $SankaTableName = "chat_sanka";
    
    /**
     * Υƥ९饹
     * @var string $NewComer
     */
    var $NewComer = "NewComer";
    
    /**
     * ͤ̾
     * @var string $Master
     */
    var $Master = "";
    
    /**
     * ͤʸ
     * @var string $MasterColor
     */
    var $MasterColor = "#0000FF";
    
    /**
     * ͤΥ᡼
     * @var string $MasterEmail
     */
    var $MasterEmail = "http://www.goo.ne.jp/";
    
    /**
     * ǥեȹԿ
     * @var integer $limit
     */
    var $limit = 10; // ǥեȹԿ
    
    // }}}
    // {{{  Constructor
    
    function Chat()
    {
        if (empty($_SESSION["RD"])) {
            $_SESSION["RD"] = 30;
        }
        if (empty($_SESSION["R"])) {
            $_SESSION["R"] = $_SESSION["RD"];
        }
        if (empty($_POST["W"])) {
            $_POST["W"] = $this->limit;
        }
        if (empty($_POST["chat"])) {
            $_POST["chat"] = "";
        }
        if (empty($_POST["L"])) {
            $_POST["L"] = "";
        }
        if (empty($_POST["S"])) {
            $_POST["S"] = "";
        }
        if (empty($_POST["B"])) {
            $_POST["B"] = "";
        }
        if (empty($_POST["A"])) {
            $_POST["A"] = "";
        }
        if (empty($_POST["escape"])) {
            $_POST["escape"] = 0;
        }
        if (empty($_POST["BL"])) {
            $_POST["BL"] = 0;
        }
        if (empty($_POST["CL"])) {
            $_POST["CL"] = 0;
        }
    }
    
    /**
     * ɻ
     *
     * @return void
     * @access public
     */
    function reload()
    {
        if (empty($_SESSION["RD"])) {
            $_SESSION["RD"] = 30;
        }
        if ($_SESSION["R"] < 30) {
            // ǥե
            $_SESSION["R"] = $_SESSION["RD"];
        } elseif ($_SESSION["R"] >= 30) {
            if ($_SESSION["R"] > 300) {
                // ֥ɤʤȥ
                $_SESSION["R"] = 60*60*24;
            } else {
                // ȯʤȥɲû
                $_SESSION["R"] = $_SESSION["R"] + 5;
            }
        } else {
            // ǥե
            $_SESSION["R"] = $_SESSION["RD"];
        }
    }
    
    /**
     * ȥ
     *
     * @return void
     * @access public
     */
    function autoReloadLog()
    {
        $R = $this->reload();
        printf("<meta http-equiv=\"Refresh\" content=\"%d; URL=%s\" />\n",
               $_SESSION["R"] - 5, $_SERVER["PHP_SELF"]);
    }

    /**
     * ɥ
     *
     * @return void
     * @access public
     */
    function reloadLog()
    {
        $clock = date("H:i");
        printf("<a href=\"%s\">[%s]</a>",
               $_SERVER["PHP_SELF"], $clock);
    }

    /**
     * üɽ
     * 
     * @return void
     * @access public
     */
    function sanka()
    {
        $db = new $this->db;
        $db3 = new $this->db;
        $db4 = new $this->db;
        $nChat = new $this->PrefClass;
       
        $host = $_SERVER["REMOTE_ADDR"];
        if (empty($_SESSION["N"])) {
            $N = $host;
        } else {
            $N = $_SESSION["N"];
        }
       
        // 90÷вᤷΤϺ
        $sql0 = sprintf("DELETE FROM %s WHERE timerec < now() + '- 90 second'",
                        $this->SankaTableName);
      
        // ۥȤϺ
        $sql1 = sprintf("DELETE FROM %s WHERE host = '%s'",
                        $this->SankaTableName, addslashes($host)); // ۥȤϺ
        
        // ǡ
        $sql2 = sprintf("INSERT INTO %s (name, color, host, agent) ", $this->SankaTableName);
        $sql2 .= sprintf("VALUES ('%s', ", addslashes($N));
        $sql2 .= sprintf("'%s', ", addslashes(isset($_SESSION["color"]) ? $_SESSION["color"] : ""));
        $sql2 .= sprintf("'%s', ", addslashes($host));
        $sql2 .= sprintf("'%s')", addslashes($_SERVER["HTTP_USER_AGENT"]));
       
        // üԥȥ
        $sql3 = sprintf("SELECT count(*) FROM %s WHERE NOT name ~ '^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$'",
                        $this->SankaTableName, addslashes($N));
       
        // üɽ
        $sql4 = sprintf("SELECT name, color FROM %s WHERE NOT name ~ '^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$'",
                        $this->SankaTableName, addslashes($N));
        
        $sql = array($sql0, $sql1, $sql2, $sql3, $sql4);
        $result = array();
        for ($i=0; $i < 5; $i++) {
            if ($i == 3) {
                $result[$i] = $db3->dbObj->getOne($sql[$i]);
            } elseif ($i == 4) {
                $result[$i] = $db4->dbObj->query($sql[$i]);
            } else {
                $result[$i] = $db->dbObj->query($sql[$i]);
            }
            if (DB::isError($result[$i])) {
                print($result[$i]->getMessage());
                $db->dbObj->query("ROLLBACK");
                return exit;
            }
        }
      
        printf("ü(%d)",
               $result[3]); // üԿɽ
       
        while ($row = $result[4]->fetchRow(DB_FETCHMODE_ASSOC)) {
            printf("<span style=\"color: %s\">%s</span>",
                   htmlspecialchars($row["color"], ENT_QUOTES),
                   htmlspecialchars($row["name"], ENT_QUOTES));
        }
    }

    /**
     * 
     *
     * @return bool
     * @access public
     */
    function enterLog()
    {
        require_once $this->include_path . "/newcomer.inc";
        $db = new $this->db;
        $comer = new $this->NewComer;
        $nChat = new $this->PrefClass;
       
        $N = $_SESSION["N"];
        $agent = $_SERVER["HTTP_USER_AGENT"];
        $host = $nChat->getHost();
        if (isset($_POST["color2"]) && $_POST["color2"] != "") {
            $color = $_POST["color2"];
        } else {
            $color = $_SESSION["color"];
        }
       
        // 90÷вᤷΤϺ
        $sql0 = sprintf("DELETE FROM %s WHERE timerec < now() + '- 90 second'",
                        $this->SankaTableName);
       
        // ۥȤϺ
        $sql1 = sprintf("DELETE FROM %s WHERE host = '%s'",
                        $this->SankaTableName, addslashes($host)); // ۥȤϺ
       
        // ǡ
        $sql2 = sprintf("INSERT INTO %s (name, color, host, agent) ", $this->SankaTableName);
        $sql2 .= sprintf("VALUES ('%s', ", addslashes($N));
        $sql2 .= sprintf("'%s', ", addslashes(isset($_SESSION["color"]) ? $_SESSION["color"] : ""));
        $sql2 .= sprintf("'%s', ", addslashes($host));
        $sql2 .= sprintf("'%s')", addslashes($_SERVER["HTTP_USER_AGENT"]));
       
        // üԥȥ
        $sql3 = sprintf("SELECT count(*) FROM %s WHERE NOT name ~ '^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$'",
                        $this->SankaTableName, addslashes($N));
       
        // üɽ
        $sql4 = sprintf("SELECT name, color FROM %s WHERE NOT name ~ '^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$'",
                        $this->SankaTableName, addslashes($N));

        $sql = array($sql0, $sql1, $sql2, $sql3, $sql4);
        $result = array();
        for ($i=0; $i < 5; $i++) {
            if ($i == 3) {
                $result[$i] = $db3->dbObj->getOne($sql[$i]);
            } elseif ($i == 4) {
                $result[$i] = $db4->dbObj->query($sql[$i]);
            } else {
                $result[$i] = $db->dbObj->query($sql[$i]);
            }
            if (DB::isError($result[$i])) {
                print($result[$i]->getMessage());
                $db->dbObj->query("ROLLBACK");
                return exit;
            }
        }
      
        printf("ü(%d)",
               $result[3]); // üԿɽ
       
        while ($row = $result[4]->fetchRow(DB_FETCHMODE_ASSOC)) {
            printf("<span style=\"color: %s\">%s</span>",
                   htmlspecialchars($row["color"], ENT_QUOTES),
                   htmlspecialchars($row["name"], ENT_QUOTES));
            $enter_log = sprintf("<span style=\"font-size: 18px; color: %s\">%s</span><span style=\"color: #FF0000\">󡢤Ǥ䤹 %s</span>%s",
                                 $color,
                                 htmlspecialchars($_SESSION["N"], ENT_QUOTES),
                                 htmlspecialchars($_SERVER["HTTP_USER_AGENT"], ENT_QUOTES),
                                 isset($_SESSION["history"]) ? $_SESSION["history"] : "");
            $insert = sprintf("INSERT INTO %s (name, email, color, log_agent, log_host, log) ", $this->LogTableName);
            $insert .= sprintf("VALUES ('%s', ", addslashes($this->Master));
            $insert .= sprintf("'%s', ", addslashes($this->MasterEmail));
            $insert .= sprintf("'%s', ", addslashes($this->MasterColor));
            $insert .= sprintf("'%s', ", addslashes($_SERVER["HTTP_USER_AGENT"]));
            $insert .= sprintf("'%s', ", addslashes($host));
            $insert .= sprintf("'%s')", addslashes($enter_log)); 
        }
        $result = $db->dbObj->query($insert);
        if (DB::isError($result)) {
            print($result->getMessage());
            $db->dbObj->query("ROLLBACK");
            return exit;
        }
    }


    /**
     * ༼
     *
     * @return bool
     * @access public
     */
    function outLog()
    {
        $db = new $this->db;
        $nChat = new $this->PrefClass;
        $host = $nChat->getHost();
	
        $out_log = sprintf("<span style=\"font-size: 18px; color: %s\">%s</span><span style=\"color: #FF0000\">󡢤ޤƤ䤹</span>",
                           htmlspecialchars($_SESSION["color"], ENT_QUOTES),
                           htmlspecialchars($_SESSION["N"], ENT_QUOTES));
	
        $delete = sprintf("DELETE FROM %s WHERE host = '%s'",
                          $this->SankaTableName, addslashes($host));
        $insert = sprintf("INSERT INTO %s (name, email,color, log_agent, log_host, log) VALUES (", $this->LogTableName);
        $insert .= sprintf("'%s', ", addslashes($this->Master));
        $insert .= sprintf("'%s', ", addslashes($this->MasterEmail));
        $insert .= sprintf("'%s', ", addslashes($this->MasterColor));
        $insert .= sprintf("'%s', ", addslashes($_SERVER["HTTP_USER_AGENT"]));
        $insert .= sprintf("'%s', ", addslashes($host));
        $insert .= sprintf("'%s')", addslashes($out_log));
        
        $sql = array($delete, $insert);
        $result = array();
        
        for ($i=0; $i < 2; $i++) {
            $result[$i] = $db->dbObj->query($sql[$i]);
            if (DB::isError($result[$i])) {
                print($result->getMessage());
                $db->dbObj->query("ROLLBACK");
                return exit;
            }
        }
        if ($_SESSION["cook"] == 0) { // å¸ʤ˴
            session_unset();
        }
        return true;
    }
	
    /**
     * 񤭹
     *
     * @return bool
     * @access public
     */
    function writeLog()
    {
        $db = new $this->db;
        $nChat = new $this->PrefClass;
        $host = $nChat->getHost();
        
        $_SESSION["escape"] = $_POST["escape"];
        $_SESSION["BL"] = $_POST["BL"];
        $_SESSION["B"] = $_POST["BL"];
        $_SESSION["CL"] = $_POST["CL"];
        $chat = $this->LogClear($_POST["chat"]); // ȯưõ
        $chat = $this->TagAutoClose($chat); // ưõ
        $chat = $this->EscapeTag($chat); // ػߥ
        
        if ($_SESSION["escape"] == 1) {
            if ($_SESSION["N"] != $this->Master) { // 
                $chat = htmlspecialchars($chat, ENT_QUOTES);
            }
        }
        if ($_SESSION["DX"] == 1) { // DX⡼
            $chat = sprintf("<font size=\"%d\" style=\" color: %s\">%s</font>",
                            $_POST["SZ"], $_SESSION["CL"], $chat);
        }
        if ($_SESSION["BL"] == 1) { // ٻ
            $chat = sprintf("</strong>%s", $chat);
        }
        if ($_POST["emoji"] == "(==)") {
            $_POST["emoji"] = "(<span style=\"color: #FF0000\">=</span><span style=\"color: #FF0000\">=</span>)";
        }
        $insert = sprintf("INSERT INTO %s (name, email, color, log_agent, log_host, log) ", $this->LogTableName);
        $insert .= sprintf("VALUES ('%s', ", addslashes($_SESSION["N"]));
        $insert .= sprintf("'%s', ", addslashes($_SESSION["email"]));
        $insert .= sprintf("'%s', ", addslashes($_SESSION["color"]));
        $insert .= sprintf("'%s', ", addslashes($_SERVER["HTTP_USER_AGENT"]));
        $insert .= sprintf("'%s', ", addslashes($host));
        $insert .= sprintf("'%s ", addslashes($chat));
        $insert .= sprintf("%s') ", addslashes($_POST["emoji"]));
		
        $result = $db->dbObj->query($insert);
        if (DB::isError($result)) {
            print($result->getMessage());
            $db->dbObj->query("ROLLBACK");
            return exit;
        }
        return true;
    }
    
    /**
     * clearǽ
     *
     * @return string åȥ֤
     * @params string $chat    åȥ
     * @access private
     */
    function logClear($chat) {
        $db = new $this->db;
        $N = $_SESSION["N"];
        $email = $_SESSION["email"];
        $color = $_SESSION["color"];
        $W = $_SESSION["W"];
        
        if ($chat == "cut" || $chat == "clear") {
            $last_value = sprintf("count >= (SELECT last_value FROM %s_count_seq) - 300",
                                  $this->LogTableName);
            if ($chat == "cut") { // cutȯ顢imgɽ
                $update = sprintf("UPDATE %s SET views = 'f' WHERE %s AND log ~ 'img'",
                                  $this->LogTableName, $last_value);
            } elseif ($chat == "clear") { // clearȯ鼫ʬȯõ
                $update = sprintf("UPDATE %s SET views = 'f' WHERE %s AND name = '%s'",
                                  $this->LogTableName, $last_value, $_SESSION["N"]);
            }
            $result = $db->dbObj->query($update);
            if (DB::isError($result)) {
                print($result->getMessage());
                $db->dbObj->query("ROLLBACK");
                return exit;
            }
            $chat = "";
            return $chat;
        } else {
            return $chat;
        }
    }
    
    /**
     * 
     *
     * @return void
     * @access public
     */
    function getLogData()
    {
        $nChat = new $this->PrefClass;
        
        $_SESSION["W"] = $_POST["W"];
        if (isset($_GET["W"]) && $_GET["W"] != "") {
            $limit = $_GET["W"];
        } elseif ($_SESSION["W"] == 0 || $_SESSION["W"] == "") {
            $limit = $this->limit; // ǥեȹԿ
        } else {
            $limit = $_SESSION["W"];
        }
        
        $_SESSION["L"] = $_POST["L"];
        $_SESSION["S"] = $_POST["S"];
        $_SESSION["B"] = $_POST["B"];
        $_SESSION["A"] = $_POST["A"];	  
        
        $sql1 = "to_char(timerec, 'MM') AS mon"; // 
        $sql2 = "to_char(timerec, 'DD') AS day"; // 
        $sql3 = "to_char(timerec, 'D') AS d"; // ֹ
        $sql4 = "to_char(timerec, 'HH24:MI') AS times"; // ּ
        $select = sprintf("SELECT *, %s, %s, %s, %s FROM %s WHERE views = 't' ORDER BY count DESC LIMIT %d",
                          $sql1, $sql2, $sql3, $sql4, $this->LogTableName, $limit);
        
        $db = new $this->db;		
        $result = $db->dbObj->query($select);
        if (DB::isError($result)) {
            print($result->getMessage());
            $db->dbObj->query("ROLLBACK");
            return exit;
        }
        $i = 0;
        while ($row = $result->fetchRow(DB_FETCHMODE_ASSOC)) {
            $name = htmlspecialchars($row["name"], ENT_QUOTES);
            $color = htmlspecialchars($row["color"], ENT_QUOTES);
            $email = htmlspecialchars($row["email"], ENT_QUOTES);
            $log = $row["log"];
            $mon = (int)($row["mon"]);
            $date = (int)($row["day"]);
            $d = $row["d"];
            $times = $row["times"];
            $host = $row["log_host"];
            $target = "target=\"_blank\"";
            
            if ($_SESSION["L"] == "1") { // Ķץ⡼
                printf("<hr />\n%s |&gt; %s\n",
                       $name, preg_replace("/<[\/\!]*?[^<>]*?>/si", "", $log));
            } else { // ̾⡼
                $day = $nChat->GetDay();
                
                if ($_SESSION["S"] == "1") { // ̵
                    if ($name != $this->Master) {
                        $log = preg_replace("/<[\/\!]*?[^<>]*?>/si", "", $log);
                    }
                }
                $log_date = sprintf("%d/%d(%s) %s",
                                    $mon, $date, $day[$d], $times);
                $i++;
                
                print("<hr />\n");
                printf("<strong style=\"color: %s\">%s</strong>",
                       $color, $name);
                if ($email == "") {
                    print(" |&gt; "); // ᡼󥯤ʤ
                } elseif (preg_match("/^http.*$/e", $email)) {
                    printf(" <a href=\"%s\" %s>|&gt;</a> ", 
                           $email, $target); // URL
                } else {
                    printf(" <a href=\"mailto:%s\">|&gt;</a> ", $email); // ¾ϥ᡼
                }
                if ($_SESSION["B"] == "1") { // ٻɽ
                    printf("%s", $log);
                } else {
                    printf("<strong>%s</strong>", $log);
                }
                
                if ($_SESSION["A"] == "1" || $i < 5) { // ɽ
                    printf(" <span class=\"logtime\">(%s %s)</span>\n",
                           $log_date, $host);
                }
            }
        }
    }

    /**
     * ưĤǽ
     *
     * @return string    åȥ֤
     * @params string $chat   åȥ
     * @access private
     */
    function tagAutoClose($chat)
    {
        $close_tag = "";        
        $tags = preg_split("/</", $chat);
        $dmy = array_shift($tags);
        
        foreach($tags as $tag) {
            preg_match("/^[a-zA-Z0-9]+/is", $tag, $key);
            $close_tag .= sprintf("</%s>", $key[0]);
        }
        $tags = preg_replace("'([^>]*)>(.*)'si", "", $tags);
        $tags = preg_replace("'^\/(.*)'si", "", $tags);
        $tags = preg_replace("'^([^\s]*).*'si", "" ,$tags);
        
        if (preg_match("/<\/$/", $chat)) {
            $chat .= ">";
        }

        $chat .= $close_tag;
        return $chat;
    }
   		
    /**
     * ػߥ
     *
     * @return string   åȥ֤
     * @params string $chat    åȥ
     * @access private
     */
    function escapeTag($chat)
    {
        
        $search = array("'<pre'i",
                        "'<meta'i",
                        "'<body'i",
                        "'<applet'i",
                        "'<script'i",
                        "'<.*width'i",
                        "'<noscript'i",
                        "'<embed'i",
                        "'<.*height'i",
                        "'<title'i",
                        "'<!--'i",
                        "'<.*mailbox:'",
                        "'<server'i",
                        "'<.*cols'i",
                        "'<.*rows'i",
                        "'<plain'i",
                        "'<.*font-size'i",
                        "'<img.*\?'i");
        $replace = array("",
                         "",
                         "",
                         "",
                         "",
                         "",
                         "",
                         "",
                         "",
                         "",
                         "",
                         "",
                         "",
                         "",
                         "",
                         "",
                         "",
                         "");
        
        $chat = preg_replace($search, $replace, $chat);
        if (preg_match("/<a.*href/i", $chat) && (preg_match("/<a.*\".*\".*>.*<\/a>/i", $chat) == false)) {
            $chat .= "\">顼</a>";
        }
        $chat = preg_replace("'<a href='i", "<a target=\"_blank\" href=", $chat);
        $chat = preg_replace("'<.*(img|href).*on.*='i", "TagError?", $chat);
        
        if (preg_match("/<.*(img|a)/i", $chat) == false) {
            $chat = preg_replace("/(http:\/\/[\w\$\#\~\.\/\-\?\=\&\:\%]+)/i", // URLư
                                 "<a href=\"$1\" target=\"_blank\">$1</a>", 
                                 $chat);
        }
        return $chat;
}
   
    /**
     * ɽ
     *
     * @return void
     * @access public
     */
    function printFooter()
    {
        /* ɽѹԲġ*/
        $copyright = "<a target=\"_blank\" href=\"http://www.cup.com/yui/\">椤ä</a> ";
        $copyright .= "<a target=\"_blank\" href=\"http://sourceforge.jp/projects/yuichat-p/\">+ nanase!!CGI</a><br />\n";
        $copyright .= "PostgreSQL + PHP4 edition";
        /* ɽޤ */
        
        printf("<hr />\n<h5 style=\"text-align: right\">%s</h5>\n", $copyright);
    }
}
?>
