<?php
//
// $Id: sql.inc,v 1.1.1.4 2003/01/09 21:47:53 nanasess Exp $
//
// 椤äPostgreSQL + PHP4
// ǡ١³ DB_Sql饹
// 
// PostgreSQL 7.2ʹߡPHP 4.2.0ʹ
// ʤΥСǤưԲ)
//
// Copyright (C) 2002-2003 Kentaro Ohkouchi
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
//    this list of conditions and the following disclaimer.
//    Redistributions  in  binary  form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
//
// WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
// EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
// OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
// OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
// OF THE POSSIBILITY OF SUCH DAMAGE.
//

/**
 * ǡ١³饹
 *
 * @package Yuichat-p
 * @version $Revision: 1.1.1.4 $
 * @author Kentaro Ohkouchi <nanasess@fsm.ne.jp>
 */
class DB_Sql
{

    // {{{ propaties
    
    /**
     * Ѥǡ١Υ
     * @var string $phptype
     */
    var $phptype = "pgsql";
    
    /**
     * Ѥץȥ
     * @var string $protocol
     */
    var $protocol = "tcp";

    /**
     * ³ۥ:ݡ
     * @var string $hostspec
     */
    var $hostspec = "localhost:54320";

    /**
     * ǡ١̾
     * @var string $database
     */
    var $database = "yuichat-p";

    /**
     * ³桼
     * @var string $username
     */
    var $username = "apache";

    /**
     * ³ѥ
     * @var string $password
     */
    var $password = "";

    /**
     * PEAR DB Object
     * @var object $dbObj
     */
	var $dbObj = false;
	

    // }}}
    // {{{ constructor
    
    function DB_Sql()
    {
        require_once "DB.php";
        $this->dbConnect();
    }
    
    /**
     * ǡ١³饤ʸɤEUC_JP
     *
     * @return void
     * @access public
    */
    function dbConnect()
    {
        $this->getConnection();
        $this->dbObj->query("SET CLIENT_ENCODING TO 'EUC_JP'");
    }
    
    /**
     * ³ʤ³PEAR DB Object֤
     *
     * @return object $dbObj
     * @access public
     */
    function getConnection()
    {
        if ($this->dbObj == false) {
            return ($this->doConnect());
        }
        return $this->dbObj;
    }
    
    /**
     * DSN֤
     *
     * @return array $dsn
     * @access public
     */
    function getDSN()
    {
        $dsn = sprintf("%s://%s:%s@%s+%s/%s",
                       $this->phptype,
                       $this->username,
                       $this->password,
                       $this->protocol,
                       $this->hostspec,
                       $this->database);
        return $dsn;
    }
    
    /**
     * ǡ١³
     *
     * @return object $dbObj
     * @access public
     */
    function doConnect()
    {
        $db = DB::connect($this->getDSN());
        if (DB::isError($db)) {
            die($db->getMessage());
        }
        $this->dbObj = $db;
        return $this->dbObj;
    }
    
    /**
     * ǡ١Ȥ³
     *
     * @return void
     * @access public
     */
    function doClose()
    {
        DB::disconnect();
    }
}
?>
