/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;

public final class FileSystemUtils {
    private static final int INIT_PROBLEM = -1;
    private static final int OTHER = 0;
    private static final int WINDOWS = 1;
    private static final int UNIX = 2;
    private static final int OS;

    public static long getFreeSpace(String path) throws IOException {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        switch (OS) {
            case 1: {
                return FileSystemUtils.getFreeSpaceWindows(path);
            }
            case 2: {
                return FileSystemUtils.getFreeSpaceUnix(path);
            }
            case 0: {
                throw new IllegalStateException("Unsupported operating system");
            }
        }
        throw new IllegalStateException("Exception caught when determining operating system");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getFreeSpaceWindows(String path) throws IOException {
        String line = null;
        String[] cmdAttrbs = new String[]{"cmd.exe", "/C", "dir /-c " + path};
        Process proc = Runtime.getRuntime().exec(cmdAttrbs);
        long bytes = -1L;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            line = in.readLine();
            while (line != null) {
                int bfl = (line = line.toLowerCase()).indexOf("bytes free");
                if (bfl != -1) {
                    line = line.substring(0, bfl);
                    line = line.trim();
                    int lsl = line.lastIndexOf(32);
                    line = line.substring(lsl + 1);
                    bytes = Long.parseLong(line);
                }
                line = in.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        if (bytes == -1L) {
            throw new IOException("Command line 'dir' did not find text 'bytes free' in response for path '" + path + "'- check path is of the form 'C:'");
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getFreeSpaceUnix(String path) throws IOException {
        String[] cmdAttrbs = new String[]{"cmd.exe", "/C", "df " + path};
        Process proc = Runtime.getRuntime().exec(cmdAttrbs);
        long bytes = -1L;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line1 = in.readLine();
            String line2 = in.readLine();
            if (line2 == null) {
                throw new IOException("Command line 'df' did not return info as expected for path '" + path + "'- response on first line was '" + line1 + '\"');
            }
            StringTokenizer tok = new StringTokenizer(line2 = line2.trim(), " ");
            if (tok.countTokens() < 4) {
                throw new IOException("Command line 'df' did not return data as expected for path '" + path + "'- check path is valid");
            }
            tok.nextToken();
            tok.nextToken();
            tok.nextToken();
            String freeSpace = tok.nextToken();
            bytes = Long.parseLong(freeSpace);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        if (bytes == -1L) {
            throw new IOException("Command line 'df' did not find free space in response for path '" + path + "'- check path is valid");
        }
        return bytes;
    }

    static {
        int os = 0;
        try {
            String osName = System.getProperty("os.name");
            if (osName == null) {
                throw new IOException("os.name not found");
            }
            os = (osName = osName.toLowerCase()).indexOf("windows") != -1 ? 1 : (osName.indexOf("linux") != -1 || osName.indexOf("sun os") != -1 || osName.indexOf("sunos") != -1 || osName.indexOf("solaris") != -1 || osName.indexOf("mpe/ix") != -1 || osName.indexOf("hp-ux") != -1 || osName.indexOf("aix") != -1 || osName.indexOf("freebsd") != -1 || osName.indexOf("irix") != -1 || osName.indexOf("digital unix") != -1 || osName.indexOf("unix") != -1 || osName.indexOf("mac os x") != -1 ? 2 : 0);
        }
        catch (Exception ex) {
            os = -1;
        }
        OS = os;
    }
}

