/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.cmd;

import java.util.ArrayList;
import java.util.LinkedList;
import org.unitarou.cmd.Command;
import org.unitarou.cmd.CommandDriverListener;
import org.unitarou.cmd.RedoUndoController;
import org.unitarou.lang.NameDisplayable;
import org.unitarou.util.ArgumentChecker;

public class CommandDriver {
    private final LinkedList<Command> executedCommands_ = new LinkedList();
    private final LinkedList<Command> undoneCommands_ = new LinkedList();
    private final ArrayList<CommandDriverListener> listeners_ = new ArrayList();
    private RedoUndoController redoUndoController_ = null;

    public void clear() {
        this.executedCommands_.clear();
        this.undoneCommands_.clear();
    }

    public void execute(Command command) {
        ArgumentChecker.throwIfNull((Object)command);
        command.execute();
        this.executedCommands_.addLast(command);
        this.undoneCommands_.clear();
        for (CommandDriverListener listener : this.listeners_) {
            listener.executed(command);
        }
    }

    public Command redo() {
        Command command = this.undoneCommands_.removeFirst();
        command.execute();
        this.executedCommands_.addLast(command);
        for (CommandDriverListener listener : this.listeners_) {
            listener.redoExecuted(command);
        }
        return command;
    }

    public String getRedoName() {
        if (this.isRedoable() && this.undoneCommands_.getFirst() instanceof NameDisplayable) {
            NameDisplayable command = (NameDisplayable)((Object)this.undoneCommands_.getFirst());
            return command.displayName();
        }
        return "";
    }

    public Command undo() {
        Command command = this.executedCommands_.removeLast();
        command.undo();
        this.undoneCommands_.addFirst(command);
        for (CommandDriverListener listener : this.listeners_) {
            listener.undoExecuted(command);
        }
        return command;
    }

    public String getUndoName() {
        if (this.isUndoable() && this.executedCommands_.getLast() instanceof NameDisplayable) {
            NameDisplayable command = (NameDisplayable)((Object)this.executedCommands_.getLast());
            return command.displayName();
        }
        return "";
    }

    public boolean isUndoable() {
        return !this.executedCommands_.isEmpty();
    }

    public boolean isRedoable() {
        return !this.undoneCommands_.isEmpty();
    }

    public RedoUndoController getRedoUndoController() {
        if (this.redoUndoController_ == null) {
            this.redoUndoController_ = new RedoUndoController(this);
        }
        return this.redoUndoController_;
    }

    public void addListener(CommandDriverListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners_.add(listener);
    }

    public void removeListener(CommandDriverListener listener) {
        this.listeners_.remove(listener);
    }
}

