/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.io;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.unitarou.ml.MessageResource;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ios {
    public static final char EXTENSION_SEPARATOR = '.';
    public static final MessageResource MSG_CANT_WRITE_TO_TMP_FILE = new MessageResource(Ios.class, "mgsCantWriteToTmpFile");
    private static final Set<File> tempFiles_s_ = new HashSet<File>(1);
    static /* synthetic */ Class class$0;

    public static String calcRelativePath(String parent, String fileName) {
        String fileRoot;
        ArgumentChecker.throwIfNull((Object)parent, (Object)fileName);
        parent = FilenameUtils.separatorsToSystem(parent);
        if (parent.charAt(parent.length() - 1) != File.separatorChar) {
            parent = String.valueOf(parent) + File.separator;
        }
        fileName = FilenameUtils.separatorsToSystem(fileName);
        String parentRoot = FilenameUtils.getPrefix(parent);
        if (!parentRoot.equals(fileRoot = FilenameUtils.getPrefix(fileName))) {
            return null;
        }
        Queue<String> parentPathes = Ios.divide(FilenameUtils.getPath(parent));
        Queue<String> filePathes = Ios.divide(FilenameUtils.getPath(fileName));
        while (!parentPathes.isEmpty() && !filePathes.isEmpty() && parentPathes.peek().equals(filePathes.peek())) {
            parentPathes.poll();
            filePathes.poll();
        }
        StringBuilder builder = new StringBuilder();
        while (parentPathes.poll() != null) {
            builder.append("..").append(File.separatorChar);
        }
        for (String dir : filePathes) {
            builder.append(dir).append(File.separatorChar);
        }
        if (builder.length() != 0 && builder.charAt(builder.length() - 1) != File.separatorChar) {
            builder.append(File.separator);
        }
        builder.append(FilenameUtils.getName(fileName));
        return builder.toString();
    }

    public static String calcCommonRoot(File folderA, File folderB) {
        String rootB;
        String pathA = Ios.getFullPath(folderA);
        String pathB = Ios.getFullPath(folderB);
        String rootA = FilenameUtils.getPrefix(pathA);
        if (!rootA.equals(rootB = FilenameUtils.getPrefix(pathB))) {
            return null;
        }
        pathA = pathA.substring(rootA.length());
        pathB = pathB.substring(rootB.length());
        Queue<String> pathesA = Ios.divide(FilenameUtils.getPath(pathA));
        Queue<String> pathesB = Ios.divide(FilenameUtils.getPath(pathB));
        StringBuilder builder = new StringBuilder(rootA);
        while (!pathesA.isEmpty() && !pathesB.isEmpty() && pathesA.peek().equals(pathesB.peek())) {
            builder.append(pathesA.poll()).append(File.separator);
            pathesB.poll();
        }
        return builder.toString();
    }

    public static boolean isChild(File folderA, File folderB) {
        String rootB;
        String pathA = Ios.getFullPath(folderA);
        String pathB = Ios.getFullPath(folderB);
        String rootA = FilenameUtils.getPrefix(pathA);
        if (!rootA.equals(rootB = FilenameUtils.getPrefix(pathB))) {
            return false;
        }
        pathA = FilenameUtils.getPath(pathA.substring(rootA.length()));
        pathB = FilenameUtils.getPath(pathB.substring(rootB.length()));
        return pathB.startsWith(pathA);
    }

    private static Queue<String> divide(String path) {
        StringTokenizer stringTokenizer = new StringTokenizer(path, File.separator);
        LinkedList<String> ret = new LinkedList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            ret.add(stringTokenizer.nextToken());
        }
        return ret;
    }

    private static String getFullPath(File file) {
        String path = file.getAbsolutePath();
        if (file.isDirectory() && path.charAt(path.length() - 1) != File.separatorChar) {
            return String.valueOf(path) + File.separator;
        }
        return path;
    }

    public static File getCurrentDirectory() {
        return new File(".").getAbsoluteFile().getParentFile().getAbsoluteFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTemporaryFile(File baseFile, int digit) throws IOException {
        ArgumentChecker.throwIfNull((Object)baseFile);
        if (digit <= 0) {
            throw new IllegalArgumentException();
        }
        String absolutePath = baseFile.getAbsolutePath();
        String fullPath = FilenameUtils.getFullPath(absolutePath);
        String baseName = FilenameUtils.getBaseName(absolutePath);
        String extension = FilenameUtils.getExtension(absolutePath);
        int maxNo = 1;
        StringBuilder builder = new StringBuilder(digit);
        int i = 0;
        while (i < digit) {
            builder.append('0');
            maxNo *= 10;
            ++i;
        }
        DecimalFormat decimalFormat = new DecimalFormat(builder.toString());
        int i2 = 1;
        while (i2 <= maxNo - 1) {
            File tmpFile = new File(String.valueOf(fullPath) + File.separator + baseName + decimalFormat.format(i2) + '.' + extension);
            if (!tmpFile.exists()) {
                tmpFile.createNewFile();
                tmpFile.deleteOnExit();
                Set<File> set = tempFiles_s_;
                synchronized (set) {
                    tempFiles_s_.add(tmpFile);
                }
                return tmpFile;
            }
            ++i2;
        }
        throw new IOException();
    }

    public static boolean isTemporaryFile(File file) {
        return tempFiles_s_.contains(file);
    }

    protected Ios() {
    }
}

