/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.unitarou.io.Ios;
import org.unitarou.jface.FileNameLabelProvider;
import org.unitarou.jface.FolderListener;
import org.unitarou.jface.FolderTreeContentProvider;
import org.unitarou.jface.ImageResource;
import org.unitarou.ml.MessageResource;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;

public class FolderTreeViewer
implements WidgetContainer {
    private static final ImageResource IMG_UP_NAVI = new ImageResource(FolderTreeViewer.class, "upNavi.png");
    private static final ImageResource IMG_UP_NAVI_D = new ImageResource(FolderTreeViewer.class, "upNaviD.png");
    private static final ImageResource IMG_DOWN_NAVI = new ImageResource(FolderTreeViewer.class, "downNavi.png");
    private static final ImageResource IMG_DOWN_NAVI_D = new ImageResource(FolderTreeViewer.class, "downNaviD.png");
    private static final ImageResource IMG_DRIVE = new ImageResource(FolderTreeViewer.class, "drive.png");
    private static final MessageResource NT_TT_CHANGEDRIVE = new MessageResource(FolderTreeViewer.class, "ntTtChangedrive");
    private static final MessageResource NT_TT_UPFOLDER = new MessageResource(FolderTreeViewer.class, "ntTtUpfolder");
    private static final MessageResource NT_TT_DOWNFOLDER = new MessageResource(FolderTreeViewer.class, "ntTtDownfolder");
    private static final MessageResource NT_TITLE_FAILURE_CHANGEDRIVE = new MessageResource(FolderTreeViewer.class, "ntTitleFailureChangedrive");
    private static final MessageResource MSG_FAILURE_CHANGEDRIVE = new MessageResource(FolderTreeViewer.class, "msgFailureChangedrive");
    private File root_ = new File(".").getAbsoluteFile().getParentFile();
    private ToolItem tiRoots_ = null;
    private ToolItem tiUpNavi_ = null;
    private ToolItem tiDownNavi_ = null;
    private final DownNaviSelectionListener listener_ = new DownNaviSelectionListener();
    private CLabel clbRoot_ = null;
    private TreeViewer treeViewer_ = null;
    private final Set<FolderListener> listeners_ = new HashSet<FolderListener>();
    private File folder_ = this.root_;
    static /* synthetic */ Class class$0;

    public Control createContents(Composite parent) {
        ArgumentChecker.throwIfNull((Object)parent);
        Composite frame = new Composite(parent, 0);
        frame.setLayout(new GridLayout(1, false));
        final ToolBar toolBar = new ToolBar(frame, 0x800000);
        final Menu menu = this.createRootsMenu(parent.getShell());
        final ToolItem item = new ToolItem(toolBar, 4);
        item.setToolTipText(NT_TT_CHANGEDRIVE.get());
        item.setImage(IMG_DRIVE.get());
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    Rectangle rect = item.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    pt = toolBar.toDisplay(pt);
                    menu.setLocation(pt.x, pt.y);
                    menu.setVisible(true);
                }
            }
        });
        this.tiUpNavi_ = new ToolItem(toolBar, 8);
        this.tiUpNavi_.setImage(IMG_UP_NAVI.get());
        this.tiUpNavi_.setDisabledImage(IMG_UP_NAVI_D.get());
        this.tiUpNavi_.addSelectionListener(new UpNaviSelectionListener());
        this.tiDownNavi_ = new ToolItem(toolBar, 8);
        this.tiDownNavi_.setImage(IMG_DOWN_NAVI.get());
        this.tiDownNavi_.setDisabledImage(IMG_DOWN_NAVI_D.get());
        this.tiDownNavi_.addSelectionListener(this.listener_);
        this.tiDownNavi_.setEnabled(false);
        toolBar.pack();
        this.clbRoot_ = new CLabel(frame, 16384);
        this.clbRoot_.setLayoutData(new GridData(4, 1024, true, false));
        this.treeViewer_ = new TreeViewer(frame, 2820);
        this.treeViewer_.setContentProvider(new FolderTreeContentProvider());
        this.treeViewer_.setLabelProvider(new FileNameLabelProvider());
        this.treeViewer_.getControl().setLayoutData(new GridData(4, 4, true, true));
        this.treeViewer_.addPostSelectionChangedListener(this.listener_);
        this.rootChanted();
        return frame;
    }

    private Menu createRootsMenu(Shell shell) {
        RootsSelectionListener listener = new RootsSelectionListener();
        Menu menu = new Menu(shell, 8);
        File[] fileArray = File.listRoots();
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File file = fileArray[n];
            MenuItem item = new MenuItem(menu, 16);
            item.setText(file.getPath());
            item.setData(file);
            item.setImage(IMG_DRIVE.get());
            item.addSelectionListener(listener);
            if (this.root_.getPath().startsWith(file.getPath())) {
                item.setSelection(true);
            }
            ++n;
        }
        return menu;
    }

    private void rootChanted() {
        this.clbRoot_.setText(this.root_.getPath());
        if (this.treeViewer_ != null) {
            this.treeViewer_.setInput(this.root_);
            this.treeViewer_.setSelection(new StructuredSelection(this.folder_), true);
        }
        this.tiUpNavi_.setEnabled(this.root_.getParentFile() != null);
        if (this.tiUpNavi_.isEnabled()) {
            this.tiUpNavi_.setToolTipText(NT_TT_UPFOLDER.get((Object)this.root_.getParent()));
        }
    }

    public void dispose() {
    }

    public File getRoot() {
        return this.root_;
    }

    public File getFolder() {
        return this.folder_;
    }

    public void setRoot(File newRoot) {
        ArgumentChecker.throwIfNull((Object)newRoot);
        if (!newRoot.isDirectory()) {
            throw new IllegalArgumentException("Parameter must be a directory: " + newRoot.getPath());
        }
        this.root_ = newRoot;
        if (!Ios.isChild(this.root_, this.folder_)) {
            this.folder_ = this.root_;
        }
        this.rootChanted();
    }

    public void setFolder(File newFolder) {
        ArgumentChecker.throwIfNull((Object)newFolder);
        if (!newFolder.isDirectory()) {
            throw new IllegalArgumentException("Parameter must be a directory: " + newFolder.getPath());
        }
        this.folder_ = newFolder;
        String cr = Ios.calcCommonRoot(this.root_, this.folder_);
        this.root_ = cr != null ? new File(cr) : this.folder_;
        this.rootChanted();
    }

    public void addListener(FolderListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners_.add(listener);
    }

    public void removeListener(FolderListener listener) {
        this.listeners_.remove(listener);
    }

    private class RootsSelectionListener
    extends SelectionAdapter {
        RootsSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            File file = (File)e.widget.getData();
            if (file.canRead()) {
                FolderTreeViewer.this.root_ = file;
                FolderTreeViewer.this.rootChanted();
                return;
            }
            MenuItem menuItem = (MenuItem)e.widget;
            menuItem.setSelection(false);
            Menu menu = menuItem.getParent();
            MenuItem[] menuItemArray = menu.getItems();
            int n = 0;
            int n2 = menuItemArray.length;
            while (n < n2) {
                MenuItem item = menuItemArray[n];
                if (item.getData().equals(FolderTreeViewer.this.root_)) {
                    item.setSelection(true);
                    break;
                }
                ++n;
            }
            MessageDialog.openWarning(FolderTreeViewer.this.clbRoot_.getShell(), NT_TITLE_FAILURE_CHANGEDRIVE.get(), MSG_FAILURE_CHANGEDRIVE.get((Object)file.getPath()));
        }
    }

    private class UpNaviSelectionListener
    extends SelectionAdapter {
        UpNaviSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            FolderTreeViewer.this.root_ = FolderTreeViewer.this.root_.getParentFile();
            FolderTreeViewer.this.rootChanted();
        }
    }

    private class DownNaviSelectionListener
    extends SelectionAdapter
    implements ISelectionChangedListener {
        DownNaviSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (FolderTreeViewer.this.folder_ != null && FolderTreeViewer.this.folder_.getParentFile() != null) {
                FolderTreeViewer.this.root_ = FolderTreeViewer.this.folder_.getParentFile();
                FolderTreeViewer.this.rootChanted();
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            File newfolder = (File)selection.getFirstElement();
            if (newfolder == null || !newfolder.canRead()) {
                FolderTreeViewer.this.tiDownNavi_.setEnabled(false);
                return;
            }
            FolderTreeViewer.this.folder_ = newfolder;
            boolean hasChild = false;
            File[] fileArray = FolderTreeViewer.this.folder_.listFiles();
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                File file = fileArray[n];
                if (file.isDirectory()) {
                    hasChild = true;
                    break;
                }
                ++n;
            }
            FolderTreeViewer.this.tiDownNavi_.setEnabled(hasChild);
            if (hasChild) {
                FolderTreeViewer.this.tiDownNavi_.setToolTipText(NT_TT_DOWNFOLDER.get((Object)FolderTreeViewer.this.folder_.getName()));
            }
            for (FolderListener listener : FolderTreeViewer.this.listeners_) {
                listener.folderChanged(FolderTreeViewer.this.folder_);
            }
        }
    }
}

