/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.unitarou.util.ArgumentChecker;

public class FontResource {
    private static final FontRegistry fontRegistry_s_ = JFaceResources.getFontRegistry();
    private static final char DELIMITER = '_';
    private static final FontData DEFAULT = new FontData();
    private final String fontName_;
    private final int defaultHeight_;
    private final int defaultStyle_;
    private final String defaultKey_;

    public FontResource(int height, int style) {
        this.fontName_ = DEFAULT.getName();
        this.defaultHeight_ = height;
        this.defaultStyle_ = style;
        this.defaultKey_ = this.makeKey(this.fontName_, this.defaultHeight_, this.defaultStyle_);
        if (!fontRegistry_s_.hasValueFor(this.defaultKey_)) {
            fontRegistry_s_.put(this.defaultKey_, new FontData[]{new FontData(this.fontName_, this.defaultHeight_, this.defaultStyle_)});
        }
    }

    public FontResource(String symbolicName, int height, int style) {
        ArgumentChecker.throwIfNull((Object)symbolicName);
        this.fontName_ = symbolicName;
        this.defaultHeight_ = height;
        this.defaultStyle_ = style;
        this.defaultKey_ = this.makeKey(this.fontName_, this.defaultHeight_, this.defaultStyle_);
        if (!fontRegistry_s_.hasValueFor(this.defaultKey_)) {
            fontRegistry_s_.put(this.defaultKey_, new FontData[]{new FontData(this.fontName_, this.defaultHeight_, this.defaultStyle_)});
        }
    }

    private String makeKey(String fontName, int height, int style) {
        StringBuilder sb = new StringBuilder(fontName.length() + 40);
        sb.append(this.getClass().getName()).append('_');
        sb.append(fontName).append('_');
        sb.append(height).append('_');
        if (style == 0) {
            sb.append('N');
        } else {
            if ((style & 1) != 0) {
                sb.append('B');
            }
            if ((style & 2) != 0) {
                sb.append('I');
            }
        }
        return sb.toString();
    }

    public Font get() {
        return fontRegistry_s_.get(this.defaultKey_);
    }

    public Font get(int height) {
        if (height == this.defaultHeight_) {
            return this.get();
        }
        if (height <= 0) {
            return this.get();
        }
        String key = this.makeKey(this.fontName_, height, this.defaultStyle_);
        if (!fontRegistry_s_.hasValueFor(key)) {
            fontRegistry_s_.put(key, new FontData[]{new FontData(this.fontName_, height, this.defaultStyle_)});
        }
        Font font = fontRegistry_s_.get(key);
        return font;
    }

    public Font getInCircle(GC gc, String text, int diameter) {
        ArgumentChecker.throwIfNull((Object)gc, (Object)text);
        gc.setFont(this.get());
        int oldH = gc.getFont().getFontData()[0].getHeight();
        Point p = gc.textExtent(text);
        int newHeight = (int)((double)oldH * (double)diameter / ((double)Math.max(p.x, p.y) * 1.4142));
        if (newHeight <= 0) {
            newHeight = 1;
        }
        return this.get(newHeight);
    }

    public Font getInRect(GC gc, String text, Point size) {
        ArgumentChecker.throwIfNull((Object)gc, (Object)text);
        gc.setFont(this.get());
        int oldH = gc.getFont().getFontData()[0].getHeight();
        Point p = gc.textExtent(text);
        double newRatio = Math.min((double)size.x / (double)p.x, (double)size.y / (double)p.y);
        int newHeight = (int)((double)oldH * newRatio);
        if (newHeight <= 0) {
            newHeight = 1;
        }
        return this.get(newHeight);
    }
}

