/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.unitarou.lang.Classes;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageResource {
    private static final ImageRegistry imageRegistry_s_ = JFaceResources.getImageRegistry();
    protected final String key_;

    public static void put(Class clazz, String key, ImageData data) {
        ArgumentChecker.throwIfNull((Object)clazz, (Object)key, (Object)data);
        String ck = Classes.uniqueKey(clazz, key);
        imageRegistry_s_.put(ck, ImageDescriptor.createFromImageData(data));
    }

    public static Image get(Class clazz, String key) {
        ArgumentChecker.throwIfNull((Object)clazz, (Object)key);
        return imageRegistry_s_.get(Classes.uniqueKey(clazz, key));
    }

    public ImageResource(Class<?> clazz, String filename) {
        ArgumentChecker.throwIfNull(clazz, (Object)filename);
        this.key_ = Classes.uniqueKey(clazz, filename);
        imageRegistry_s_.put(this.key_, ImageDescriptor.createFromFile(clazz, filename));
    }

    public Image get() {
        return imageRegistry_s_.get(this.key_);
    }

    public ImageData getImageData() {
        return imageRegistry_s_.getDescriptor(this.key_).getImageData();
    }
}

