/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.lang;

import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Classes {
    private static final char SEPARATOR = '.';
    private static final char METHOD_SEPARATOR = '#';
    private static final char OBJECT_SEPARATOR = '/';

    public static String simpleName(Class<?> clazz) {
        ArgumentChecker.throwIfNull(clazz);
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        return name.substring(index + 1);
    }

    public static String packageName(Class<?> clazz) {
        ArgumentChecker.throwIfNull(clazz);
        String name = clazz.getName();
        int packageEndIdx = name.lastIndexOf(46);
        String packageName = packageEndIdx >= 0 ? name.substring(0, packageEndIdx) : "";
        return packageName;
    }

    public static String uniqueKey(Object object, String key) {
        ArgumentChecker.throwIfNull(object, (Object)key);
        StringBuilder sb = new StringBuilder();
        sb.append(object.getClass().getName());
        sb.append('/').append(Integer.toString(System.identityHashCode(object), 16));
        sb.append('#').append(key);
        return sb.toString();
    }

    public static String uniqueKey(Class<?> clazz, String key) {
        ArgumentChecker.throwIfNull(clazz, (Object)key);
        StringBuilder sb = new StringBuilder();
        sb.append(clazz.getName());
        sb.append('#').append(key);
        return sb.toString();
    }

    protected Classes() {
    }
}

