/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.lang;

import java.text.StringCharacterIterator;

public class Strings {
    public static final String EMPTY = "";
    public static final String NULL_MARK = "<<null>>";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static boolean equalsIgnoreEolType(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        StringCharacterIterator i1 = new StringCharacterIterator(s1);
        StringCharacterIterator i2 = new StringCharacterIterator(s2);
        char c1 = i1.first();
        char c2 = i2.first();
        while (true) {
            if (c1 == '\r' && (c1 = i1.next()) != '\n') {
                c1 = i1.previous();
            }
            if (c2 == '\r' && (c2 = i2.next()) != '\n') {
                c2 = i2.previous();
            }
            if (!(c1 != '\r' && c1 != '\n' || c2 != '\r' && c2 != '\n')) {
                c1 = i1.next();
                c2 = i2.next();
                continue;
            }
            if (c1 != c2) break;
            if (c1 == '\uffff') {
                return true;
            }
            c1 = i1.next();
            c2 = i2.next();
        }
        return false;
    }

    public static boolean isUppercaseRomanAlphabet(char c) {
        return 'A' <= c && c <= 'Z';
    }

    public static String formatDuration(int second) {
        int min = second / 60;
        StringBuilder sb = new StringBuilder();
        sb.append(min).append(':');
        if ((second %= 60) < 10) {
            sb.append('0');
        }
        sb.append(second);
        return sb.toString();
    }

    public static String nullToNullMark(String target) {
        return target != null ? target : NULL_MARK;
    }

    protected Strings() {
    }
}

