/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf;

import java.nio.charset.Charset;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.InvalidSgfStateException;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.Application;
import org.unitarou.sgf.type.FileFormat;
import org.unitarou.sgf.type.GameMode;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfCharset;
import org.unitarou.sgf.type.SgfNumber;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.Style;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sgf.util.SgfArgumentChecker;
import org.unitarou.util.ArgumentChecker;

public class RootGameTree
extends GameTree {
    private Charset actualCharset_;

    public static RootGameTree newInstance(Application application, SgfSize size) {
        ArgumentChecker.throwIfNull((Object)application, (Object)size);
        RootGameTree ret = new RootGameTree();
        ret.setApplication(application);
        ret.setSize(size);
        return ret;
    }

    public RootGameTree() {
        this.actualCharset_ = null;
    }

    public RootGameTree(RootGameTree src) {
        super(src);
        ArgumentChecker.throwIfNull((Object)src);
        this.actualCharset_ = src.actualCharset_;
        SgfArgumentChecker.throwIfInvalid(this);
    }

    public Charset getActualCharset() {
        return this.actualCharset_;
    }

    public void setActualCharset(Charset actualCharset) {
        this.actualCharset_ = actualCharset;
    }

    public void setApplication(Application application) {
        ArgumentChecker.throwIfNull((Object)application);
        this.clearRootProperty(SgfId.APPLICATION);
        Sequence sequence = this.getSequence();
        Node node = sequence.isEmpty() ? new Node() : sequence.getFirst();
        node.addProperty(SgfId.APPLICATION.makeProperty(application));
    }

    public void setFileFormat(FileFormat fileFormat) {
        ArgumentChecker.throwIfNull((Object)fileFormat);
        Node node = BasicFinder.findNode(this.getSequence(), SgfId.FILE_FORMAT);
        if (node == null) {
            node = this.getSequence().size() != 0 ? this.getSequence().getFirst() : new Node();
        }
        node.addProperty(SgfId.FILE_FORMAT.makeProperty(fileFormat));
    }

    public void setCharset(SgfCharset charset) {
        ArgumentChecker.throwIfNull((Object)charset);
        Node node = BasicFinder.findNode(this.getSequence(), SgfId.CHARSET);
        if (node == null) {
            node = this.getSequence().size() != 0 ? this.getSequence().getFirst() : new Node();
        }
        node.addProperty(SgfId.CHARSET.makeProperty(charset));
    }

    public void setGameMode(GameMode gameMode) {
        ArgumentChecker.throwIfNull((Object)gameMode);
        Node node = BasicFinder.findNode(this.getSequence(), SgfId.GAME_MODE);
        if (node == null) {
            node = this.getSequence().size() != 0 ? this.getSequence().getFirst() : new Node();
        }
        node.addProperty(SgfId.GAME_MODE.makeProperty((SgfNumber)gameMode.typeName()));
    }

    public void setSize(SgfSize size) {
        ArgumentChecker.throwIfNull((Object)size);
        this.getRootNode().addProperty(SgfId.SIZE.makeProperty(size));
    }

    public void setStyle(Style style) {
        ArgumentChecker.throwIfNull((Object)style);
        this.getRootNode().addProperty(SgfId.STYLE.makeProperty(style));
    }

    public void setGameType(GameType gameType) {
        ArgumentChecker.throwIfNull((Object)gameType);
        this.getRootNode().addProperty(new Property("GTT", gameType.getString()));
    }

    private Node getRootNode() {
        Node node;
        Sequence sequence = this.getSequence();
        if (sequence.isEmpty()) {
            node = new Node();
            sequence.addFirst(node);
        } else {
            node = sequence.getFirst();
        }
        return node;
    }

    public Application getApplication() {
        String datum = BasicFinder.findDatum(this.getSequence(), SgfId.APPLICATION);
        if ("".equals(datum)) {
            return null;
        }
        try {
            return Application.parse(datum);
        }
        catch (TypeParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public FileFormat getFileFormat() {
        Property property = this.findInRoot(SgfId.FILE_FORMAT);
        if (property == null) {
            return FileFormat.VERSION_4;
        }
        try {
            return FileFormat.parse(property.value().getString());
        }
        catch (TypeParseException e) {
            e.printStackTrace();
            return FileFormat.VERSION_4;
        }
    }

    public SgfCharset getSgfCharset() {
        Property property = this.findInRoot(SgfId.CHARSET);
        if (property == null) {
            return new SgfCharset(Charset.defaultCharset());
        }
        return SgfCharset.parse(property.value().getString());
    }

    public SgfCharset getSgfCharset(Charset defaultCharset) {
        Property property = this.findInRoot(SgfId.CHARSET);
        if (property == null) {
            return new SgfCharset(defaultCharset);
        }
        return SgfCharset.parse(property.value().getString());
    }

    public SgfNumber getGameMode() {
        Property property = this.findInRoot(SgfId.GAME_MODE);
        if (property == null) {
            return (SgfNumber)GameMode.IGO.typeName();
        }
        return (SgfNumber)GameMode.parse(property.value().getString()).typeName();
    }

    public SgfSize getSize() {
        try {
            Property property = this.findInRoot(SgfId.SIZE);
            if (property == null) {
                return SgfSize.DEFAULT;
            }
            return SgfSize.parse(property.value().getString());
        }
        catch (TypeParseException e) {
            throw new InvalidSgfStateException(e);
        }
    }

    public Style getStyle() {
        Property property = this.findInRoot(SgfId.STYLE);
        if (property == null) {
            return Style.DEFAULT;
        }
        Style ret = Style.parse(property.value().getString());
        return ret == null ? Style.DEFAULT : ret;
    }

    public GameType getGameType() {
        Property property = this.findInRoot(SgfId.GAME_TYPE);
        if (property == null) {
            return GameType.GAME;
        }
        try {
            return GameType.parse(property.value().getString());
        }
        catch (TypeParseException e) {
            return GameType.GAME;
        }
    }

    private Property findInRoot(SgfId sgfId) {
        if (this.getSequence().isEmpty()) {
            return null;
        }
        return this.getSequence().getFirst().getProperty(sgfId);
    }

    private void clearRootProperty(SgfId type) {
        Sequence sequence = this.getSequence();
        if (sequence.isEmpty()) {
            return;
        }
        sequence.getFirst().removeProperty(type.id());
    }
}

