/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.NamedEnum;
import org.unitarou.lang.UEnum;
import org.unitarou.ml.MessageResource;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.CardinalityType;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.VersionType;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgfId
extends NamedEnum {
    private static final Messages type_s_ = Messages.createByPackage(SgfId.class, "type");
    private static final Messages typeName_s_ = Messages.createByPackage(SgfId.class, "typename");
    private static final Log logger_s_ = LogFactory.getLog(SgfId.class);
    private static final MessageResource MSG_TYPE_CANT_PARSED = new MessageResource(SgfId.class, "SgfId.msgTypeCantParsed");
    private static final MessageResource LB_UNKNOWN = new MessageResource(SgfId.class, "lbUnknown");
    private static final EnumSet<GameType> defaultTarget_s_ = EnumSet.of(GameType.GAME);
    public static final SgfId ADD_BLACK = new SgfId("AB");
    public static final SgfId ADD_EMPTY = new SgfId("AE");
    public static final SgfId ANNOTATION = new SgfId("AN");
    public static final SgfId APPLICATION = new SgfId("AP");
    public static final SgfId ARROW = new SgfId("AR");
    public static final SgfId ADD_WHITE = new SgfId("AW");
    public static final SgfId BLACK = new SgfId("B");
    public static final SgfId BLACK_TIME_LEFT = new SgfId("BL");
    public static final SgfId BAD_MOVE = new SgfId("BM");
    public static final SgfId BLACK_RANK = new SgfId("BR");
    public static final SgfId BLACK_TEAM = new SgfId("BT");
    public static final SgfId COMMENT = new SgfId("C");
    public static final SgfId CHARSET = new SgfId("CA");
    public static final SgfId COPYRIGHT = new SgfId("CP");
    public static final SgfId CIRCLE = new SgfId("CR");
    public static final SgfId DIM_POINTS = new SgfId("DD");
    public static final SgfId EVEN_POSITION = new SgfId("DM");
    public static final SgfId DOUBTFUL = new SgfId("DO");
    public static final SgfId DATE = new SgfId("DT");
    public static final SgfId EVENT = new SgfId("EV");
    public static final SgfId FILE_FORMAT = new SgfId("FF");
    public static final SgfId FIGURE = new SgfId("FG");
    public static final SgfId GOOD_FOR_BLACK = new SgfId("GB");
    public static final SgfId GAME_COMMENT = new SgfId("GC");
    public static final SgfId GAME_MODE = new SgfId("GM");
    public static final SgfId GAME_NAME = new SgfId("GN");
    public static final SgfId GAME_TYPE = new SgfId("GT");
    public static final SgfId GOOD_FOR_WHITE = new SgfId("GW");
    public static final SgfId HANDICAP = new SgfId("HA");
    public static final SgfId HOTSPOT = new SgfId("HO");
    public static final SgfId INPUT_FILES = new SgfId("IF");
    public static final SgfId INTERESTING = new SgfId("IT");
    public static final SgfId KOMI = new SgfId("KM");
    public static final SgfId KO = new SgfId("KO");
    public static final SgfId LABEL = new SgfId("LB");
    public static final SgfId LINE = new SgfId("LN");
    public static final SgfId MARK_WITH_X = new SgfId("MA");
    public static final SgfId SET_MOVE_NUMBER = new SgfId("MN");
    public static final SgfId NODENAME = new SgfId("N");
    public static final SgfId OVER_TIME_STONES_BLACK = new SgfId("OB");
    public static final SgfId OPENING = new SgfId("ON");
    public static final SgfId OVERTIME = new SgfId("OT");
    public static final SgfId OVER_TIME_STONES_WHITE = new SgfId("OW");
    public static final SgfId PLAYER_BLACK = new SgfId("PB");
    public static final SgfId PLACE = new SgfId("PC");
    public static final SgfId PLAYER_TO_PLAY = new SgfId("PL");
    public static final SgfId PRINT_MOVE_MODE = new SgfId("PM");
    public static final SgfId PROBLEM_PROPERTIES = new SgfId("PP");
    public static final SgfId PLAYER_WHITE = new SgfId("PW");
    public static final SgfId RESULT = new SgfId("RE");
    public static final SgfId ROUND = new SgfId("RO");
    public static final SgfId RULES = new SgfId("RU");
    public static final SgfId SELECTED = new SgfId("SL");
    public static final SgfId SOURCE = new SgfId("SO");
    public static final SgfId SQUARE = new SgfId("SQ");
    public static final SgfId STYLE = new SgfId("ST");
    public static final SgfId SIZE = new SgfId("SZ");
    public static final SgfId TERRITORY_BLACK = new SgfId("TB");
    public static final SgfId TESUJI = new SgfId("TE");
    public static final SgfId TIME_LAPSED = new SgfId("TL");
    public static final SgfId TIMELIMIT = new SgfId("TM");
    public static final SgfId TRIANGLE = new SgfId("TR");
    public static final SgfId TERRITORY_WHITE = new SgfId("TW");
    public static final SgfId UNCLEAR_POS = new SgfId("UC");
    public static final SgfId USER = new SgfId("US");
    public static final SgfId VALUE = new SgfId("V");
    public static final SgfId VIEW = new SgfId("VW");
    public static final SgfId WHITE_TIME_LEFT = new SgfId("WL");
    public static final SgfId WHITE_RANK = new SgfId("WR");
    public static final SgfId WHITE_TEAM = new SgfId("WT");
    public static final SgfId WHITE = new SgfId("W");
    private final String id_;
    private final VersionType version_;
    private final EnumSet<GameType> gameTypes_;
    private final String name_;
    private final PropertyType propertyType_;
    private final CardinalityType cardinalityType_;
    private final ValueType valueType_;
    static /* synthetic */ Class class$0;

    public static SgfId find(String id) {
        SgfId ret = (SgfId)UEnum.find(SgfId.class, (Comparable)((Object)Sgfs.convertRegularId(id)));
        if (ret == null) {
            ret = new SgfId(id, VersionType.get(""), defaultTarget_s_, LB_UNKNOWN.get(), PropertyType.ANY, CardinalityType.ELIST, ValueType.OTHER);
        }
        return ret;
    }

    private SgfId(String i, VersionType v, EnumSet<GameType> t, String d, PropertyType pt, CardinalityType ct, ValueType vt) {
        super((Comparable)((Object)Sgfs.convertRegularId(i)));
        this.id_ = Sgfs.convertRegularId(i);
        this.version_ = v;
        this.gameTypes_ = EnumSet.copyOf(t);
        this.name_ = d;
        this.propertyType_ = pt;
        this.cardinalityType_ = ct;
        this.valueType_ = vt;
    }

    private SgfId(String id) {
        block9: {
            super((Comparable)((Object)id));
            try {
                this.id_ = id;
                this.name_ = typeName_s_.get(this.id_);
                StringTokenizer tokenizer = new StringTokenizer(type_s_.get(this.id_), ",");
                if (!tokenizer.hasMoreTokens()) {
                    logger_s_.warn(MSG_TYPE_CANT_PARSED.get(id, "version"));
                    this.version_ = VersionType.get("");
                    this.gameTypes_ = null;
                    this.propertyType_ = null;
                    this.cardinalityType_ = null;
                    this.valueType_ = null;
                    return;
                }
                this.version_ = VersionType.get(tokenizer.nextToken().trim());
                if (!tokenizer.hasMoreTokens()) {
                    logger_s_.warn(MSG_TYPE_CANT_PARSED.get(id, "target"));
                    this.gameTypes_ = defaultTarget_s_;
                    this.propertyType_ = null;
                    this.cardinalityType_ = null;
                    this.valueType_ = null;
                    return;
                }
                this.gameTypes_ = GameType.parseSetQuietly(tokenizer.nextToken().trim(), defaultTarget_s_);
                if (!tokenizer.hasMoreTokens()) {
                    logger_s_.warn(MSG_TYPE_CANT_PARSED.get(id, "type"));
                    this.propertyType_ = null;
                    this.cardinalityType_ = null;
                    this.valueType_ = null;
                    return;
                }
                this.propertyType_ = PropertyType.valueOf(tokenizer.nextToken().trim());
                if (!tokenizer.hasMoreTokens()) {
                    logger_s_.warn(MSG_TYPE_CANT_PARSED.get(id, "cardinality"));
                    this.cardinalityType_ = null;
                    this.valueType_ = null;
                    return;
                }
                this.cardinalityType_ = CardinalityType.get(tokenizer.nextToken().trim());
                if (tokenizer.hasMoreTokens()) {
                    ValueType valueType = null;
                    String key = tokenizer.nextToken().trim();
                    try {
                        valueType = ValueType.valueOf(key);
                    }
                    catch (IllegalArgumentException exception) {
                        logger_s_.warn("Unknown type: ID:" + this.id_ + " valueType:" + key);
                        valueType = ValueType.OTHER;
                    }
                    this.valueType_ = valueType;
                    break block9;
                }
                logger_s_.warn(MSG_TYPE_CANT_PARSED.get(id, "valueType"));
                this.valueType_ = null;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    public String id() {
        return this.id_;
    }

    public VersionType version() {
        return this.version_;
    }

    public EnumSet<GameType> gameTypes() {
        return EnumSet.copyOf(this.gameTypes_);
    }

    @Override
    public String displayName() {
        return this.name_;
    }

    public PropertyType propertyType() {
        return this.propertyType_;
    }

    public CardinalityType cardinalityType() {
        return this.cardinalityType_;
    }

    public ValueType valueType() {
        return this.valueType_;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        buffer.append(", ").append(this.propertyType_);
        buffer.append(", ").append(this.cardinalityType_);
        buffer.append(", ").append((Object)this.valueType_);
        return buffer.toString();
    }

    public Property makeProperty(TypedString<?> typedString) {
        ArgumentChecker.throwIfNull(typedString);
        if (!typedString.acceptable(this)) {
            throw new IllegalArgumentException("Bad type this: " + this + ", type: " + typedString);
        }
        return new Property(this, typedString.getString());
    }

    public Property makeProperty(TypedString<?>[] types) {
        ArgumentChecker.throwIfNull(types);
        ArrayList<Value> values = new ArrayList<Value>(types.length);
        TypedString<?>[] typedStringArray = types;
        int n = 0;
        int n2 = typedStringArray.length;
        while (n < n2) {
            TypedString<?> typedString = typedStringArray[n];
            if (!typedString.acceptable(this)) {
                throw new IllegalArgumentException("Bad type this: " + this + ", type: " + typedString);
            }
            values.add(new Value(typedString.getString()));
            ++n;
        }
        Property ret = new Property();
        ret.setId(this.id_);
        ret.value().addValue(values.toArray(new Value[values.size()]));
        return ret;
    }
}

