/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf;

import org.unitarou.sgf.CardinalityType;
import org.unitarou.sgf.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ValueType {
    NONE,
    NUMBER,
    REAL,
    DOUBLE,
    COLOR,
    SIMPLE_TEXT,
    TEXT,
    POINT,
    CPOINT,
    MOVE,
    OTHER;


    public static boolean permitsMultiValues(CardinalityType type) {
        return type == CardinalityType.LIST || type == CardinalityType.ELIST;
    }

    public static boolean permitsEmpty(CardinalityType ctype, ValueType vtype) {
        return ctype == CardinalityType.ELIST || vtype == NONE;
    }

    public static boolean isVaild(CardinalityType type, Value[] values) {
        boolean ret;
        switch (values.length) {
            case 0: {
                ret = false;
                break;
            }
            case 1: {
                ret = !type.equals((Object)NONE) || values[0].getString().equals("");
                break;
            }
            default: {
                ret = ValueType.permitsMultiValues(type);
            }
        }
        return ret;
    }
}

