/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.lang.UEnum;
import org.unitarou.sgf.CardinalityType;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.util.SgfPointSet;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.util.ArgumentChecker;

public class EditProperty
extends AbstractCommand {
    public static EditType ADD_OR_REPLACE = new EditType("Add or replace");
    public static EditType DELETE = new EditType("Delete");
    private final Node node_;
    private final Property target_;
    private final Property backup_;
    private final EditType editType_;

    public EditProperty(Node node, Property target, EditType editType) {
        ArgumentChecker.throwIfNull((Object)node, (Object)target, (Object)editType);
        this.node_ = node;
        this.target_ = target;
        this.backup_ = this.node_.getProperty(this.target_.sgfId());
        this.editType_ = editType;
    }

    public EditType getEditType() {
        return this.editType_;
    }

    public SgfId getSgfId() {
        return this.target_.sgfId();
    }

    public void execute() {
        super.execute();
        if (this.backup_ == null) {
            if (ADD_OR_REPLACE.equals(this.editType_)) {
                this.node_.addProperty(this.target_);
            }
            return;
        }
        CardinalityType ct = this.target_.sgfId().cardinalityType();
        if (CardinalityType.SINGLE.equals(ct)) {
            if (ADD_OR_REPLACE.equals(this.editType_)) {
                this.node_.addProperty(this.target_);
            } else if (DELETE.equals(this.editType_)) {
                this.node_.removeProperty(this.target_.getId());
            }
            return;
        }
        if (CardinalityType.LIST.equals(ct)) {
            this.editList();
            return;
        }
        if (CardinalityType.ELIST.equals(ct)) {
            this.editEList();
            return;
        }
        assert (false) : "Unknown cardinality : " + ct;
    }

    private void editList() {
        ValueType vt = this.target_.sgfId().valueType();
        if (ValueType.POINT.equals((Object)vt)) {
            this.editListByPoint();
        } else if (SgfId.LABEL.equals(this.target_.sgfId())) {
            this.editListByLabel();
        } else {
            this.editListByOther();
        }
    }

    private void editEList() {
        String[] stringArray = this.target_.value().getStrings();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String datum = stringArray[n];
            if ("".equals(datum)) {
                this.node_.removeProperty(this.target_.getEntireId());
                this.node_.addProperty(this.target_);
                return;
            }
            ++n;
        }
        ValueType vt = this.target_.sgfId().valueType();
        if (ValueType.POINT.equals((Object)vt)) {
            this.editListByPoint();
        } else {
            this.editListByOther();
        }
    }

    private void editListByPoint() {
        SgfPointSet sgfPointSet = new SgfPointSet();
        sgfPointSet.add(SgfPoint.parse(SgfSize.MAX, this.backup_.value().getStrings()));
        if (ADD_OR_REPLACE.equals(this.editType_)) {
            sgfPointSet.add(SgfPoint.parse(SgfSize.MAX, this.target_.value().getStrings()));
        } else if (DELETE.equals(this.editType_)) {
            sgfPointSet.remove(SgfPoint.parse(SgfSize.MAX, this.target_.value().getStrings()));
            if (sgfPointSet.isEmpty()) {
                this.node_.removeProperty(this.target_.getId());
                return;
            }
        }
        Property edited = new Property();
        edited.setId(this.backup_.getId());
        SgfRectangle[] rectangles = sgfPointSet.getRegularRectangles();
        int i = 0;
        while (i < rectangles.length) {
            edited.value().addValue(new Value(rectangles[i].getValue()));
            ++i;
        }
        this.node_.addProperty(edited);
    }

    private void editListByLabel() {
        Property edited = new Property(this.backup_);
        String[] data = this.target_.value().getStrings();
        int i = 0;
        while (i < data.length) {
            boolean found = false;
            try {
                String dataPos = Label.parseString(data[i])[0];
                Value[] oldValue = edited.value().getValues();
                int j = 0;
                while (j < oldValue.length) {
                    String oldPos = Label.parseString(oldValue[j].getString())[0];
                    if (dataPos.equals(oldPos)) {
                        edited.value().removeValue(oldValue[j]);
                        if (ADD_OR_REPLACE.equals(this.editType_)) {
                            oldValue[j].setString(data[i]);
                            edited.value().addValue(oldValue[j]);
                        }
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found && ADD_OR_REPLACE.equals(this.editType_)) {
                    edited.value().addValue(new Value(data[i]));
                }
            }
            catch (TypeParseException e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (edited.value().size() == 0) {
            this.node_.removeProperty(edited.getId());
        } else {
            this.node_.addProperty(edited);
        }
    }

    private void editListByOther() {
        Property edited = new Property(this.backup_);
        Value[] values = this.target_.value().getValues();
        int i = 0;
        while (i < values.length) {
            edited.value().removeValue(values[i]);
            ++i;
        }
        if (ADD_OR_REPLACE.equals(this.editType_)) {
            edited.value().addValue(this.target_.value().getValues());
        }
        this.node_.removeProperty(edited.getId());
        if (edited.value().size() != 0) {
            this.node_.addProperty(edited);
        }
    }

    public void undo() {
        super.undo();
        if (this.backup_ == null) {
            this.node_.removeProperty(this.target_.getId());
        } else {
            this.node_.addProperty(this.backup_);
        }
    }

    public static class EditType
    extends UEnum {
        protected EditType(String typeName) {
            super((Comparable)((Object)typeName));
        }
    }
}

