/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.cmd.RemoveLastNode;
import org.unitarou.util.ArgumentChecker;

public class RemoveNode
extends AbstractCommand {
    private final GameTree parent_;
    private final GameTree gameTree_;
    private final Node target_;
    private final Node insertPoint_;
    private final GameTree[] children_;
    private final GameTree[] siblings_;
    private final RemoveLastNode removeLastNode_;

    public RemoveNode(GameTree gameTree, Node target) {
        ArgumentChecker.throwIfNull((Object)gameTree, (Object)target);
        this.gameTree_ = gameTree;
        this.parent_ = this.gameTree_.getParent();
        Sequence sequence = this.gameTree_.getSequence();
        if (this.gameTree_ instanceof RootGameTree && sequence.size() == 1 && 2 <= this.gameTree_.getChildrenSize()) {
            throw new IllegalArgumentException("Bad argument, can't remove root sequence.");
        }
        this.target_ = target;
        boolean found = false;
        Node point = null;
        Sequence.Iterator ip = sequence.iterator();
        while (ip.hasNext()) {
            Node node = (Node)ip.next();
            if (node != this.target_) continue;
            point = ip.hasNext() ? (Node)ip.next() : null;
            found = true;
            break;
        }
        this.insertPoint_ = point;
        if (!found) {
            throw new IllegalArgumentException("Can't find target node(" + this.target_ + ") in the sequence (" + sequence + ')');
        }
        if (sequence.size() == 1) {
            this.children_ = gameTree.getChildren();
            this.siblings_ = this.parent_.getChildren();
        } else {
            this.children_ = null;
            this.siblings_ = null;
        }
        this.removeLastNode_ = this.gameTree_.getSequence().getLast() == this.target_ && this.gameTree_.getChildrenSize() == 0 ? new RemoveLastNode(this.parent_, this.gameTree_) : null;
    }

    public void execute() {
        super.execute();
        if (this.removeLastNode_ != null) {
            this.removeLastNode_.execute();
            return;
        }
        Sequence sequence = this.gameTree_.getSequence();
        sequence.remove(this.target_);
        if (sequence.size() != 0) {
            return;
        }
        this.parent_.removeGameTree(this.gameTree_);
        GameTree[] gameTreeArray = this.children_;
        int n = 0;
        int n2 = gameTreeArray.length;
        while (n < n2) {
            GameTree child = gameTreeArray[n];
            this.gameTree_.removeGameTree(child);
            this.parent_.addGameTree(child);
            ++n;
        }
    }

    public void undo() {
        GameTree child;
        GameTree sibling;
        super.undo();
        if (this.removeLastNode_ != null) {
            this.removeLastNode_.undo();
            return;
        }
        Sequence sequence = this.gameTree_.getSequence();
        if (this.insertPoint_ != null) {
            sequence.insert(this.target_, this.insertPoint_);
        } else {
            sequence.addLast(this.target_);
        }
        if (sequence.size() != 1) {
            return;
        }
        GameTree[] gameTreeArray = this.siblings_;
        int n = 0;
        int n2 = gameTreeArray.length;
        while (n < n2) {
            sibling = gameTreeArray[n];
            this.parent_.removeGameTree(sibling);
            ++n;
        }
        gameTreeArray = this.children_;
        n = 0;
        n2 = gameTreeArray.length;
        while (n < n2) {
            child = gameTreeArray[n];
            this.parent_.removeGameTree(child);
            ++n;
        }
        gameTreeArray = this.siblings_;
        n = 0;
        n2 = gameTreeArray.length;
        while (n < n2) {
            sibling = gameTreeArray[n];
            this.parent_.addGameTree(sibling);
            ++n;
        }
        gameTreeArray = this.children_;
        n = 0;
        n2 = gameTreeArray.length;
        while (n < n2) {
            child = gameTreeArray[n];
            this.gameTree_.addGameTree(child);
            ++n;
        }
    }
}

