/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.io;

import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.io.FileSnapshot;
import org.unitarou.lang.Exceptions;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.parser.SgfParser;
import org.unitarou.sgf.parser.SgfParserException;
import org.unitarou.sgf.parser.SgfParserLogger;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sgf.util.filter.BasicFilter;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.FilterException;
import org.unitarou.util.StopWatch;

public final class CollectionRepository {
    private static final CollectionRepository instance_s_ = new CollectionRepository();
    private static final Log log_s_ = LogFactory.getLog(CollectionRepository.class);
    private static final MessageResource NT_CANT_READ_FILE = new MessageResource(CollectionRepository.class, "ntCantReadFile");
    private static final MessageResource NT_BAD_TYPE_FOR_DRILL = new MessageResource(SgfParser.class, "ntBadTypeForDrill");
    private static final MessageResource NT_FILE_NOT_FOUND_IN_DRILL = new MessageResource(SgfParser.class, "ntFileNotFoundInDrill");
    private static final MessageResource NT_FILE_IS_NOT_PROBLEM = new MessageResource(SgfParser.class, "ntFileIsNotProblem");
    private final Map<File, SoftReference<Collection>> fileCacheMap_ = new HashMap<File, SoftReference<Collection>>();
    private final Random random_ = new Random();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static CollectionRepository instance() {
        return instance_s_;
    }

    private CollectionRepository() {
    }

    public Collection retrieve(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        StopWatch stopWatch = new StopWatch();
        SgfParser sgfParser = new SgfParser();
        try {
            Collection cached;
            SoftReference<Collection> sr = this.fileCacheMap_.get(file);
            Collection collection = cached = sr != null ? sr.get() : null;
            if (cached == null || !this.isSameContents(cached.getFileSnapshot(), file)) {
                Collection collection2 = sgfParser.parse(file);
                this.fileCacheMap_.put(file, new SoftReference<Collection>(new Collection(collection2)));
                if (log_s_.isTraceEnabled()) {
                    log_s_.trace("Loaded " + stopWatch.stopSecond() + " secs for " + file);
                }
                return collection2;
            }
            if (log_s_.isTraceEnabled()) {
                log_s_.trace("Cache  " + stopWatch.stopSecond() + " secs for " + file);
            }
            return new Collection(cached);
        }
        catch (SgfParserException e) {
            SgfParserLogger logger = new SgfParserLogger();
            logger.info(0, NT_CANT_READ_FILE.get(file.getAbsoluteFile(), Exceptions.getRootMessage(e)), "");
            log_s_.debug("Instracted unreadable file:" + file.getAbsolutePath(), e);
            return new Collection();
        }
    }

    private boolean isSameContents(FileSnapshot snapshot, File file2) {
        if (snapshot == null || file2 == null) {
            return false;
        }
        return snapshot.file().equals(file2) && snapshot.lastModified() == file2.lastModified() && snapshot.length() == file2.length();
    }

    public void loadProblem(Collection collection) {
        RootGameTree rootGameTree;
        String[] paths;
        ArgumentChecker.throwIfNull((Object)collection);
        if (collection.size() < 1 || !collection.get(0).getGameType().equals(GameType.DRILL) || collection.getFile() == null) {
            return;
        }
        StopWatch stopWatch = new StopWatch();
        SgfParserLogger logger = collection.getParserLog();
        File rootPath = collection.getFile();
        if (1 < collection.size()) {
            while (collection.size() < 1) {
                collection.remove(collection.get(collection.size() - 1));
            }
            collection.setFile(null);
            logger.warn(1, NT_BAD_TYPE_FOR_DRILL.get(), "");
        }
        paths = (paths = BasicFinder.findData((rootGameTree = collection.get(0)).getSequence(), SgfId.INPUT_FILES)) == null ? new String[]{} : paths;
        String value = BasicFinder.findDatum(rootGameTree.getSequence(), SgfId.PROBLEM_PROPERTIES);
        ProblemProperties pp = ProblemProperties.parsePpQuietly(value);
        String[] stringArray = paths;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String path = stringArray[n];
            path = Sgfs.unescapeIfForRead(path);
            File file = new File(rootPath.getParent(), path);
            if (!file.exists() || !file.isFile()) {
                logger.warn(1, NT_FILE_NOT_FOUND_IN_DRILL.get(), file.getPath());
            } else {
                this.appendProblem(collection, file, pp);
            }
            ++n;
        }
        if (pp.contains(ProblemProperties.Flag.SHUFFLE)) {
            int problemSize = collection.size() - 1;
            int i = 1;
            while (i < problemSize) {
                RootGameTree rgt = collection.get(this.random_.nextInt(problemSize) + 1);
                collection.remove(rgt);
                collection.addLast(rgt);
                ++i;
            }
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("Costs " + stopWatch.stopSecond() + " secs");
        }
    }

    private void appendProblem(Collection collection, File file, ProblemProperties pp) {
        Collection problems = this.retrieve(file);
        SgfParserLogger logger = problems.getParserLog();
        int i = 0;
        while (i < problems.size()) {
            RootGameTree rootGameTree = problems.get(i);
            if (!rootGameTree.getGameType().equals(GameType.PROBLEM)) {
                logger.info(0, NT_FILE_IS_NOT_PROBLEM.get(), String.valueOf(i + 1));
            } else {
                try {
                    if (pp.contains(ProblemProperties.Flag.MIRROR_ROTATE)) {
                        BasicFilter.mirrorRotate(rootGameTree, this.random_.nextInt(8));
                    }
                    collection.addLast(rootGameTree);
                }
                catch (FilterException e1) {
                    e1.printStackTrace();
                }
            }
            ++i;
        }
    }
}

