/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.parser;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.parser.BadCharsetException;
import org.unitarou.sgf.parser.SgfParserReader;
import org.unitarou.util.ArgumentChecker;

final class NioReader
implements SgfParserReader {
    private static final Log log_s_ = LogFactory.getLog(NioReader.class);
    private final ByteBuffer byteBuffer_;
    private final Charset defaultCharset_;
    private final Set<Charset> triedCharsets_;
    private int rgtStartPos_;
    private CharsetDecoder rgtDecoder_;
    private final CharBuffer charBuffer_;
    private int lineNumber_ = 1;
    private boolean isLastCharacterCR_ = false;
    private int markedLineNubmer_ = -1;
    private boolean markedIsLastCharacterCR_;
    static /* synthetic */ Class class$0;

    public NioReader(ByteBuffer byteBuffer, Charset defaultCharset) {
        ArgumentChecker.throwIfNull((Object)byteBuffer, (Object)defaultCharset);
        this.byteBuffer_ = byteBuffer.asReadOnlyBuffer();
        this.byteBuffer_.rewind();
        this.defaultCharset_ = defaultCharset;
        this.triedCharsets_ = new HashSet<Charset>(2);
        this.charBuffer_ = CharBuffer.allocate(1);
        this.markRootGameTree();
    }

    public void markRootGameTree() {
        this.rgtStartPos_ = this.byteBuffer_.position();
        this.triedCharsets_.clear();
        this.rgtDecoder_ = this.defaultCharset_.newDecoder();
        this.rgtDecoder_.onMalformedInput(CodingErrorAction.REPLACE);
        this.rgtDecoder_.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public boolean setCharset(Charset newCharset) {
        ArgumentChecker.throwIfNull((Object)newCharset);
        if (this.triedCharsets_.contains(newCharset)) {
            return false;
        }
        this.logChasetChange(newCharset);
        this.rgtDecoder_ = newCharset.newDecoder();
        this.rgtDecoder_.onMalformedInput(CodingErrorAction.REPORT);
        this.rgtDecoder_.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.triedCharsets_.add(newCharset);
        this.byteBuffer_.rewind();
        this.byteBuffer_.position(this.rgtStartPos_);
        return true;
    }

    private void logChasetChange(Charset newCharset) {
        if (!log_s_.isDebugEnabled()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        if (this.rgtDecoder_ != null) {
            builder.append(this.rgtDecoder_.charset()).append("->");
        }
        builder.append(newCharset);
        log_s_.debug(builder.toString());
    }

    public Charset getCharset() {
        return this.rgtDecoder_.charset();
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset_;
    }

    public int read() throws BadCharsetException {
        if (this.byteBuffer_.position() == this.byteBuffer_.limit()) {
            return -1;
        }
        int lastPos = this.byteBuffer_.position();
        this.charBuffer_.clear();
        CoderResult cr = this.rgtDecoder_.decode(this.byteBuffer_, this.charBuffer_, false);
        if (lastPos == this.byteBuffer_.position()) {
            log_s_.info("Bad encoding: skip at line " + this.lineNumber_);
            this.byteBuffer_.position(lastPos + 1);
        }
        if (cr.isMalformed()) {
            log_s_.info("Bad encoding: Malformed at line " + this.lineNumber_);
            throw new BadCharsetException();
        }
        char c = this.charBuffer_.get(0);
        this.countLineNumber(c);
        return c;
    }

    public void mark(int readAheadLimit) {
        this.byteBuffer_.mark();
        this.markedLineNubmer_ = this.lineNumber_;
        this.markedIsLastCharacterCR_ = this.isLastCharacterCR_;
    }

    public void reset() {
        this.byteBuffer_.reset();
        this.lineNumber_ = this.markedLineNubmer_;
        this.isLastCharacterCR_ = this.markedIsLastCharacterCR_;
    }

    public int getLineNumber() {
        return this.lineNumber_;
    }

    private void countLineNumber(int character) {
        if (character == 13) {
            if (this.isLastCharacterCR_) {
                ++this.lineNumber_;
            } else {
                this.isLastCharacterCR_ = true;
            }
        } else if (character == 10) {
            ++this.lineNumber_;
            this.isLastCharacterCR_ = false;
        } else {
            if (this.isLastCharacterCR_) {
                ++this.lineNumber_;
            }
            this.isLastCharacterCR_ = false;
        }
    }
}

