/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.parser;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.StringCharacterIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.parser.BadCharsetException;
import org.unitarou.sgf.parser.NioReader;
import org.unitarou.sgf.parser.SgfParserLogger;
import org.unitarou.sgf.parser.SgfParserReader;
import org.unitarou.sgf.parser.WellbehavedLineNumberReader;
import org.unitarou.sgf.util.SgfArgumentChecker;
import org.unitarou.util.ArgumentChecker;

public class SgfParserCore {
    private static final Log log_s_ = LogFactory.getLog(SgfParserCore.class);
    private static final MessageResource NT_IGNORE_FILEHEAD = new MessageResource(SgfParserCore.class, "ntIgnoreFilehead");
    private static final MessageResource NT_IGNORE_INTER_TREE = new MessageResource(SgfParserCore.class, "ntIgnoreInterTree");
    private static final MessageResource NT_IGNORE_INTER_NODE = new MessageResource(SgfParserCore.class, "ntIgnoreInterNode");
    private static final MessageResource NT_IGNORE_INTER_VALUE = new MessageResource(SgfParserCore.class, "ntIgnoreInterValue");
    private static final MessageResource NT_IGNORE_ID = new MessageResource(SgfParserCore.class, "ntIgnoreId");
    private static final MessageResource NT_IGNORE_EMPTY_ID = new MessageResource(SgfParserCore.class, "ntIgnoreEmptyId");
    private static final MessageResource NT_IGNORE_MULTI_VALUES = new MessageResource(SgfParserCore.class, "ntIgnoreMultiValues");
    private static final MessageResource NT_INVALID_POSITION_ROOT_PROPERTY = new MessageResource(SgfParserCore.class, "ntInvalidPositionRootProperty");
    private static final MessageResource NT_REMOVE_INVALID_PROPERTY = new MessageResource(SgfParserCore.class, "ntRemoveInvalidIdProperty");
    private static final MessageResource NT_TRIM_ID = new MessageResource(SgfParserCore.class, "ntTrimId");
    private SgfParserLogger parserLogger_;
    private SgfParserReader reader_;
    private boolean isInputTerminated_;
    private final StringBuilder sharedBuffer_ = new StringBuilder();
    static /* synthetic */ Class class$0;

    private static boolean isAlphabet(int c) {
        return 65 <= c && c <= 90 || 97 <= c && c <= 122;
    }

    private static boolean isWhitespace(int c) {
        return Character.isWhitespace((char)c);
    }

    public SgfParserCore() {
        this.parserLogger_ = new SgfParserLogger();
    }

    @Deprecated
    public void setReader(Reader reader) {
        this.reader_ = new WellbehavedLineNumberReader(reader);
    }

    public void setByteBuffer(ByteBuffer byteBuffer, Charset defaultCharset) {
        ArgumentChecker.throwIfNull((Object)byteBuffer, (Object)defaultCharset);
        this.reader_ = new NioReader(byteBuffer, defaultCharset);
    }

    public void setParserLogger(SgfParserLogger parserLogger) {
        this.parserLogger_ = parserLogger;
    }

    public SgfParserLogger getParserLogger() {
        return this.parserLogger_;
    }

    public boolean parseCollection(Collection collection) throws IOException {
        this.reader_.markRootGameTree();
        while (true) {
            try {
                return this.parseCollectionImpl(collection);
            }
            catch (BadCharsetException e) {
                if (e.getNewCharset() != null) continue;
                this.reader_.setCharset(this.reader_.getDefaultCharset());
                continue;
            }
            break;
        }
    }

    public boolean parseCollectionImpl(Collection collection) throws IOException, BadCharsetException {
        StringBuilder utr = new StringBuilder();
        StringBuilder utrNode = new StringBuilder();
        if (!this.hasMoreRootGame(utr, utrNode)) {
            if (collection.size() != 0) {
                utr.append((CharSequence)utrNode);
                collection.get(collection.size() - 1).setCloseUtr(utr.toString());
            }
            return false;
        }
        RootGameTree rootGameTree = new RootGameTree();
        rootGameTree.setOpenUtr(utr.toString());
        if (this.parseGameTree(rootGameTree, rootGameTree)) {
            collection.addLast(rootGameTree);
            rootGameTree.getSequence().getFirst().setOpenUtr(utrNode.toString());
        }
        rootGameTree.setActualCharset(this.reader_.getCharset());
        SgfArgumentChecker.throwIfInvalid(rootGameTree);
        return true;
    }

    private boolean hasMoreRootGame(StringBuilder utrRgt, StringBuilder utrNode) throws IOException, BadCharsetException {
        boolean ret = false;
        boolean searchNodeStart = false;
        StringBuilder ignoreString = new StringBuilder();
        utrNode.delete(0, utrNode.length());
        int character = 0;
        while (true) {
            this.reader_.mark(1);
            character = this.reader_.read();
            if (character == -1) break;
            if (character == 40) {
                if (!searchNodeStart) {
                    searchNodeStart = true;
                    continue;
                }
                utrRgt.append('(');
                utrRgt.append((CharSequence)utrNode);
                utrNode.delete(0, utrNode.length());
                continue;
            }
            if (searchNodeStart && character == 59) {
                this.reader_.reset();
                ret = true;
                break;
            }
            if (!SgfParserCore.isWhitespace(character)) {
                if (searchNodeStart) {
                    searchNodeStart = false;
                    utrRgt.append('(');
                    utrRgt.append((CharSequence)utrNode);
                    utrRgt.append((char)character);
                    utrNode.delete(0, utrNode.length());
                    continue;
                }
                ignoreString.append((char)character);
                utrRgt.append((char)character);
                continue;
            }
            if (searchNodeStart) {
                utrNode.append((char)character);
                continue;
            }
            utrRgt.append((char)character);
        }
        if (ignoreString.length() != 0) {
            this.writeInfoLog(NT_IGNORE_FILEHEAD, ignoreString);
        }
        return ret;
    }

    public boolean parseGameTree(RootGameTree root, GameTree gameTree) throws IOException, BadCharsetException {
        this.parseSequence(root, gameTree, gameTree.getSequence());
        GameTree childTree = new GameTree();
        while (true) {
            StringBuilder utr2;
            if (!this.hasMoreGameTree(utr2 = new StringBuilder())) {
                assert (utr2.length() == 0 || utr2.length() > 0 && gameTree.getChildrenSize() > 0) : "Can't set utr2 in the last node.";
                if (gameTree.getChildrenSize() <= 0) break;
                gameTree.getChild(gameTree.getChildrenSize() - 1).setCloseUtr(utr2.toString());
                break;
            }
            childTree.setOpenUtr(utr2.toString());
            if (!this.parseGameTree(root, childTree)) break;
            gameTree.addGameTree(childTree);
            childTree = new GameTree();
        }
        if (gameTree.getSequence().size() != 0) {
            return true;
        }
        if (gameTree.getChildrenSize() == 0) {
            return false;
        }
        GameTree child = gameTree.getChild(0);
        gameTree.getSequence().clear();
        gameTree.getSequence().addAll(child.getSequence());
        gameTree.clearGameTree();
        GameTree[] gameTrees = child.getChildren();
        int i = 0;
        while (i < gameTrees.length) {
            gameTree.addGameTree(gameTrees[i]);
            ++i;
        }
        return true;
    }

    private boolean hasMoreGameTree(StringBuilder utr) throws IOException, BadCharsetException {
        boolean ret = false;
        StringBuilder ignoreString = new StringBuilder();
        int character = 0;
        while (true) {
            if ((character = this.reader_.read()) == 40) {
                ret = true;
                break;
            }
            if (character == -1 || character == 41) break;
            if (SgfParserCore.isWhitespace(character)) {
                utr.append((char)character);
                continue;
            }
            utr.append((char)character);
            ignoreString.append((char)character);
        }
        if (ignoreString.length() != 0) {
            this.writeWarningLog(NT_IGNORE_INTER_TREE, ignoreString);
        }
        this.isInputTerminated_ = character == -1;
        return ret;
    }

    public boolean parseSequence(RootGameTree root, GameTree parent, Sequence sequence) throws IOException, BadCharsetException {
        StringBuilder utr = new StringBuilder();
        Node node = new Node();
        while (this.parseNode(node, utr)) {
            sequence.addLast(node);
            node = new Node();
        }
        if (sequence.isEmpty()) {
            return false;
        }
        sequence.getLast().setCloseUtr(utr.toString());
        return true;
    }

    public boolean parseNode(Node node, StringBuilder utr) throws IOException, BadCharsetException {
        if (!this.hasMoreNode(utr)) {
            return false;
        }
        node.setOpenUtr(utr.toString());
        utr.delete(0, utr.length());
        Property property = new Property();
        while (this.parseProperty(property, utr)) {
            property.setOpenUtr(utr.toString());
            node.addProperty(property);
            property = new Property();
            utr.delete(0, utr.length());
        }
        node.setCloseUtr(utr.toString());
        return true;
    }

    private boolean hasMoreNode(StringBuilder utr) throws IOException, BadCharsetException {
        boolean found = false;
        StringBuilder ignoreString = new StringBuilder();
        int character = 0;
        while (true) {
            this.reader_.mark(1);
            character = this.reader_.read();
            if (character == 59) {
                found = true;
                break;
            }
            if (character == -1) break;
            if (character == 40 || character == 41) {
                this.reader_.reset();
                break;
            }
            if (SgfParserCore.isWhitespace(character)) {
                utr.append((char)character);
                continue;
            }
            utr.append((char)character);
            ignoreString.append((char)character);
        }
        if (ignoreString.length() != 0) {
            this.writeWarningLog(NT_IGNORE_INTER_NODE, ignoreString);
        }
        this.isInputTerminated_ = character == -1;
        return found;
    }

    public boolean parseProperty(Property property, StringBuilder utr) throws IOException, BadCharsetException {
        int i;
        StringBuilder utrVal = new StringBuilder();
        String entireId = this.parseIdentifier(utr, utrVal);
        if (entireId == null || entireId.length() == 0) {
            return false;
        }
        property.setEntireId(entireId);
        this.parseValues(property, utrVal);
        if (property.value().size() == 0) {
            return false;
        }
        if (!ValueType.permitsMultiValues(property.sgfId().cardinalityType()) && property.value().size() != 1) {
            Value[] values = property.value().getValues();
            StringBuilder builder = new StringBuilder(property.getEntireId());
            i = 1;
            while (i < values.length) {
                builder.append(values[i].toString());
                ++i;
            }
            this.writeWarningLog(NT_IGNORE_MULTI_VALUES, builder.toString());
            property.value().setValue(values[0]);
        }
        if (property.sgfId().equals(SgfId.CHARSET)) {
            try {
                String code = property.value().getString();
                Charset charset = Charset.forName(code);
                if (this.reader_.setCharset(charset)) {
                    throw new BadCharsetException(charset);
                }
            }
            catch (IllegalCharsetNameException code) {
            }
            catch (UnsupportedCharsetException code) {
                // empty catch block
            }
        }
        if (log_s_.isDebugEnabled() && !property.isValid()) {
            StringBuilder sb = new StringBuilder();
            sb.append("ID: '" + property.getId() + "'(" + property.getEntireId() + ")");
            String[] v = null;
            v = ValueType.permitsMultiValues(property.sgfId().cardinalityType()) ? property.value().getStrings() : new String[]{property.value().getString()};
            i = 0;
            while (i < v.length) {
                sb.append("[" + v[i] + "]");
                ++i;
            }
            log_s_.debug(sb);
            property.clear();
        }
        return true;
    }

    public String parseIdentifier(StringBuilder utrProp, StringBuilder utrVal) throws IOException, BadCharsetException {
        String id = null;
        StringBuilder ignoreString = new StringBuilder();
        StringBuilder identifier = new StringBuilder();
        int character = 0;
        while (true) {
            this.reader_.mark(1);
            character = this.reader_.read();
            if (SgfParserCore.isAlphabet(character)) {
                identifier.append((char)character);
                continue;
            }
            if (character == 91) {
                id = identifier.toString().trim();
                if (id.length() == 0) {
                    this.writeWarningLog(NT_IGNORE_EMPTY_ID, new Object());
                    utrProp.append((CharSequence)identifier);
                    utrProp.append((char)character);
                    identifier.delete(0, identifier.length());
                    continue;
                }
                String idSource = identifier.toString();
                StringCharacterIterator itr2 = new StringCharacterIterator(idSource);
                char c = itr2.last();
                while (c != '\uffff') {
                    if (!Character.isWhitespace(c)) break;
                    utrVal.insert(0, c);
                    c = itr2.previous();
                }
                int lastWhiteSpacePos = -1;
                StringCharacterIterator itr = new StringCharacterIterator(id);
                char c2 = itr.last();
                while (c2 != '\uffff') {
                    if (Character.isWhitespace(c2)) {
                        lastWhiteSpacePos = itr.getIndex();
                        break;
                    }
                    c2 = itr.previous();
                }
                if (lastWhiteSpacePos >= 0) {
                    this.writeWarningLog(NT_TRIM_ID, id);
                    id = id.substring(lastWhiteSpacePos).trim();
                }
                utrProp.append(idSource.substring(0, idSource.lastIndexOf(id)));
                break;
            }
            if (character == -1 || character == 40 || character == 41 || character == 59) {
                this.reader_.reset();
                this.isInputTerminated_ = character == -1;
                utrProp.append((CharSequence)identifier);
                break;
            }
            if (SgfParserCore.isWhitespace(character)) {
                identifier.append((char)character);
                continue;
            }
            utrProp.append((CharSequence)identifier);
            utrProp.append((char)character);
            identifier.delete(0, identifier.length());
            ignoreString.append((char)character);
        }
        if (ignoreString.length() != 0) {
            this.writeWarningLog(NT_IGNORE_ID, ignoreString);
        }
        return id;
    }

    public void parseValues(Property property, StringBuilder utr) throws IOException, BadCharsetException {
        Value value = this.parseValue(property.sgfId().valueType());
        while (value != null) {
            value.setOpenUtr(utr.toString());
            property.value().addValue(value);
            utr.delete(0, utr.length());
            Value value2 = value = this.hasMoreValue(utr) ? this.parseValue(property.sgfId().valueType()) : null;
        }
        property.setCloseUtr(utr.toString());
    }

    public Value parseValue(ValueType valueType) throws IOException, BadCharsetException {
        this.sharedBuffer_.delete(0, this.sharedBuffer_.length());
        while (true) {
            this.reader_.mark(1);
            int character = this.reader_.read();
            if (character == -1) {
                this.isInputTerminated_ = true;
                return null;
            }
            if (character == 93) {
                Value ret = new Value();
                String string = this.sharedBuffer_.toString();
                switch (valueType) {
                    case TEXT: {
                        string = Sgfs.unescapeTextForRead(string);
                        break;
                    }
                    case SIMPLE_TEXT: {
                        string = Sgfs.unescapeSimpleTextForRead(string);
                    }
                }
                ret.setString(string);
                return ret;
            }
            if (character == 92) {
                this.sharedBuffer_.append((char)character);
                character = (char)this.reader_.read();
                if (character == -1) {
                    this.isInputTerminated_ = true;
                    return null;
                }
            }
            this.sharedBuffer_.append((char)character);
        }
    }

    private boolean hasMoreValue(StringBuilder utr) throws IOException, BadCharsetException {
        int character;
        StringBuilder ignoreString;
        boolean ret;
        block3: {
            ret = false;
            ignoreString = new StringBuilder();
            while (true) {
                this.reader_.mark(1);
                character = this.reader_.read();
                if (character == 91) {
                    ret = true;
                    break block3;
                }
                if (character == -1) break block3;
                if (!SgfParserCore.isWhitespace(character)) break;
                utr.append((char)character);
            }
            this.reader_.reset();
        }
        if (ignoreString.length() != 0) {
            this.writeWarningLog(NT_IGNORE_INTER_VALUE, ignoreString);
        }
        this.isInputTerminated_ = character == -1;
        return ret;
    }

    public void writeWarningLog(MessageResource messageResource, Object parameter) {
        this.parserLogger_.warn(this.reader_.getLineNumber(), messageResource.get(), parameter.toString());
    }

    public void writeInfoLog(MessageResource messageResource, Object parameter) {
        this.parserLogger_.info(this.reader_.getLineNumber(), messageResource.get(), parameter.toString());
    }

    public boolean isInputTerminated() {
        return this.isInputTerminated_;
    }

    public void setInputTerminated(boolean isInputTerminated) {
        this.isInputTerminated_ = isInputTerminated;
    }
}

