/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.parser;

import java.util.ArrayList;
import java.util.List;
import org.unitarou.lang.UEnum;
import org.unitarou.util.ArgumentChecker;

public class SgfParserLogger {
    public static final Level INFO = new Level(0, "INFO");
    public static final Level WARN = new Level(1000, "WARN");
    public static final Level ERROR = new Level(2000, "ERROR");
    private final List<Message> messages_;

    public SgfParserLogger() {
        this.messages_ = new ArrayList<Message>();
    }

    public SgfParserLogger(SgfParserLogger src) {
        ArgumentChecker.throwIfNull((Object)src);
        this.messages_ = new ArrayList<Message>(src.messages_);
    }

    public void addMessage(Message message) {
        ArgumentChecker.throwIfNull((Object)message);
        this.messages_.add(message);
    }

    public void error(int line, String message, String fragment) {
        this.addMessage(new Message(ERROR, line, message, fragment));
    }

    public void warn(int line, String message, String fragment) {
        this.addMessage(new Message(WARN, line, message, fragment));
    }

    public void info(int line, String message, String fragment) {
        this.addMessage(new Message(INFO, line, message, fragment));
    }

    public Message[] getMessages(Level level) {
        ArgumentChecker.throwIfNull((Object)level);
        ArrayList<Message> ret = new ArrayList<Message>(this.messages_.size());
        int i = 0;
        while (i < this.messages_.size()) {
            Message message = this.messages_.get(i);
            if (level.rank_ <= message.level_.rank_) {
                ret.add(message);
            }
            ++i;
        }
        return ret.toArray(new Message[ret.size()]);
    }

    public Message[] getAllMessages() {
        return this.messages_.toArray(new Message[this.messages_.size()]);
    }

    public static class Level
    extends UEnum {
        private final int rank_;

        protected Level(int rank, String typeName) {
            super((Comparable)((Object)typeName));
            this.rank_ = rank;
        }

        public int getRank() {
            return this.rank_;
        }
    }

    public static class Message {
        private final Level level_;
        private final int line_;
        private final String message_;
        private final String fragment_;

        public Message(Level level, int line, String message, String fragment) {
            this.level_ = level;
            this.line_ = line;
            this.message_ = message;
            this.fragment_ = fragment;
        }

        public Level getLevel() {
            return this.level_;
        }

        public int getLine() {
            return this.line_;
        }

        public String getMessage() {
            return this.message_;
        }

        public String getFragment() {
            return this.fragment_;
        }
    }
}

